/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.servlet;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.spi.servlet.OsgiHttpServletRequestWrapper;
import org.ops4j.pax.web.service.spi.servlet.OsgiSessionAttributeListener;
import org.osgi.service.http.whiteboard.Preprocessor;

public class OsgiFilterChain
implements FilterChain {
    private final List<Preprocessor> preprocessors = new LinkedList<Preprocessor>();
    private final ServletContext servletContext;
    private final WebContainerContext webContext;
    private final OsgiSessionAttributeListener osgiSessionsBridge;
    private final Consumer<HttpServletRequest> authListener;
    private FilterChain chain;
    private int index = 0;

    public OsgiFilterChain(List<Preprocessor> preprocessors, ServletContext servletContext, WebContainerContext context, FilterChain originalChain, OsgiSessionAttributeListener osgiSessionsBridge, Consumer<HttpServletRequest> authListener) {
        this.preprocessors.addAll(preprocessors);
        this.webContext = context;
        this.servletContext = servletContext;
        this.chain = originalChain;
        this.osgiSessionsBridge = osgiSessionsBridge;
        this.authListener = authListener;
    }

    public void setChain(FilterChain chain) {
        this.chain = chain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        Object req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (this.index == 0 && this.servletContext != null) {
            req = new OsgiHttpServletRequestWrapper((HttpServletRequest)req, this.servletContext, this.osgiSessionsBridge);
        }
        if (this.index < this.preprocessors.size()) {
            Preprocessor filter = this.preprocessors.get(this.index++);
            filter.doFilter((ServletRequest)req, (ServletResponse)res, (FilterChain)this);
            return;
        }
        try {
            if (this.webContext == null || this.webContext.handleSecurity(req, res)) {
                if (this.authListener != null && this.webContext != null) {
                    this.authListener.accept((HttpServletRequest)req);
                }
                this.chain.doFilter((ServletRequest)req, (ServletResponse)res);
            } else if (!res.isCommitted()) {
                res.sendError(403);
            }
        }
        finally {
            if (this.webContext != null) {
                this.webContext.finishSecurity(req, res);
            }
        }
    }
}

