/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.util.concurrent.TimeUnit;
import org.eclipse.californium.elements.util.LeastRecentlyUpdatedCache;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SessionStore;
import org.eclipse.californium.scandium.util.SecretUtil;

public class InMemorySessionStore
implements SessionStore {
    private final LeastRecentlyUpdatedCache<SessionId, DTLSSession> store;

    public InMemorySessionStore(int capacity, long threshold) {
        this.store = new LeastRecentlyUpdatedCache(capacity, threshold, TimeUnit.SECONDS);
    }

    @Override
    public void put(DTLSSession session) {
        if (session != null && !session.getSessionIdentifier().isEmpty()) {
            DTLSSession clone = new DTLSSession(session);
            if (!this.store.put((Object)session.getSessionIdentifier(), (Object)clone)) {
                SecretUtil.destroy(clone);
            }
        }
    }

    @Override
    public DTLSSession get(SessionId id) {
        DTLSSession session = (DTLSSession)this.store.update((Object)id);
        return session == null ? null : new DTLSSession(session);
    }

    @Override
    public void remove(SessionId id) {
        DTLSSession session = (DTLSSession)this.store.remove((Object)id);
        SecretUtil.destroy(session);
    }
}

