# Chinese Chenzhuo Sky (3rd Century)

## Introduction

This sky culture, based on the Chen Zhuo Star Catalog, the *Three Schools’ Star Canons*, the *Cheonsang Yeolcha Bunyajido* and other star maps, strives to faithfully reconstruct the celestial landscape of the 3rd century CE. It represents the earliest state of the constellations (or star officials, xingguan星官) compiled by Chen Zhuo.

## Description

### The Evolution of Chen Zhuo Constellations

The integration of the Three Schools constellations by Chen Zhuo (230s-320s CE) is a milestone in the history of Chinese astronomy. The "Three Schools constellations" refer to those created by Shi school, Gan school, and Wu Xian school, named after Shishen (石申) and Gande (甘德) from the Warring States period and Wuxian (巫咸), a legendary astronomer from the Shang dynasty (1600 BCE - 1046 BCE). Research suggests the formation of these constellation systems occurred during the Han Dynasty (202 BCE - 220 CE). Later, during the Three Kingdoms (220 CE - 280 CE) or Western Jin (265 CE - 316 CE) period, the Grand Historian Chen Zhuo synthesized these traditions into a new system, encompassing 283 constellations and 1,464 stars.

However, over this long transmission period, the positions and shapes of Chen Zhuo constellations underwent noticeable changes due to transcription errors on star maps. The Northern Song constellations, as reflected in the Huangyou Star Catalog, the *Xin yixiang fayao* star map, and the Suzhou Star Map already show clear differences from those of Chen Zhuo and the original Three Schools in Han dynasty.

### Reconstruction of the Earliest Chen Zhuo Constellations

The primary works of Chen Zhuo and the Three Schools have been lost, and much of the early documentation of their constellations is no longer extant. While some data from the Shi school survived in Tang dynasty texts like the *Kaiyuan zhanjing* (开元占经, Divination Canon of Kaiyuan Reign) and the *Tiandi ruixiangzhi* (天地瑞祥志, Treatise on Celestial and Terrestrial Omens), early positional descriptions for the Gande and Wuxian constellations exist only in fragments. This scarcity of materials has long hindered scholars' efforts to reconstruct and understand early Chinese sky.

Recently, Boshun YANG discovered new records of stellar coordinates that differ from previously known star catalogs like Jingyou and Huangyou. These records encompass the 28 lodges (xiu) as well as constellations from the three schools. After research, he found it is a star catalog formed by Chen Zhuo based on the integration of the coordinate data of the three schools in the Han Dynasty. The Shi School data not only correct Tang Dynasty records but also include previously unrecorded information. More significantly, the Gande and Wuxian data are entirely novel and originate from Han dynasty observations. Further research indicates that these data were primarily observed during the Han Dynasty, aligning well with descriptions in the *Three Schools’ Star Canons* and early star maps like the *Cheonsang Yeolcha Bunyajido*, the Dunhuang Star Map, and the *Gezi yuejin tu*. This discovery has proven crucial for reconstructing the early Chinese sky.

The majority of the early celestial officials can be reliably restored by combining the Chen Zhuo catalogue, the *Three Schools’ Star Canons*, and the early star maps. Due to the errors in the star tables and maps, as well as the ambiguity in the early text descriptions, a small number of constellations may require further improvement.

### Scientific Value and Cultural Significance of Early Constellations

The Chinese constellation system offers unique contributions to modern astronomical research. Ancient Chinese astronomers conducted detailed and prolonged observations, leaving extensive records of phenomena like meteors, comets, guest stars, and auroras, all referenced against constellations. Restoring early constellations aids in accurately locating these events, enhancing the application of ancient records in contemporary astronomy. For instance, the early Purple Palace in this sky culture has been instrumental in identifying the ancient counterpart of the nova remnant Z Cam.

This sky culture preserves the original appearances and positions of numerous star groupings, with some examples highlighted below.

 - **Shape**: The *Huagai* (华盖, Canopy of the Emperor) constellation initially resembled some ceremonial parasols used by Han emperors, while later depictions evolved into circular or irregular shapes, losing their cultural connotation. The *Neijie* (内阶, Inner Steps) was modeled after the *Santai* (三台, Three Steps; also known as *Tianjie* (天阶, the Heavenly Steps); they serve as paths that connected the *Zigong* (紫宫, Purple Palace), *Taiwei* (太微, Supreme Palace), and *Wenchang* (文昌, Administrative Centre), symbolizing imperial pathways. Thus, it has a shape of staircase.
 - **Position**: The *Tianfu* (天桴, Celestial Drumstick) was originally located near the *Hegu* (河鼓, Drum at the River) and this position is in line with its astrological meaning. Over time, it was gradually moved downward, and its connection with *Hegu* gradually weakened. Similarly, the *Lishi* (砺石, Whetstone) was initially placed near the *Wuche* (五车, Five Chariots), whose northwest star, *Tianku* (天库, Celestial Arsenal), represented generals and military affairs. Since *Lishi* can sharpen blades, it was located below *Tianku* to assist it, aiming to make weapons sharp and achieve victory. After the Song dynasty, the Whetstone moved near the *Juanshe* (卷舌, Rolled Tongue), diverging from its original intent.

The initial shapes and arrangements of the Three Schools constellations were meticulously designed by their creators, with some configurations mirroring the forms of real-world objects, and spatial relationships encoding astrological meanings. These original meanings were often lost as the constellations evolved over time.

This sky culture is thus invaluable for uncovering the original scientific and cultural meanings embedded in early Chinese constellations.

## References

 - [#1]: Sun, X.-C., and Kistemaker, J., *The Chinese sky during the Han*. Leiden: Brill, 1997.
 - [#2]: Yang, B.-S., 2023. *Zhongguo Chuantong Hengxing Guance Jingdu ji Xingguan Yanbian Yanjiu* 中国传统恒星观测精度及星官演变研究 (A Research on the Accuracy of Chinese Traditional Star Observation and the Evolution of Constellations), PhD thesis, (Hefei: University of Science and Technology of China, 2023).
 - [#3]: Yang, B.-S., and Hoffmann, S. M., 2024. Identification of Z Cam’s Historical Counterpart: The Quest for an Ancient Nova. *Research in Astronomy and Astrophysics*. 12, 12pp.
 - [#4]: Yang, B.-S., and Chu, L.-F., 2025. A Research on Chenzhuo’s Star Catalogue in the Continuation of the Later Han Books. *The Chinese Journal for the History of Science*. 1.

## Authors

This sky culture was contributed by Dr. YANG Boshun (杨伯顺). [bsyang@ustc.edu.cn](mailto:bsyang@ustc.edu.cn)

## License

CC BY-SA 4.0
