/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt;

import com.hivemq.client.internal.mqtt.MqttClientTransportConfigImpl;
import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttTopicAliasAutoMapping;
import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttTopicAliasMapping;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.mqtt3.Mqtt3ClientConnectionConfig;
import com.hivemq.client.mqtt.mqtt5.Mqtt5ClientConnectionConfig;
import com.hivemq.client.mqtt.mqtt5.auth.Mqtt5EnhancedAuthMechanism;
import io.netty.channel.Channel;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MqttClientConnectionConfig
implements Mqtt5ClientConnectionConfig,
Mqtt5ClientConnectionConfig.RestrictionsForServer,
Mqtt5ClientConnectionConfig.RestrictionsForClient,
Mqtt3ClientConnectionConfig,
Mqtt3ClientConnectionConfig.RestrictionsForClient {
    private static final int FLAG_HAS_SIMPLE_AUTH = 1;
    private static final int FLAG_HAS_WILL_PUBLISH = 2;
    private static final int FLAG_PROBLEM_INFORMATION_REQUESTED = 4;
    private static final int FLAG_RESPONSE_INFORMATION_REQUESTED = 8;
    private static final int FLAG_RETAIN_AVAILABLE = 16;
    private static final int FLAG_WILDCARD_SUBSCRIPTION_AVAILABLE = 32;
    private static final int FLAG_SHARED_SUBSCRIPTION_AVAILABLE = 64;
    private static final int FLAG_SUBSCRIPTION_IDENTIFIERS_AVAILABLE = 128;
    private static final int FLAG_CLEAN_START = 256;
    private static final int FLAG_CLEAN_STOP = 512;
    @NotNull
    private final MqttClientTransportConfigImpl transportConfig;
    private final short keepAlive;
    private volatile int sessionExpiryInterval;
    @Nullable
    private final Mqtt5EnhancedAuthMechanism enhancedAuthMechanism;
    private final short receiveMaximum;
    private final int maximumPacketSize;
    private final short topicAliasMaximum;
    private final short sendMaximum;
    private final int sendMaximumPacketSize;
    @Nullable
    private final MqttTopicAliasMapping sendTopicAliasMapping;
    @NotNull
    private final MqttQos maximumQos;
    @NotNull
    private final Channel channel;
    private final int flags;

    public MqttClientConnectionConfig(@NotNull MqttClientTransportConfigImpl transportConfig, int keepAlive, boolean cleanStart, boolean cleanStop, long sessionExpiryInterval, boolean hasSimpleAuth, boolean hasWillPublish, @Nullable Mqtt5EnhancedAuthMechanism enhancedAuthMechanism, int receiveMaximum, int maximumPacketSize, int topicAliasMaximum, boolean problemInformationRequested, boolean responseInformationRequested, int sendMaximum, int sendMaximumPacketSize, int sendTopicAliasMaximum, @NotNull MqttQos maximumQos, boolean retainAvailable, boolean wildcardSubscriptionAvailable, boolean sharedSubscriptionAvailable, boolean subscriptionIdentifiersAvailable, @NotNull Channel channel) {
        this.transportConfig = transportConfig;
        this.keepAlive = (short)keepAlive;
        this.sessionExpiryInterval = (int)sessionExpiryInterval;
        this.enhancedAuthMechanism = enhancedAuthMechanism;
        this.receiveMaximum = (short)receiveMaximum;
        this.maximumPacketSize = maximumPacketSize;
        this.topicAliasMaximum = (short)topicAliasMaximum;
        this.sendMaximum = (short)sendMaximum;
        this.sendMaximumPacketSize = sendMaximumPacketSize;
        this.sendTopicAliasMapping = sendTopicAliasMaximum == 0 ? null : new MqttTopicAliasAutoMapping(sendTopicAliasMaximum);
        this.maximumQos = maximumQos;
        this.channel = channel;
        int flags = 0;
        if (hasSimpleAuth) {
            flags |= 1;
        }
        if (hasWillPublish) {
            flags |= 2;
        }
        if (problemInformationRequested) {
            flags |= 4;
        }
        if (responseInformationRequested) {
            flags |= 8;
        }
        if (retainAvailable) {
            flags |= 0x10;
        }
        if (wildcardSubscriptionAvailable) {
            flags |= 0x20;
        }
        if (sharedSubscriptionAvailable) {
            flags |= 0x40;
        }
        if (subscriptionIdentifiersAvailable) {
            flags |= 0x80;
        }
        if (cleanStart) {
            flags |= 0x100;
        }
        if (cleanStop) {
            flags |= 0x200;
        }
        this.flags = flags;
    }

    @Override
    @NotNull
    public MqttClientTransportConfigImpl getTransportConfig() {
        return this.transportConfig;
    }

    @Override
    public int getKeepAlive() {
        return this.keepAlive & 0xFFFF;
    }

    public boolean isCleanStart() {
        return (this.flags & 0x100) != 0;
    }

    public boolean isCleanStop() {
        return (this.flags & 0x200) != 0;
    }

    @Override
    public long getSessionExpiryInterval() {
        return (long)this.sessionExpiryInterval & 0xFFFFFFFFL;
    }

    public void setSessionExpiryInterval(long sessionExpiryInterval) {
        this.sessionExpiryInterval = (int)sessionExpiryInterval;
    }

    @Override
    public boolean hasSimpleAuth() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean hasWillPublish() {
        return (this.flags & 2) != 0;
    }

    @Override
    @NotNull
    public Optional<Mqtt5EnhancedAuthMechanism> getEnhancedAuthMechanism() {
        return Optional.ofNullable(this.enhancedAuthMechanism);
    }

    @Nullable
    public Mqtt5EnhancedAuthMechanism getRawEnhancedAuthMechanism() {
        return this.enhancedAuthMechanism;
    }

    @Override
    @NotNull
    public MqttClientConnectionConfig getRestrictionsForServer() {
        return this;
    }

    @Override
    @NotNull
    public MqttClientConnectionConfig getRestrictionsForClient() {
        return this;
    }

    @Override
    public int getReceiveMaximum() {
        return this.receiveMaximum & 0xFFFF;
    }

    @Override
    public int getMaximumPacketSize() {
        return this.maximumPacketSize;
    }

    @Override
    public int getTopicAliasMaximum() {
        return this.topicAliasMaximum & 0xFFFF;
    }

    @Override
    public boolean isProblemInformationRequested() {
        return (this.flags & 4) != 0;
    }

    @Override
    public boolean isResponseInformationRequested() {
        return (this.flags & 8) != 0;
    }

    @Override
    public int getSendMaximum() {
        return this.sendMaximum & 0xFFFF;
    }

    @Override
    public int getSendMaximumPacketSize() {
        return this.sendMaximumPacketSize;
    }

    @Override
    public int getSendTopicAliasMaximum() {
        return this.sendTopicAliasMapping == null ? 0 : this.sendTopicAliasMapping.getTopicAliasMaximum();
    }

    @Nullable
    public MqttTopicAliasMapping getSendTopicAliasMapping() {
        return this.sendTopicAliasMapping;
    }

    @Override
    @NotNull
    public MqttQos getMaximumQos() {
        return this.maximumQos;
    }

    @Override
    public boolean isRetainAvailable() {
        return (this.flags & 0x10) != 0;
    }

    @Override
    public boolean isWildcardSubscriptionAvailable() {
        return (this.flags & 0x20) != 0;
    }

    @Override
    public boolean isSharedSubscriptionAvailable() {
        return (this.flags & 0x40) != 0;
    }

    @Override
    public boolean areSubscriptionIdentifiersAvailable() {
        return (this.flags & 0x80) != 0;
    }

    @NotNull
    public Channel getChannel() {
        return this.channel;
    }
}

