/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.mqtt;

import com.hivemq.client.annotations.CheckReturnValue;
import com.hivemq.client.annotations.DoNotImplement;
import com.hivemq.client.mqtt.MqttClientExecutorConfig;
import com.hivemq.client.mqtt.MqttClientSslConfig;
import com.hivemq.client.mqtt.MqttClientTransportConfig;
import com.hivemq.client.mqtt.MqttWebSocketConfig;
import com.hivemq.client.mqtt.datatypes.MqttClientIdentifier;
import com.hivemq.client.mqtt.lifecycle.MqttClientAutoReconnect;
import com.hivemq.client.mqtt.lifecycle.MqttClientConnectedListener;
import com.hivemq.client.mqtt.lifecycle.MqttClientDisconnectedListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DoNotImplement
public interface MqttClientBuilderBase<B extends MqttClientBuilderBase<B>> {
    @CheckReturnValue
    @NotNull
    public B identifier(@NotNull String var1);

    @CheckReturnValue
    @NotNull
    public B identifier(@NotNull MqttClientIdentifier var1);

    @CheckReturnValue
    @NotNull
    public B serverAddress(@NotNull InetSocketAddress var1);

    @CheckReturnValue
    @NotNull
    public B serverHost(@NotNull String var1);

    @CheckReturnValue
    @NotNull
    public B serverHost(@NotNull InetAddress var1);

    @CheckReturnValue
    @NotNull
    public B serverPort(int var1);

    @Deprecated
    @NotNull
    default public B useSslWithDefaultConfig() {
        return this.sslWithDefaultConfig();
    }

    @CheckReturnValue
    @NotNull
    public B sslWithDefaultConfig();

    @Deprecated
    @NotNull
    default public B useSsl(@Nullable MqttClientSslConfig sslConfig) {
        return this.sslConfig(sslConfig);
    }

    @CheckReturnValue
    @NotNull
    public B sslConfig(@Nullable MqttClientSslConfig var1);

    @Deprecated
    default public  @NotNull MqttClientSslConfigBuilder.Nested<? extends B> useSsl() {
        return this.sslConfig();
    }

    @CheckReturnValue
    public  @NotNull MqttClientSslConfigBuilder.Nested<? extends B> sslConfig();

    @Deprecated
    @NotNull
    default public B useWebSocketWithDefaultConfig() {
        return this.webSocketWithDefaultConfig();
    }

    @CheckReturnValue
    @NotNull
    public B webSocketWithDefaultConfig();

    @Deprecated
    @NotNull
    default public B useWebSocket(@Nullable MqttWebSocketConfig webSocketConfig) {
        return this.webSocketConfig(webSocketConfig);
    }

    @CheckReturnValue
    @NotNull
    public B webSocketConfig(@Nullable MqttWebSocketConfig var1);

    @Deprecated
    default public  @NotNull MqttWebSocketConfigBuilder.Nested<? extends B> useWebSocket() {
        return this.webSocketConfig();
    }

    @CheckReturnValue
    public  @NotNull MqttWebSocketConfigBuilder.Nested<? extends B> webSocketConfig();

    @CheckReturnValue
    @NotNull
    public B transportConfig(@NotNull MqttClientTransportConfig var1);

    @CheckReturnValue
    public  @NotNull MqttClientTransportConfigBuilder.Nested<? extends B> transportConfig();

    @CheckReturnValue
    @NotNull
    public B executorConfig(@NotNull MqttClientExecutorConfig var1);

    @CheckReturnValue
    public  @NotNull MqttClientExecutorConfigBuilder.Nested<? extends B> executorConfig();

    @CheckReturnValue
    @NotNull
    public B automaticReconnectWithDefaultConfig();

    @CheckReturnValue
    @NotNull
    public B automaticReconnect(@Nullable MqttClientAutoReconnect var1);

    @CheckReturnValue
    public  @NotNull MqttClientAutoReconnectBuilder.Nested<? extends B> automaticReconnect();

    @CheckReturnValue
    @NotNull
    public B addConnectedListener(@NotNull MqttClientConnectedListener var1);

    @CheckReturnValue
    @NotNull
    public B addDisconnectedListener(@NotNull MqttClientDisconnectedListener var1);
}

