/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.geocoder;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.ws.rs.client.Client;
import org.traccar.geocoder.Address;
import org.traccar.geocoder.AddressFormat;
import org.traccar.geocoder.JsonGeocoder;

public class BingMapsGeocoder
extends JsonGeocoder {
    public BingMapsGeocoder(Client client, String url, String key, int cacheSize, AddressFormat addressFormat) {
        super(client, url + "/Locations/%f,%f?key=" + key + "&include=ciso2", cacheSize, addressFormat);
    }

    @Override
    public Address parseAddress(JsonObject json) {
        JsonObject location;
        JsonArray result = json.getJsonArray("resourceSets");
        if (result != null && (location = result.getJsonObject(0).getJsonArray("resources").getJsonObject(0).getJsonObject("address")) != null) {
            Address address = new Address();
            if (location.containsKey((Object)"addressLine")) {
                address.setStreet(location.getString("addressLine"));
            }
            if (location.containsKey((Object)"locality")) {
                address.setSettlement(location.getString("locality"));
            }
            if (location.containsKey((Object)"adminDistrict2")) {
                address.setDistrict(location.getString("adminDistrict2"));
            }
            if (location.containsKey((Object)"adminDistrict")) {
                address.setState(location.getString("adminDistrict"));
            }
            if (location.containsKey((Object)"countryRegionIso2")) {
                address.setCountry(location.getString("countryRegionIso2").toUpperCase());
            }
            if (location.containsKey((Object)"postalCode")) {
                address.setPostcode(location.getString("postalCode"));
            }
            if (location.containsKey((Object)"formattedAddress")) {
                address.setFormattedAddress(location.getString("formattedAddress"));
            }
            return address;
        }
        return null;
    }
}

