/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler;

import jakarta.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.introspection.JexlSandbox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.handler.BasePositionHandler;
import org.traccar.helper.ReflectionCache;
import org.traccar.model.Attribute;
import org.traccar.model.Device;
import org.traccar.model.Position;
import org.traccar.session.cache.CacheManager;

public class ComputedAttributesHandler
extends BasePositionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComputedAttributesHandler.class);
    private final CacheManager cacheManager;
    private final boolean early;
    private final JexlEngine engine;
    private final JexlFeatures features;
    private final boolean includeDeviceAttributes;
    private final boolean includeLastAttributes;

    public ComputedAttributesHandler(Config config, CacheManager cacheManager, boolean early) {
        this.cacheManager = cacheManager;
        this.early = early;
        JexlSandbox sandbox = new JexlSandbox(false);
        sandbox.allow("com.safe.Functions");
        sandbox.allow(Math.class.getName());
        List.of(Double.class, Float.class, Integer.class, Long.class, Short.class, Character.class, Boolean.class, String.class, Byte.class, Date.class, HashMap.class, LinkedHashMap.class, double[].class, int[].class, boolean[].class, String[].class).forEach(type -> sandbox.allow(type.getName()));
        this.features = new JexlFeatures().localVar(config.getBoolean(Keys.PROCESSING_COMPUTED_ATTRIBUTES_LOCAL_VARIABLES)).loops(config.getBoolean(Keys.PROCESSING_COMPUTED_ATTRIBUTES_LOOPS)).newInstance(config.getBoolean(Keys.PROCESSING_COMPUTED_ATTRIBUTES_NEW_INSTANCE_CREATION)).structuredLiteral(true);
        this.engine = new JexlBuilder().strict(true).namespaces(Collections.singletonMap("math", Math.class)).sandbox(sandbox).create();
        this.includeDeviceAttributes = config.getBoolean(Keys.PROCESSING_COMPUTED_ATTRIBUTES_DEVICE_ATTRIBUTES);
        this.includeLastAttributes = config.getBoolean(Keys.PROCESSING_COMPUTED_ATTRIBUTES_LAST_ATTRIBUTES);
    }

    private MapContext prepareContext(Position position) {
        Device device;
        MapContext result = new MapContext();
        if (this.includeDeviceAttributes && (device = this.cacheManager.getObject(Device.class, position.getDeviceId())) != null) {
            for (String key2 : device.getAttributes().keySet()) {
                result.set(key2, device.getAttributes().get(key2));
            }
        }
        Position last = this.includeLastAttributes ? this.cacheManager.getPosition(position.getDeviceId()) : null;
        ReflectionCache.getProperties(Position.class, "get").forEach((key, value) -> {
            Method method = value.method();
            String name = Character.toLowerCase(method.getName().charAt(3)) + method.getName().substring(4);
            try {
                if (!method.getReturnType().equals(Map.class)) {
                    result.set(name, method.invoke((Object)position, new Object[0]));
                    if (last != null) {
                        result.set(this.prefixAttribute("last", name), method.invoke((Object)last, new Object[0]));
                    }
                } else {
                    for (Map.Entry entry : ((Map)method.invoke((Object)position, new Object[0])).entrySet()) {
                        result.set((String)entry.getKey(), entry.getValue());
                    }
                    if (last != null) {
                        for (Map.Entry entry : ((Map)method.invoke((Object)last, new Object[0])).entrySet()) {
                            result.set(this.prefixAttribute("last", (String)entry.getKey()), entry.getValue());
                        }
                    }
                }
            }
            catch (IllegalAccessException | InvocationTargetException error) {
                LOGGER.warn("Attribute reflection error", (Throwable)error);
            }
        });
        return result;
    }

    private String prefixAttribute(String prefix, String key) {
        return prefix + Character.toUpperCase(key.charAt(0)) + key.substring(1);
    }

    @Deprecated
    public Object computeAttribute(Attribute attribute, Position position) throws JexlException {
        return this.engine.createScript(this.features, this.engine.createInfo(), attribute.getExpression(), new String[0]).execute((JexlContext)this.prepareContext(position));
    }

    @Override
    public void onPosition(Position position, BasePositionHandler.Callback callback) {
        List<Attribute> attributes = this.cacheManager.getDeviceObjects(position.getDeviceId(), Attribute.class).stream().filter(attribute -> attribute.getPriority() < 0 == this.early).sorted(Comparator.comparing(Attribute::getPriority).reversed()).toList();
        for (Attribute attribute2 : attributes) {
            if (attribute2.getAttribute() == null) continue;
            try {
                Object result = this.computeAttribute(attribute2, position);
                if (result != null) {
                    block11 : switch (attribute2.getAttribute()) {
                        case "valid": {
                            position.setValid((Boolean)result);
                            break;
                        }
                        case "latitude": {
                            position.setLatitude(((Number)result).doubleValue());
                            break;
                        }
                        case "longitude": {
                            position.setLongitude(((Number)result).doubleValue());
                            break;
                        }
                        case "altitude": {
                            position.setAltitude(((Number)result).doubleValue());
                            break;
                        }
                        case "speed": {
                            position.setSpeed(((Number)result).doubleValue());
                            break;
                        }
                        case "course": {
                            position.setCourse(((Number)result).doubleValue());
                            break;
                        }
                        case "address": {
                            position.setAddress((String)result);
                            break;
                        }
                        case "accuracy": {
                            position.setAccuracy(((Number)result).doubleValue());
                            break;
                        }
                        default: {
                            switch (attribute2.getType()) {
                                case "number": {
                                    Number numberValue = (Number)result;
                                    position.getAttributes().put(attribute2.getAttribute(), numberValue);
                                    break block11;
                                }
                                case "boolean": {
                                    Boolean booleanValue = (Boolean)result;
                                    position.getAttributes().put(attribute2.getAttribute(), booleanValue);
                                    break block11;
                                }
                            }
                            position.getAttributes().put(attribute2.getAttribute(), result.toString());
                            break;
                        }
                    }
                    continue;
                }
                position.removeAttribute(attribute2.getAttribute());
            }
            catch (JexlException error) {
                LOGGER.warn("Attribute computation error", (Throwable)error);
            }
            catch (ClassCastException error) {
                LOGGER.warn("Attribute cast error", (Throwable)error);
            }
        }
        callback.processed(false);
    }

    public static class Late
    extends ComputedAttributesHandler {
        @Inject
        public Late(Config config, CacheManager cacheManager) {
            super(config, cacheManager, false);
        }
    }

    public static class Early
    extends ComputedAttributesHandler {
        @Inject
        public Early(Config config, CacheManager cacheManager) {
            super(config, cacheManager, true);
        }
    }
}

