/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler;

import jakarta.inject.Inject;
import org.traccar.config.Keys;
import org.traccar.handler.BasePositionHandler;
import org.traccar.helper.model.AttributeUtil;
import org.traccar.model.Position;
import org.traccar.session.cache.CacheManager;

public class MotionHandler
extends BasePositionHandler {
    private final CacheManager cacheManager;

    @Inject
    public MotionHandler(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public void onPosition(Position position, BasePositionHandler.Callback callback) {
        if (!position.hasAttribute("motion")) {
            double threshold = AttributeUtil.lookup(this.cacheManager, Keys.EVENT_MOTION_SPEED_THRESHOLD, position.getDeviceId());
            position.set("motion", position.getSpeed() > threshold);
        }
        callback.processed(false);
    }
}

