/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.DateBuilder;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class OrionProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_USERLOG = 0;
    public static final int MSG_SYSLOG = 3;

    public OrionProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private static void sendResponse(Channel channel, ByteBuf buf) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer((int)4);
            response.writeByte(42);
            response.writeShort(buf.getUnsignedShort(buf.writerIndex() - 2));
            response.writeByte((int)buf.getUnsignedByte(buf.writerIndex() - 3));
            channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
        }
    }

    private static double convertCoordinate(int raw) {
        int degrees = raw / 1000000;
        double minutes = (double)(raw % 1000000) / 10000.0;
        return (double)degrees + minutes / 60.0;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(2);
        int type = buf.readUnsignedByte() & 0xF;
        if (type == 0) {
            DeviceSession deviceSession;
            short header = buf.readUnsignedByte();
            if ((header & 0x40) != 0) {
                OrionProtocolDecoder.sendResponse(channel, buf);
            }
            if ((deviceSession = this.getDeviceSession(channel, remoteAddress, String.valueOf(buf.readUnsignedInt()))) == null) {
                return null;
            }
            LinkedList<Position> positions = new LinkedList<Position>();
            for (int i = 0; i < (header & 0xF); ++i) {
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                position.set("event", buf.readUnsignedByte());
                buf.readUnsignedByte();
                position.set("flags", buf.readUnsignedShortLE());
                position.setLatitude(OrionProtocolDecoder.convertCoordinate(buf.readIntLE()));
                position.setLongitude(OrionProtocolDecoder.convertCoordinate(buf.readIntLE()));
                position.setAltitude((double)buf.readShortLE() / 10.0);
                position.setCourse(buf.readUnsignedShortLE());
                position.setSpeed((double)buf.readUnsignedShortLE() * 0.0539957);
                DateBuilder dateBuilder = new DateBuilder().setDate(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
                position.setTime(dateBuilder.getDate());
                short satellites = buf.readUnsignedByte();
                position.setValid(satellites >= 3);
                position.set("sat", Integer.valueOf(satellites));
                positions.add(position);
            }
            return positions;
        }
        return null;
    }
}

