/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.tracing;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.gax.longrunning.OperationSnapshot;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.SpanName;
import com.google.api.gax.tracing.TracedUnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;

public class TracedOperationInitialCallable<RequestT>
extends TracedUnaryCallable<RequestT, OperationSnapshot> {
    public TracedOperationInitialCallable(UnaryCallable<RequestT, OperationSnapshot> innerCallable, ApiTracerFactory tracedFactory, SpanName spanName) {
        super(innerCallable, tracedFactory, spanName);
    }

    @Override
    public ApiFuture<OperationSnapshot> futureCall(RequestT request, ApiCallContext context) {
        InitialCallableFinisher finisher = new InitialCallableFinisher(context.getTracer());
        try {
            ApiFuture future = super.futureCall(request, context);
            ApiFutures.addCallback(future, (ApiFutureCallback)finisher, (Executor)MoreExecutors.directExecutor());
            return future;
        }
        catch (RuntimeException e) {
            finisher.onFailure(e);
            throw e;
        }
    }

    private static class InitialCallableFinisher
    implements ApiFutureCallback<OperationSnapshot> {
        private final ApiTracer operationTracer;

        private InitialCallableFinisher(ApiTracer operationTracer) {
            this.operationTracer = operationTracer;
        }

        public void onSuccess(OperationSnapshot result) {
            this.operationTracer.lroStartSucceeded();
        }

        public void onFailure(Throwable t) {
            this.operationTracer.lroStartFailed(t);
        }
    }
}

