/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import io.grpc.xds.GcpAuthenticationFilter;
import java.util.HashMap;
import java.util.Map;

final class MetadataRegistry {
    private static final MetadataRegistry INSTANCE = new MetadataRegistry();
    private final Map<String, MetadataValueParser> supportedParsers = new HashMap<String, MetadataValueParser>();

    private MetadataRegistry() {
        this.registerParser(new GcpAuthenticationFilter.AudienceMetadataParser());
    }

    static MetadataRegistry getInstance() {
        return INSTANCE;
    }

    MetadataValueParser findParser(String typeUrl) {
        return this.supportedParsers.get(typeUrl);
    }

    @VisibleForTesting
    void registerParser(MetadataValueParser parser) {
        this.supportedParsers.put(parser.getTypeUrl(), parser);
    }

    void removeParser(MetadataValueParser parser) {
        this.supportedParsers.remove(parser.getTypeUrl());
    }

    static interface MetadataValueParser {
        public String getTypeUrl();

        public Object parse(Any var1) throws InvalidProtocolBufferException;
    }
}

