/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.observers.SerializedObserver;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableDebounceTimed<T>
extends AbstractObservableWithUpstream<T, T> {
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;

    public ObservableDebounceTimed(ObservableSource<T> source, long timeout, TimeUnit unit, Scheduler scheduler) {
        super(source);
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    @Override
    public void subscribeActual(Observer<? super T> t) {
        this.source.subscribe(new DebounceTimedObserver<T>(new SerializedObserver<T>(t), this.timeout, this.unit, this.scheduler.createWorker()));
    }

    static final class DebounceEmitter<T>
    extends AtomicReference<Disposable>
    implements Runnable,
    Disposable {
        private static final long serialVersionUID = 6812032969491025141L;
        final T value;
        final long idx;
        final DebounceTimedObserver<T> parent;
        final AtomicBoolean once = new AtomicBoolean();

        DebounceEmitter(T value, long idx, DebounceTimedObserver<T> parent) {
            this.value = value;
            this.idx = idx;
            this.parent = parent;
        }

        @Override
        public void run() {
            if (this.once.compareAndSet(false, true)) {
                this.parent.emit(this.idx, this.value, this);
            }
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return this.get() == DisposableHelper.DISPOSED;
        }

        public void setResource(Disposable d) {
            DisposableHelper.replace(this, d);
        }
    }

    static final class DebounceTimedObserver<T>
    implements Observer<T>,
    Disposable {
        final Observer<? super T> downstream;
        final long timeout;
        final TimeUnit unit;
        final Scheduler.Worker worker;
        Disposable upstream;
        Disposable timer;
        volatile long index;
        boolean done;

        DebounceTimedObserver(Observer<? super T> actual, long timeout, TimeUnit unit, Scheduler.Worker worker) {
            this.downstream = actual;
            this.timeout = timeout;
            this.unit = unit;
            this.worker = worker;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            DebounceEmitter<T> de;
            long idx;
            if (this.done) {
                return;
            }
            this.index = idx = this.index + 1L;
            Disposable d = this.timer;
            if (d != null) {
                d.dispose();
            }
            this.timer = de = new DebounceEmitter<T>(t, idx, this);
            d = this.worker.schedule(de, this.timeout, this.unit);
            de.setResource(d);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            Disposable d = this.timer;
            if (d != null) {
                d.dispose();
            }
            this.done = true;
            this.downstream.onError(t);
            this.worker.dispose();
        }

        @Override
        public void onComplete() {
            DebounceEmitter de;
            if (this.done) {
                return;
            }
            this.done = true;
            Disposable d = this.timer;
            if (d != null) {
                d.dispose();
            }
            if ((de = (DebounceEmitter)d) != null) {
                de.run();
            }
            this.downstream.onComplete();
            this.worker.dispose();
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
            this.worker.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.worker.isDisposed();
        }

        void emit(long idx, T t, DebounceEmitter<T> emitter) {
            if (idx == this.index) {
                this.downstream.onNext(t);
                emitter.dispose();
            }
        }
    }
}

