/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.message.client;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.socket.Writer;
import org.mariadb.jdbc.client.util.Parameters;
import org.mariadb.jdbc.codec.Parameter;
import org.mariadb.jdbc.message.client.RedoableClientMessage;
import org.mariadb.jdbc.plugin.codec.ByteArrayCodec;
import org.mariadb.jdbc.util.ClientParser;

public final class QueryWithParametersRewritePacket
implements RedoableClientMessage {
    private final String preSqlCmd;
    private final ClientParser parser;
    private List<Parameters> parametersList;

    public QueryWithParametersRewritePacket(String preSqlCmd, ClientParser parser, List<Parameters> batchParameterList) {
        this.preSqlCmd = preSqlCmd;
        this.parametersList = batchParameterList;
        this.parser = parser;
    }

    @Override
    public void saveParameters() {
        ArrayList<Parameters> savedList = new ArrayList<Parameters>(this.parametersList.size());
        for (Parameters parameterList : this.parametersList) {
            savedList.add(parameterList.clone());
        }
        this.parametersList = savedList;
    }

    @Override
    public void ensureReplayable(Context context) throws IOException, SQLException {
        for (int j = 0; j < this.parametersList.size(); ++j) {
            Parameters parameters = this.parametersList.get(j);
            int parameterCount = parameters.size();
            for (int i = 0; i < parameterCount; ++i) {
                org.mariadb.jdbc.client.util.Parameter p = parameters.get(i);
                if (p.isNull() || !p.canEncodeLongData()) continue;
                parameters.set(i, new Parameter<byte[]>(ByteArrayCodec.INSTANCE, p.encodeData()));
            }
        }
    }

    @Override
    public int encode(Writer writer, Context context) throws IOException, SQLException {
        Iterator<Parameters> paramIterator = this.parametersList.iterator();
        Parameters parameters = paramIterator.next();
        int rewritePacketNo = 0;
        int endingPartLen = this.parser.getQuery().length - this.parser.getValuesBracketPositions().get(1);
        block0: while (true) {
            int paramPos;
            ++rewritePacketNo;
            writer.initPacket();
            writer.writeByte(3);
            if (this.preSqlCmd != null) {
                writer.writeAscii(this.preSqlCmd);
            }
            int pos = 0;
            if (this.parser.getParamCount() > parameters.size()) {
                throw context.getExceptionFactory().create("wrong number of parameters", "Y0000");
            }
            for (int i = 0; i < this.parser.getParamCount(); ++i) {
                paramPos = this.parser.getParamPositions().get(i);
                writer.writeBytes(this.parser.getQuery(), pos, paramPos - pos);
                pos = paramPos + 1;
                parameters.get(i).encodeText(writer, context);
            }
            if (!paramIterator.hasNext()) break;
            parameters = paramIterator.next();
            if (writer.throwMaxAllowedLengthOr16M(writer.pos() + endingPartLen)) {
                writer.writeBytes(this.parser.getQuery(), this.parser.getValuesBracketPositions().get(1), endingPartLen);
                writer.flush();
                continue;
            }
            while (true) {
                int i;
                int parameterLength = 0;
                boolean knownParameterSize = true;
                if (this.parser.getParamCount() > parameters.size()) {
                    throw context.getExceptionFactory().create("wrong number of parameters", "Y0000");
                }
                for (i = 0; i < this.parser.getParamCount(); ++i) {
                    int paramSize = parameters.get(i).getApproximateTextProtocolLength();
                    if (paramSize == -1) {
                        knownParameterSize = false;
                        break;
                    }
                    if (i > 0) {
                        parameterLength += this.parser.getParamPositions().get(i) - (this.parser.getParamPositions().get(i - 1) + 1);
                    }
                    parameterLength += paramSize;
                }
                if (!knownParameterSize || writer.throwMaxAllowedLengthOr16M(writer.pos() + parameterLength)) {
                    writer.writeBytes(this.parser.getQuery(), this.parser.getValuesBracketPositions().get(1), endingPartLen);
                    writer.flush();
                    continue block0;
                }
                writer.writeBytes(this.parser.getQuery(), pos, this.parser.getValuesBracketPositions().get(1) + 1 - pos);
                writer.writeByte(44);
                pos = this.parser.getValuesBracketPositions().get(0);
                for (i = 0; i < this.parser.getParamPositions().size(); ++i) {
                    paramPos = this.parser.getParamPositions().get(i);
                    writer.writeBytes(this.parser.getQuery(), pos, paramPos - pos);
                    pos = paramPos + 1;
                    parameters.get(i).encodeText(writer, context);
                }
                if (!paramIterator.hasNext()) break block0;
                parameters = paramIterator.next();
            }
            break;
        }
        writer.writeBytes(this.parser.getQuery(), this.parser.getValuesBracketPositions().get(1), endingPartLen);
        writer.flush();
        return rewritePacketNo;
    }

    @Override
    public boolean binaryProtocol() {
        return false;
    }

    @Override
    public InputStream getLocalInfileInputStream() {
        return null;
    }

    @Override
    public String description() {
        return "REWRITE: " + this.preSqlCmd + this.parser.getSql();
    }

    @Override
    public int batchUpdateLength() {
        return this.parametersList.size();
    }

    @Override
    public boolean validateLocalFileName(String fileName, Context context) {
        return false;
    }
}

