/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.EnumMap;
import java.util.Map;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.AlterShareGroupOffsetsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class AlterShareGroupOffsetsResponse
extends AbstractResponse {
    private final AlterShareGroupOffsetsResponseData data;

    public AlterShareGroupOffsetsResponse(AlterShareGroupOffsetsResponseData data) {
        super(ApiKeys.ALTER_SHARE_GROUP_OFFSETS);
        this.data = data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        EnumMap<Errors, Integer> counts = new EnumMap<Errors, Integer>(Errors.class);
        AlterShareGroupOffsetsResponse.updateErrorCounts(counts, Errors.forCode(this.data.errorCode()));
        this.data.responses().forEach(topic -> topic.partitions().forEach(partitionResponse -> AlterShareGroupOffsetsResponse.updateErrorCounts(counts, Errors.forCode(partitionResponse.errorCode()))));
        return counts;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public AlterShareGroupOffsetsResponseData data() {
        return this.data;
    }

    public static AlterShareGroupOffsetsResponse parse(Readable readable, short version) {
        return new AlterShareGroupOffsetsResponse(new AlterShareGroupOffsetsResponseData(readable, version));
    }

    public static class Builder {
        AlterShareGroupOffsetsResponseData data = new AlterShareGroupOffsetsResponseData();
        AlterShareGroupOffsetsResponseData.AlterShareGroupOffsetsResponseTopicCollection topics = new AlterShareGroupOffsetsResponseData.AlterShareGroupOffsetsResponseTopicCollection();

        private AlterShareGroupOffsetsResponseData.AlterShareGroupOffsetsResponseTopic getOrCreateTopic(String topic, Uuid topicId) {
            AlterShareGroupOffsetsResponseData.AlterShareGroupOffsetsResponseTopic topicData = this.topics.find(topic);
            if (topicData == null) {
                topicData = new AlterShareGroupOffsetsResponseData.AlterShareGroupOffsetsResponseTopic().setTopicName(topic).setTopicId(topicId == null ? Uuid.ZERO_UUID : topicId);
                this.topics.add(topicData);
            }
            return topicData;
        }

        public Builder addPartition(String topic, int partition, Map<String, Uuid> topicIdsToNames, Errors error) {
            AlterShareGroupOffsetsResponseData.AlterShareGroupOffsetsResponseTopic topicData = this.getOrCreateTopic(topic, topicIdsToNames.get(topic));
            topicData.partitions().add(new AlterShareGroupOffsetsResponseData.AlterShareGroupOffsetsResponsePartition().setPartitionIndex(partition).setErrorCode(error.code()).setErrorMessage(error.message()));
            return this;
        }

        public AlterShareGroupOffsetsResponse build() {
            this.data.setResponses(this.topics);
            return new AlterShareGroupOffsetsResponse(this.data);
        }

        public Builder merge(AlterShareGroupOffsetsResponseData data, Map<String, Uuid> topicIdsToNames) {
            data.responses().forEach(topic -> {
                AlterShareGroupOffsetsResponseData.AlterShareGroupOffsetsResponseTopic newTopic = this.getOrCreateTopic(topic.topicName(), (Uuid)topicIdsToNames.get(topic.topicName()));
                topic.partitions().forEach(partition -> newTopic.partitions().add(new AlterShareGroupOffsetsResponseData.AlterShareGroupOffsetsResponsePartition().setPartitionIndex(partition.partitionIndex()).setErrorCode(partition.errorCode()).setErrorMessage(partition.errorMessage())));
            });
            return this;
        }
    }
}

