/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.x509;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.common.util.PemException;
import org.keycloak.common.util.PemUtils;
import org.keycloak.http.HttpRequest;
import org.keycloak.services.x509.AbstractClientCertificateFromHttpHeadersLookup;

public class NginxProxySslClientCertificateLookup
extends AbstractClientCertificateFromHttpHeadersLookup {
    private static final Logger log = Logger.getLogger(NginxProxySslClientCertificateLookup.class);
    private final boolean isTruststoreLoaded;
    private final boolean certIsUrlEncoded;
    private final Set<X509Certificate> trustedRootCerts;
    private final Set<X509Certificate> intermediateCerts;

    public NginxProxySslClientCertificateLookup(String sslClientCertHttpHeader, String sslCertChainHttpHeaderPrefix, int certificateChainLength, Set<X509Certificate> intermediateCerts, Set<X509Certificate> trustedRootCerts, boolean isTruststoreLoaded, boolean certIsUrlEncoded) {
        super(sslClientCertHttpHeader, sslCertChainHttpHeaderPrefix, certificateChainLength);
        Objects.requireNonNull(intermediateCerts, "requireNonNull intermediateCerts");
        Objects.requireNonNull(trustedRootCerts, "requireNonNull trustedRootCerts");
        this.intermediateCerts = intermediateCerts;
        this.trustedRootCerts = trustedRootCerts;
        this.isTruststoreLoaded = isTruststoreLoaded;
        this.certIsUrlEncoded = certIsUrlEncoded;
        if (!this.isTruststoreLoaded) {
            log.warn((Object)"Keycloak Truststore is null or empty, but it's required for NGINX x509cert-lookup provider");
            log.warn((Object)"   see Keycloak documentation here : https://www.keycloak.org/docs/latest/server_installation/index.html#_truststore");
        }
    }

    private static String removeBeginEnd(String pem) {
        pem = pem.replace("-----BEGIN CERTIFICATE-----", "");
        pem = pem.replace("-----END CERTIFICATE-----", "");
        pem = pem.replace("\r\n", "");
        pem = pem.replace("\n", "");
        return pem.trim();
    }

    @Override
    protected X509Certificate decodeCertificateFromPem(String pem) throws PemException {
        if (pem == null) {
            log.warn((Object)"End user TLS Certificate is NULL! ");
            return null;
        }
        if (this.certIsUrlEncoded) {
            pem = URLDecoder.decode(pem, StandardCharsets.UTF_8);
        }
        if (pem.startsWith("-----BEGIN CERTIFICATE-----")) {
            pem = NginxProxySslClientCertificateLookup.removeBeginEnd(pem);
        }
        return PemUtils.decodeCertificate((String)pem);
    }

    @Override
    protected void buildChain(HttpRequest httpRequest, List<X509Certificate> chain, X509Certificate clientCert) {
        log.debugf("End user certificate found : Subject DN=[%s]  SerialNumber=[%s]", (Object)clientCert.getSubjectX500Principal(), (Object)clientCert.getSerialNumber());
        X509Certificate[] certChain = this.buildChain(clientCert);
        if (certChain == null || certChain.length == 0) {
            log.info((Object)"Impossible to rebuild end user cert chain : client certificate authentication will fail.");
            chain.add(clientCert);
        } else {
            for (X509Certificate caCert : certChain) {
                chain.add(caCert);
                log.debugf("Rebuilded user cert chain DN : %s", (Object)caCert.getSubjectX500Principal());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509Certificate[] buildChain(X509Certificate endUserAuthCert) {
        X509Certificate[] userCertChain = new X509Certificate[]{};
        try {
            if (!this.isTruststoreLoaded) {
                log.warn((Object)"Keycloak Truststore is null, but it is required !");
                log.warn((Object)"  see https://www.keycloak.org/docs/latest/server_installation/index.html#_truststore");
                X509Certificate[] x509CertificateArray = userCertChain;
                return x509CertificateArray;
            }
            X509CertSelector selector = new X509CertSelector();
            selector.setCertificate(endUserAuthCert);
            HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
            for (X509Certificate trustedRootCert : this.trustedRootCerts) {
                trustAnchors.add(new TrustAnchor(trustedRootCert, null));
            }
            PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustAnchors, (CertSelector)selector);
            pkixParams.setRevocationEnabled(false);
            pkixParams.setExplicitPolicyRequired(false);
            pkixParams.setAnyPolicyInhibited(false);
            pkixParams.setPolicyQualifiersRejected(false);
            pkixParams.setMaxPathLength(this.certificateChainLength);
            this.intermediateCerts.add(endUserAuthCert);
            CollectionCertStoreParameters intermediateCAUserCert = new CollectionCertStoreParameters(this.intermediateCerts);
            CertStore intermediateCertStore = CryptoIntegration.getProvider().getCertStore(intermediateCAUserCert);
            pkixParams.addCertStore(intermediateCertStore);
            CertPathBuilder certPathBuilder = CryptoIntegration.getProvider().getCertPathBuilder();
            CertPath certPath = certPathBuilder.build(pkixParams).getCertPath();
            log.debug((Object)("Certification path building OK, and contains " + certPath.getCertificates().size() + " X509 Certificates"));
            userCertChain = this.convertCertPathToX509CertArray(certPath);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (CertPathBuilderException e) {
            if (log.isEnabled(Logger.Level.TRACE)) {
                log.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            } else {
                log.warn((Object)e.getLocalizedMessage());
            }
        }
        finally {
            if (this.isTruststoreLoaded) {
                this.intermediateCerts.remove(endUserAuthCert);
            }
        }
        return userCertChain;
    }

    private X509Certificate[] convertCertPathToX509CertArray(CertPath certPath) {
        X509Certificate[] x509certChain = new X509Certificate[]{};
        if (certPath == null) {
            return x509certChain;
        }
        ArrayList<X509Certificate> trustedX509Chain = new ArrayList<X509Certificate>();
        for (Certificate certificate : certPath.getCertificates()) {
            if (!(certificate instanceof X509Certificate)) continue;
            trustedX509Chain.add((X509Certificate)certificate);
        }
        return trustedX509Chain.toArray(x509certChain);
    }
}

