/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface Listener {
    public boolean sync() default true;

    public boolean primaryOnly() default false;

    public boolean clustered() default false;

    public boolean includeCurrentState() default false;

    public Observation observation() default Observation.BOTH;

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Observation {
        PRE{

            @Override
            public boolean shouldInvoke(boolean pre) {
                return pre;
            }
        }
        ,
        POST{

            @Override
            public boolean shouldInvoke(boolean pre) {
                return !pre;
            }
        }
        ,
        BOTH{

            @Override
            public boolean shouldInvoke(boolean pre) {
                return true;
            }
        };


        public abstract boolean shouldInvoke(boolean var1);
    }
}

