/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.llvm.CXIdxLoc;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXIdxIncludedFileInfo
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HASHLOC;
    public static final int FILENAME;
    public static final int FILE;
    public static final int ISIMPORT;
    public static final int ISANGLED;
    public static final int ISMODULEIMPORT;

    public CXIdxIncludedFileInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CXIdxIncludedFileInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public CXIdxLoc hashLoc() {
        return CXIdxIncludedFileInfo.nhashLoc(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer filename() {
        return CXIdxIncludedFileInfo.nfilename(this.address());
    }

    @NativeType(value="char const *")
    public String filenameString() {
        return CXIdxIncludedFileInfo.nfilenameString(this.address());
    }

    @NativeType(value="CXFile")
    public long file() {
        return CXIdxIncludedFileInfo.nfile(this.address());
    }

    @NativeType(value="int")
    public boolean isImport() {
        return CXIdxIncludedFileInfo.nisImport(this.address()) != 0;
    }

    @NativeType(value="int")
    public boolean isAngled() {
        return CXIdxIncludedFileInfo.nisAngled(this.address()) != 0;
    }

    @NativeType(value="int")
    public boolean isModuleImport() {
        return CXIdxIncludedFileInfo.nisModuleImport(this.address()) != 0;
    }

    public static CXIdxIncludedFileInfo create(long address) {
        return (CXIdxIncludedFileInfo)CXIdxIncludedFileInfo.wrap(CXIdxIncludedFileInfo.class, (long)address);
    }

    @Nullable
    public static CXIdxIncludedFileInfo createSafe(long address) {
        return address == 0L ? null : (CXIdxIncludedFileInfo)CXIdxIncludedFileInfo.wrap(CXIdxIncludedFileInfo.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CXIdxIncludedFileInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CXIdxIncludedFileInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static CXIdxLoc nhashLoc(long struct) {
        return CXIdxLoc.create(struct + (long)HASHLOC);
    }

    public static ByteBuffer nfilename(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)FILENAME)));
    }

    public static String nfilenameString(long struct) {
        return MemoryUtil.memASCII((long)MemoryUtil.memGetAddress((long)(struct + (long)FILENAME)));
    }

    public static long nfile(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)FILE));
    }

    public static int nisImport(long struct) {
        return UNSAFE.getInt(null, struct + (long)ISIMPORT);
    }

    public static int nisAngled(long struct) {
        return UNSAFE.getInt(null, struct + (long)ISANGLED);
    }

    public static int nisModuleImport(long struct) {
        return UNSAFE.getInt(null, struct + (long)ISMODULEIMPORT);
    }

    static {
        Struct.Layout layout = CXIdxIncludedFileInfo.__struct((Struct.Member[])new Struct.Member[]{CXIdxIncludedFileInfo.__member((int)CXIdxLoc.SIZEOF, (int)CXIdxLoc.ALIGNOF), CXIdxIncludedFileInfo.__member((int)POINTER_SIZE), CXIdxIncludedFileInfo.__member((int)POINTER_SIZE), CXIdxIncludedFileInfo.__member((int)4), CXIdxIncludedFileInfo.__member((int)4), CXIdxIncludedFileInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HASHLOC = layout.offsetof(0);
        FILENAME = layout.offsetof(1);
        FILE = layout.offsetof(2);
        ISIMPORT = layout.offsetof(3);
        ISANGLED = layout.offsetof(4);
        ISMODULEIMPORT = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<CXIdxIncludedFileInfo, Buffer> {
        private static final CXIdxIncludedFileInfo ELEMENT_FACTORY = CXIdxIncludedFileInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CXIdxIncludedFileInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public CXIdxLoc hashLoc() {
            return CXIdxIncludedFileInfo.nhashLoc(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer filename() {
            return CXIdxIncludedFileInfo.nfilename(this.address());
        }

        @NativeType(value="char const *")
        public String filenameString() {
            return CXIdxIncludedFileInfo.nfilenameString(this.address());
        }

        @NativeType(value="CXFile")
        public long file() {
            return CXIdxIncludedFileInfo.nfile(this.address());
        }

        @NativeType(value="int")
        public boolean isImport() {
            return CXIdxIncludedFileInfo.nisImport(this.address()) != 0;
        }

        @NativeType(value="int")
        public boolean isAngled() {
            return CXIdxIncludedFileInfo.nisAngled(this.address()) != 0;
        }

        @NativeType(value="int")
        public boolean isModuleImport() {
            return CXIdxIncludedFileInfo.nisModuleImport(this.address()) != 0;
        }
    }
}

