/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.openvr.SpatialAnchorPose;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class VRSpatialAnchors {
    protected VRSpatialAnchors() {
        throw new UnsupportedOperationException();
    }

    public static int nVRSpatialAnchors_CreateSpatialAnchorFromDescriptor(long pchDescriptor, long pHandleOut) {
        long __functionAddress = OpenVR.VRSpatialAnchors.CreateSpatialAnchorFromDescriptor;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)pchDescriptor, (long)pHandleOut, (long)__functionAddress);
    }

    @NativeType(value="EVRSpatialAnchorError")
    public static int VRSpatialAnchors_CreateSpatialAnchorFromDescriptor(@NativeType(value="char const *") ByteBuffer pchDescriptor, @NativeType(value="SpatialAnchorHandle_t *") IntBuffer pHandleOut) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pchDescriptor);
            Checks.check((Buffer)pHandleOut, (int)1);
        }
        return VRSpatialAnchors.nVRSpatialAnchors_CreateSpatialAnchorFromDescriptor(MemoryUtil.memAddress((ByteBuffer)pchDescriptor), MemoryUtil.memAddress((IntBuffer)pHandleOut));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="EVRSpatialAnchorError")
    public static int VRSpatialAnchors_CreateSpatialAnchorFromDescriptor(@NativeType(value="char const *") CharSequence pchDescriptor, @NativeType(value="SpatialAnchorHandle_t *") IntBuffer pHandleOut) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pHandleOut, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchDescriptor, true);
            long pchDescriptorEncoded = stack.getPointerAddress();
            int n = VRSpatialAnchors.nVRSpatialAnchors_CreateSpatialAnchorFromDescriptor(pchDescriptorEncoded, MemoryUtil.memAddress((IntBuffer)pHandleOut));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRSpatialAnchors_CreateSpatialAnchorFromPose(int unDeviceIndex, int eOrigin, long pPose, long pHandleOut) {
        long __functionAddress = OpenVR.VRSpatialAnchors.CreateSpatialAnchorFromPose;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((int)unDeviceIndex, (int)eOrigin, (long)pPose, (long)pHandleOut, (long)__functionAddress);
    }

    @NativeType(value="EVRSpatialAnchorError")
    public static int VRSpatialAnchors_CreateSpatialAnchorFromPose(@NativeType(value="TrackedDeviceIndex_t") int unDeviceIndex, @NativeType(value="ETrackingUniverseOrigin") int eOrigin, @NativeType(value="SpatialAnchorPose_t *") SpatialAnchorPose pPose, @NativeType(value="SpatialAnchorHandle_t *") IntBuffer pHandleOut) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pHandleOut, (int)1);
        }
        return VRSpatialAnchors.nVRSpatialAnchors_CreateSpatialAnchorFromPose(unDeviceIndex, eOrigin, pPose.address(), MemoryUtil.memAddress((IntBuffer)pHandleOut));
    }

    public static int nVRSpatialAnchors_GetSpatialAnchorPose(int unHandle, int eOrigin, long pPoseOut) {
        long __functionAddress = OpenVR.VRSpatialAnchors.GetSpatialAnchorPose;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPI((int)unHandle, (int)eOrigin, (long)pPoseOut, (long)__functionAddress);
    }

    @NativeType(value="EVRSpatialAnchorError")
    public static int VRSpatialAnchors_GetSpatialAnchorPose(@NativeType(value="SpatialAnchorHandle_t") int unHandle, @NativeType(value="ETrackingUniverseOrigin") int eOrigin, @NativeType(value="SpatialAnchorPose_t *") SpatialAnchorPose pPoseOut) {
        return VRSpatialAnchors.nVRSpatialAnchors_GetSpatialAnchorPose(unHandle, eOrigin, pPoseOut.address());
    }

    public static int nVRSpatialAnchors_GetSpatialAnchorDescriptor(int unHandle, long pchDescriptorOut, long punDescriptorBufferLenInOut) {
        long __functionAddress = OpenVR.VRSpatialAnchors.GetSpatialAnchorDescriptor;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((int)unHandle, (long)pchDescriptorOut, (long)punDescriptorBufferLenInOut, (long)__functionAddress);
    }

    @NativeType(value="EVRSpatialAnchorError")
    public static int VRSpatialAnchors_GetSpatialAnchorDescriptor(@NativeType(value="SpatialAnchorHandle_t") int unHandle, @NativeType(value="char *") ByteBuffer pchDescriptorOut, @NativeType(value="uint32_t *") IntBuffer punDescriptorBufferLenInOut) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)punDescriptorBufferLenInOut, (int)1);
            Checks.check((Buffer)pchDescriptorOut, (int)punDescriptorBufferLenInOut.get(punDescriptorBufferLenInOut.position()));
        }
        return VRSpatialAnchors.nVRSpatialAnchors_GetSpatialAnchorDescriptor(unHandle, MemoryUtil.memAddress((ByteBuffer)pchDescriptorOut), MemoryUtil.memAddress((IntBuffer)punDescriptorBufferLenInOut));
    }
}

