/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.monitor.internal.metrics;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.ThreadPoolManager;
import org.openhab.core.io.monitor.internal.metrics.OpenhabCoreMeterBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ThreadPoolMetric
implements OpenhabCoreMeterBinder {
    private final Logger logger = LoggerFactory.getLogger(ThreadPoolMetric.class);
    public static final Tag CORE_THREADPOOL_METRIC_TAG = Tag.of("metric", "openhab.core.metric.threadpools");
    private static final String POOLNAME_TAG_NAME = "pool";
    private final Set<Tag> tags = new HashSet<Tag>();
    private @Nullable MeterRegistry meterRegistry;
    private Set<ExecutorServiceMetrics> executorServiceMetricsSet = new HashSet<ExecutorServiceMetrics>();

    public ThreadPoolMetric(Collection<Tag> tags) {
        this.tags.addAll(tags);
        this.tags.add(CORE_THREADPOOL_METRIC_TAG);
    }

    @Override
    public void bindTo(@NonNullByDefault(value={}) MeterRegistry registry) {
        this.unbind();
        this.logger.debug("ThreadPoolMetric is being bound...");
        this.meterRegistry = registry;
        try {
            ThreadPoolManager.getPoolNames().forEach(this::addPoolMetrics);
        }
        catch (NoSuchMethodError nsme) {
            this.logger.info("A newer version of openHAB is required for thread pool metrics to work.");
        }
    }

    private void addPoolMetrics(String poolName) {
        ExecutorService es = ThreadPoolManager.getPool((String)poolName);
        if (es == null) {
            return;
        }
        HashSet<Tag> tagsWithPoolname = new HashSet<Tag>(this.tags);
        tagsWithPoolname.add(Tag.of(POOLNAME_TAG_NAME, poolName));
        ExecutorServiceMetrics metrics = new ExecutorServiceMetrics(es, poolName, tagsWithPoolname);
        metrics.bindTo(this.meterRegistry);
        this.executorServiceMetricsSet.add(metrics);
    }

    @Override
    public void unbind() {
        MeterRegistry meterRegistry = this.meterRegistry;
        if (meterRegistry == null) {
            return;
        }
        for (Meter meter : meterRegistry.getMeters()) {
            if (!meter.getId().getTags().contains(CORE_THREADPOOL_METRIC_TAG)) continue;
            meterRegistry.remove(meter);
        }
        this.meterRegistry = null;
        this.executorServiceMetricsSet.clear();
    }
}

