# Macedonian

## Introduction

Ethnoastronomical research among Macedonian people began in 1982, organized by the Planetarium at Youth Cultural Centre. In the past years, around 140 villages in Republic of Macedonia have been visited and over 1500 inhabitants have been interviewed and surveyed. All collected information from the population have been published in the book “Sky over Macedonia” (Cenev G, 2004). An integral part of this book is the Sky map of Macedonian people which has been reconstructed based on the descriptions of constellations known to elderly inhabitants of Macedonian villages (Cenev G., 2000).

## Description

### Priest’s Straw (Popova Slama) *[Popovᴧ Slᴧmᴧ]*

Our galaxy (Milky Way) by its appearance is dominant on the summer sky.

### Threshing floor

Circular and foggy appearance of the Andromeda galaxy (М31) evoked people to see the threshing floor with straw from where the Priest was stealing from his Godson.

## Constellations

##### Mother Hen

is the best-known constellation, which is recognized by all elderly people in Macedonian villages, without any exception. This name people use for the star cluster Pleiades

##### Rooster

This is the name of the star Alnath (or Elnath) from the constellation Taurus.

##### Hawk

Hawk, as one of the most famous enemies of the Mother Hen and the Rooster, is right above them in an attacking position. Bright star Capella (Kapela) from the constellation Auriga is actually known among people as Hawk.

##### Fox

Fox is the second by importance natural enemy of the Mother Hen and the Rooster so it is obvious why people also “see” it on the sky. The red color of the bright star Aldebaran from the constellation of the Bull is the reason why people perceive it as a Fox ready to attack the Mother Hen and the Rooster.

##### Pigs

Near to the Mother Hen, people on the sky noticed the star cluster Hyades. Scattered appearance of the stars of this cluster associated people to the image of pigs in a village yard, and so it’s called Pigs.

##### Yoke

People under this name recognize group of stars in the constellation Perseus. Yokes for the oxen usually is found in village yards so that is why, like the previous constellation, is evidence of the general image of people and purpose given to this part of the sky.

##### Ploughman

The Ploughman is one of the three main characters in the sky. It is the name people gave to the bright star Betelgeuse in the constellation of Orion. Besides Betelgeuse, in building the image of this folk constellation, some weaker and less bright stars from the surrounding are also taken into account, because people say that the Ploughman is an image of a person with a goad as he returns home.

##### Plough

The constellation Orion with its numerous bright stars and distinctive pattern dominates the winter sky and can be easily found. People from Macedonian villages usually point at the region around Orion’s belt saying that three bright stars and surrounding less bright stars create an image of a wooden Plough with two yoked oxen (Ralo so Volovi, [Ralɔ sɔ Vɔlɔvi]).

##### Oxen

The constellation Orion with its numerous bright stars and distinctive pattern dominates the winter sky and can be easily found. People from Macedonian villages usually point at the region around Orion’s belt saying that three bright stars and surrounding less bright stars create an image of a wooden Plough with two yoked oxen (Ralo so Volovi, [Ralɔ sɔ Vɔlɔvi]).

##### Wolves

Near to the plough with oxen, which is left on a field, people see two wolves as well. They are the bright stars Sirius in the constellation Canis Major and Procyon in Canis Minor.

##### Cross

Complement with the people’s belief, when the Priest-thief saw God’s might he started running in panic and lost his cross on the way. So next to the Priest’s Straw there is the Cross.

##### Ears

By this common word used as a jargon, Macedonian villagers mark the part of the wooden plough that goes into the soil, used for plowing.

##### Trivet

The trivet is a metal device with three legs (tripod) which fits over the fireplace to support pans and kettles while preparing food.

##### Tongs

The Tongs were used for the fire where the trivet is. Thus, the people’s constellation Tongs is very close to the constellation Trivet.

##### Sofra

The typical semi-circular shape of the constellation Corona Borealis evoked the image of a wooden round table called sofra.

##### Auger

People say that this is a very big drill used for construction of houses and is found inside the Priest’s Straw

##### Aramii

The famous constellation Ursa Major among the people is described as a group of thieves. The seven bright stars of Ursa Major are said to be thieves „because during the entire night they circle on the sky same as thieves that circle around houses“

## References

 - [#1]: [Macedonian Research Society](http://mid.org.mk/ethnoastronomy/)
 - [#2]: [Cenev, Gjore (1985). *The astronomical knowledge of the south-west Macedonia's people.* "Publications of the Astronomical Society of "Rudjer Bošković", No. 4, p. 139 - 146". Belgrade, Yugoslavia](http://adsabs.harvard.edu/abs/1985PASRB...4..139C)
 - [#3]: Cenev, Gjore (2004). *Sky Map of Macedonian People.* Skopje, Mladinski kulturen centar.
 - [#4]: Cenev, Gjore (2004). *Neboto nad Makedonija [Sky over Macedonia].* Skopje, Mladinski kulturen centar.
 - [#5]: [Cenev, Gjore (2008). *Macedonian Folk Constellations.* Publications of the Astronomical Observatory of Belgrade, vol. 85, p. 97-109. Belgrade, Serbia.](http://adsabs.harvard.edu/abs/2008POBeo..85...97C)
 - [#6]: [Cenev, Gjore (2014). *The Ancient Sky Map Of The Macedonian People.* Cosmos – The Journal of the Traditional Cosmology Society, volume 30, Edinburgh, Scotland, United Kingdom.](http://www.academia.edu/18707131/The_Ancient_Sky_Map_Of_The_Macedonian_People)

## Authors

This sky culture was contributed by *Vancho Stojkoski* and *Gjore Cenev* from Macedonian Research Society based primarily on the book **Sky over Macedonia** by Cenev G, 2004.

## License

GNU GPL v2.0
