/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured.assertion;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ConfigurationUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.assertion.AssertionJwtTemplate;
import org.apache.kafka.common.security.oauthbearer.internals.secured.assertion.DynamicAssertionJwtTemplate;
import org.apache.kafka.common.security.oauthbearer.internals.secured.assertion.FileAssertionJwtTemplate;
import org.apache.kafka.common.security.oauthbearer.internals.secured.assertion.LayeredAssertionJwtTemplate;
import org.apache.kafka.common.security.oauthbearer.internals.secured.assertion.StaticAssertionJwtTemplate;
import org.apache.kafka.common.utils.Time;

public class AssertionUtils {
    public static final String TOKEN_SIGNING_ALGORITHM_RS256 = "RS256";
    public static final String TOKEN_SIGNING_ALGORITHM_ES256 = "ES256";

    public static PrivateKey privateKey(byte[] privateKeyContents, Optional<String> passphrase) throws GeneralSecurityException, IOException {
        PKCS8EncodedKeySpec keySpec;
        if (passphrase.isPresent()) {
            EncryptedPrivateKeyInfo keyInfo = new EncryptedPrivateKeyInfo(privateKeyContents);
            String algorithm = keyInfo.getAlgName();
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(algorithm);
            SecretKey pbeKey = secretKeyFactory.generateSecret(new PBEKeySpec(passphrase.get().toCharArray()));
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(2, (Key)pbeKey, keyInfo.getAlgParameters());
            keySpec = keyInfo.getKeySpec(cipher);
        } else {
            byte[] pkcs8EncodedBytes = Base64.getDecoder().decode(privateKeyContents);
            keySpec = new PKCS8EncodedKeySpec(pkcs8EncodedBytes);
        }
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(keySpec);
    }

    public static Signature getSignature(String algorithm) throws GeneralSecurityException {
        if (algorithm.equalsIgnoreCase(TOKEN_SIGNING_ALGORITHM_RS256)) {
            return Signature.getInstance("SHA256withRSA");
        }
        if (algorithm.equalsIgnoreCase(TOKEN_SIGNING_ALGORITHM_ES256)) {
            return Signature.getInstance("SHA256withECDSA");
        }
        throw new NoSuchAlgorithmException(String.format("Unsupported signing algorithm: %s", algorithm));
    }

    public static String sign(String algorithm, PrivateKey privateKey, String contentToSign) throws GeneralSecurityException {
        Signature signature = AssertionUtils.getSignature(algorithm);
        signature.initSign(privateKey);
        signature.update(contentToSign.getBytes(StandardCharsets.UTF_8));
        byte[] signedContent = signature.sign();
        return Base64.getUrlEncoder().withoutPadding().encodeToString(signedContent);
    }

    public static Optional<StaticAssertionJwtTemplate> staticAssertionJwtTemplate(ConfigurationUtils cu) {
        if (cu.containsKey("sasl.oauthbearer.assertion.claim.aud") || cu.containsKey("sasl.oauthbearer.assertion.claim.iss") || cu.containsKey("sasl.oauthbearer.assertion.claim.sub")) {
            HashMap<String, Object> staticClaimsPayload = new HashMap<String, Object>();
            if (cu.containsKey("sasl.oauthbearer.assertion.claim.aud")) {
                staticClaimsPayload.put("aud", cu.validateString("sasl.oauthbearer.assertion.claim.aud"));
            }
            if (cu.containsKey("sasl.oauthbearer.assertion.claim.iss")) {
                staticClaimsPayload.put("iss", cu.validateString("sasl.oauthbearer.assertion.claim.iss"));
            }
            if (cu.containsKey("sasl.oauthbearer.assertion.claim.sub")) {
                staticClaimsPayload.put("sub", cu.validateString("sasl.oauthbearer.assertion.claim.sub"));
            }
            Map<String, Object> header = Map.of();
            return Optional.of(new StaticAssertionJwtTemplate(header, staticClaimsPayload));
        }
        return Optional.empty();
    }

    public static Optional<FileAssertionJwtTemplate> fileAssertionJwtTemplate(ConfigurationUtils cu) {
        if (cu.containsKey("sasl.oauthbearer.assertion.template.file")) {
            File assertionTemplateFile = cu.validateFile("sasl.oauthbearer.assertion.template.file");
            return Optional.of(new FileAssertionJwtTemplate(assertionTemplateFile));
        }
        return Optional.empty();
    }

    public static DynamicAssertionJwtTemplate dynamicAssertionJwtTemplate(ConfigurationUtils cu, Time time) {
        String algorithm = cu.validateString("sasl.oauthbearer.assertion.algorithm");
        int expSeconds = cu.validateInteger("sasl.oauthbearer.assertion.claim.exp.seconds", true);
        int nbfSeconds = cu.validateInteger("sasl.oauthbearer.assertion.claim.nbf.seconds", true);
        boolean includeJti = cu.validateBoolean("sasl.oauthbearer.assertion.claim.jti.include", true);
        return new DynamicAssertionJwtTemplate(time, algorithm, expSeconds, nbfSeconds, includeJti);
    }

    public static LayeredAssertionJwtTemplate layeredAssertionJwtTemplate(ConfigurationUtils cu, Time time) {
        ArrayList<AssertionJwtTemplate> templates = new ArrayList<AssertionJwtTemplate>();
        AssertionUtils.staticAssertionJwtTemplate(cu).ifPresent(templates::add);
        AssertionUtils.fileAssertionJwtTemplate(cu).ifPresent(templates::add);
        templates.add(AssertionUtils.dynamicAssertionJwtTemplate(cu, time));
        return new LayeredAssertionJwtTemplate(templates);
    }
}

