/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.tools.jar;

import com.googlecode.d2j.DexLabel;
import com.googlecode.d2j.Field;
import com.googlecode.d2j.Method;
import com.googlecode.d2j.node.DexCodeNode;
import com.googlecode.d2j.node.DexMethodNode;
import com.googlecode.d2j.reader.Op;
import com.googlecode.d2j.tools.jar.BaseWeaver;
import com.googlecode.d2j.visitors.DexClassVisitor;
import com.googlecode.d2j.visitors.DexCodeVisitor;
import com.googlecode.d2j.visitors.DexFileVisitor;
import com.googlecode.d2j.visitors.DexMethodVisitor;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.objectweb.asm.Type;

public class DexWeaver
extends BaseWeaver {
    public String buildInvocationClz(DexFileVisitor dfv) {
        int i;
        String typeName = this.getCurrentInvocationName();
        String typeNameDesc = "L" + typeName + ";";
        DexClassVisitor dcv = dfv.visit(1, typeNameDesc, "Ljava/lang/Object;", new String[]{this.invocationInterfaceDesc});
        dcv.visitField(18, new Field(typeNameDesc, "thiz", "Ljava/lang/Object;"), null).visitEnd();
        dcv.visitField(18, new Field(typeNameDesc, "args", "[Ljava/lang/Object;"), null).visitEnd();
        dcv.visitField(18, new Field(typeNameDesc, "idx", "I"), null).visitEnd();
        DexMethodVisitor mv = dcv.visitMethod(65537, new Method(typeNameDesc, "<init>", new String[]{"Ljava/lang/Object;", "[Ljava/lang/Object;", "I"}, "V"));
        DexCodeVisitor codeVisitor = mv.visitCode();
        codeVisitor.visitRegister(4);
        codeVisitor.visitFieldStmt(Op.IPUT_OBJECT, 1, 0, new Field(typeNameDesc, "thiz", "Ljava/lang/Object;"));
        codeVisitor.visitFieldStmt(Op.IPUT_OBJECT, 2, 0, new Field(typeNameDesc, "args", "[Ljava/lang/Object;"));
        codeVisitor.visitFieldStmt(Op.IPUT, 3, 0, new Field(typeNameDesc, "idx", "I"));
        codeVisitor.visitStmt0R(Op.RETURN_VOID);
        codeVisitor.visitEnd();
        mv.visitEnd();
        this.genSwitchMethod(dcv, typeNameDesc, "getMethodOwner", new CB(){

            @Override
            public String getKey(Method mtd) {
                return BaseWeaver.toInternal(mtd.getOwner());
            }
        });
        this.genSwitchMethod(dcv, typeNameDesc, "getMethodName", new CB(){

            @Override
            public String getKey(Method mtd) {
                return mtd.getName();
            }
        });
        this.genSwitchMethod(dcv, typeNameDesc, "getMethodDesc", new CB(){

            @Override
            public String getKey(Method mtd) {
                return mtd.getDesc();
            }
        });
        mv = dcv.visitMethod(1, new Method(typeNameDesc, "getArguments", new String[0], "[Ljava/lang/Object;"));
        DexCodeVisitor code = mv.visitCode();
        code.visitRegister(2);
        code.visitFieldStmt(Op.IGET, 0, 1, new Field(typeNameDesc, "args", "[Ljava/lang/Object;"));
        code.visitStmt1R(Op.RETURN_OBJECT, 0);
        code.visitEnd();
        mv.visitEnd();
        mv = dcv.visitMethod(1, new Method(typeNameDesc, "getThis", new String[0], "Ljava/lang/Object;"));
        code = mv.visitCode();
        code.visitRegister(2);
        code.visitFieldStmt(Op.IGET, 0, 1, new Field(typeNameDesc, "thiz", "Ljava/lang/Object;"));
        code.visitStmt1R(Op.RETURN_OBJECT, 0);
        code.visitEnd();
        mv.visitEnd();
        mv = dcv.visitMethod(1, new Method(typeNameDesc, "proceed", new String[0], "Ljava/lang/Object;"));
        code = mv.visitCode();
        code.visitRegister(4);
        code.visitFieldStmt(Op.IGET, 0, 3, new Field(typeNameDesc, "thiz", "Ljava/lang/Object;"));
        code.visitFieldStmt(Op.IGET, 1, 3, new Field(typeNameDesc, "args", "[Ljava/lang/Object;"));
        code.visitFieldStmt(Op.IGET, 2, 3, new Field(typeNameDesc, "idx", "I"));
        DexLabel[] labels = new DexLabel[this.callbacks.size()];
        for (i = 0; i < labels.length; ++i) {
            labels[i] = new DexLabel();
        }
        code.visitPackedSwitchStmt(Op.PACKED_SWITCH, 2, 0, labels);
        code.visitTypeStmt(Op.NEW_INSTANCE, 0, 0, "Ljava/lang/RuntimeException;");
        code.visitConstStmt(Op.CONST_STRING, 1, (Object)"invalid idx");
        code.visitMethodStmt(Op.INVOKE_DIRECT, new int[]{0, 1}, new Method("Ljava/lang/RuntimeException;", "<init>", new String[]{"Ljava/lang/String;"}, "V"));
        code.visitStmt1R(Op.THROW, 0);
        for (i = 0; i < labels.length; ++i) {
            code.visitLabel(labels[i]);
            BaseWeaver.Callback callback = (BaseWeaver.Callback)this.callbacks.get(i);
            Method mCallback = (Method)callback.callback;
            if (callback.isStatic) {
                code.visitMethodStmt(Op.INVOKE_STATIC, new int[]{1}, mCallback);
            } else if (callback.isSpecial) {
                code.visitTypeStmt(Op.CHECK_CAST, 0, -1, mCallback.getOwner());
                code.visitMethodStmt(Op.INVOKE_VIRTUAL, new int[]{0, 1}, mCallback);
            } else {
                code.visitMethodStmt(Op.INVOKE_STATIC, new int[]{0, 1}, mCallback);
            }
            code.visitStmt1R(Op.MOVE_RESULT_OBJECT, 0);
            code.visitStmt1R(Op.RETURN_OBJECT, 0);
        }
        code.visitEnd();
        mv.visitEnd();
        dcv.visitEnd();
        return typeName;
    }

    private void genSwitchMethod(DexClassVisitor dcv, String typeNameDesc, String methodName, CB callback) {
        DexMethodVisitor dmv = dcv.visitMethod(1, new Method(typeNameDesc, methodName, new String[0], "Ljava/lang/String;"));
        DexCodeVisitor code = dmv.visitCode();
        code.visitRegister(3);
        code.visitFieldStmt(Op.IGET, 0, 2, new Field(typeNameDesc, "idx", "I"));
        DexLabel[] labels = new DexLabel[this.callbacks.size()];
        TreeMap<String, DexLabel> strMap = new TreeMap<String, DexLabel>();
        for (int i = 0; i < labels.length; ++i) {
            BaseWeaver.Callback cb = (BaseWeaver.Callback)this.callbacks.get(i);
            String key = callback.getKey((Method)cb.target);
            DexLabel label = (DexLabel)strMap.get(key);
            if (label == null) {
                label = new DexLabel();
                strMap.put(key, label);
            }
            labels[i] = label;
        }
        code.visitPackedSwitchStmt(Op.PACKED_SWITCH, 0, 0, labels);
        code.visitTypeStmt(Op.NEW_INSTANCE, 0, 0, "Ljava/lang/RuntimeException;");
        code.visitConstStmt(Op.CONST_STRING, 1, (Object)"invalid idx");
        code.visitMethodStmt(Op.INVOKE_DIRECT, new int[]{0, 1}, new Method("Ljava/lang/RuntimeException;", "<init>", new String[]{"Ljava/lang/String;"}, "V"));
        code.visitStmt1R(Op.THROW, 0);
        for (Map.Entry e : strMap.entrySet()) {
            code.visitLabel((DexLabel)e.getValue());
            code.visitConstStmt(Op.CONST_STRING, 0, e.getKey());
            code.visitStmt1R(Op.RETURN_OBJECT, 0);
        }
        code.visitEnd();
        dmv.visitEnd();
    }

    public DexFileVisitor wrap(DexFileVisitor dcv) {
        return dcv == null ? null : new DexFileVisitor(dcv){

            public DexClassVisitor visit(int access_flags, String className, String superClass, String[] interfaceNames) {
                return DexWeaver.this.wrap(className, super.visit(access_flags, className, superClass, interfaceNames));
            }
        };
    }

    public DexClassVisitor wrap(final String classNameDesc, final DexClassVisitor dcv) {
        return dcv == null ? null : new DexClassVisitor(dcv){
            Map<BaseWeaver.MtdInfo, Method> cache;
            {
                super(x0);
                this.cache = new HashMap<BaseWeaver.MtdInfo, Method>();
            }

            public DexMethodVisitor visitMethod(int accessFlags, Method method) {
                final DexMethodVisitor dmv = this.superVisitDexMethod(accessFlags, method);
                final BaseWeaver.MtdInfo mapTo = DexWeaver.this.findDefinedTargetMethod(method.getOwner(), method.getName(), method.getDesc());
                if (mapTo != null) {
                    final Method t = new Method(method.getOwner(), DexWeaver.this.buildMethodAName(method.getName()), method.getParameterTypes(), method.getReturnType());
                    final Method src = method;
                    return new DexMethodNode(accessFlags, method){

                        public void visitEnd() {
                            super.visitEnd();
                            DexCodeNode code = this.codeNode;
                            this.codeNode = null;
                            this.accept(dmv);
                            Op opcode = Modifier.isStatic(this.access) ? Op.INVOKE_STATIC_RANGE : Op.INVOKE_VIRTUAL_RANGE;
                            this.generateMtdACode(opcode, t, mapTo, dmv, src);
                            int newAccess = this.access & 0xFFFFFFF9 | 1;
                            code.accept(this.wrap(this.superVisitDexMethod(newAccess, t), dcv));
                        }
                    };
                }
                return this.wrap(dmv, dcv);
            }

            private DexMethodVisitor wrap(DexMethodVisitor dmv, final DexClassVisitor classVisitor) {
                return dmv == null ? null : new DexMethodVisitor(dmv){

                    public DexCodeVisitor visitCode() {
                        return this.wrap(super.visitCode(), classVisitor);
                    }
                };
            }

            private DexCodeVisitor wrap(DexCodeVisitor dcv2, final DexClassVisitor classVisitor) {
                return dcv2 == null ? null : new DexCodeVisitor(dcv2){

                    public void visitMethodStmt(Op op, int[] args, Method method) {
                        BaseWeaver.MtdInfo mapTo = DexWeaver.this.findTargetMethod(method.getOwner(), method.getName(), method.getDesc());
                        if (mapTo != null) {
                            Method methodA = cache.get(DexWeaver.this.buildKey(method.getOwner(), method.getName(), method.getDesc()));
                            if (methodA == null) {
                                methodA = DexWeaver.this.isStatic(op) ? new Method(classNameDesc, DexWeaver.this.buildMethodAName(method.getName()), method.getParameterTypes(), method.getReturnType()) : new Method(classNameDesc, DexWeaver.this.buildMethodAName(method.getName()), DexWeaver.this.join(method.getOwner(), method.getParameterTypes()), method.getReturnType());
                                DexMethodVisitor dmv = classVisitor.visitMethod(10, methodA);
                                this.generateMtdACode(op, method, mapTo, dmv, method);
                                dmv.visitEnd();
                                cache.put(DexWeaver.this.buildKey(method.getOwner(), method.getName(), method.getDesc()), methodA);
                            }
                            super.visitMethodStmt(DexWeaver.this.isRange(op) ? Op.INVOKE_STATIC_RANGE : Op.INVOKE_STATIC, args, methodA);
                        } else {
                            super.visitMethodStmt(op, args, method);
                        }
                    }
                };
            }

            private void generateMtdACode(Op opcode, Method t, BaseWeaver.MtdInfo mapTo, DexMethodVisitor dmv, Method src) {
                DexCodeVisitor dcv2 = dmv.visitCode();
                int countArge = DexWeaver.countArgs(t);
                boolean haveThis = DexWeaver.this.haveThis(opcode);
                int registers = 4 + (haveThis ? 1 : 0) + countArge;
                dcv2.visitRegister(registers);
                int argStart = 4;
                if (haveThis) {
                    dcv2.visitStmt2R(Op.MOVE_OBJECT, 0, argStart);
                    ++argStart;
                } else {
                    dcv2.visitConstStmt(Op.CONST_4, 0, (Object)0);
                }
                if (t.getParameterTypes().length == 0) {
                    dcv2.visitConstStmt(Op.CONST_4, 1, (Object)0);
                } else {
                    dcv2.visitConstStmt(Op.CONST, 1, (Object)t.getParameterTypes().length);
                    dcv2.visitTypeStmt(Op.NEW_ARRAY, 1, 1, "[Ljava/lang/Object;");
                    for (int i = 0; i < t.getParameterTypes().length; ++i) {
                        char type = t.getParameterTypes()[i].charAt(0);
                        dcv2.visitConstStmt(Op.CONST, 2, (Object)i);
                        DexWeaver.this.box(type, argStart, 3, dcv2);
                        dcv2.visitStmt3R(Op.APUT_OBJECT, 3, 1, 2);
                        if (type == 'J' || type == 'D') {
                            argStart += 2;
                            continue;
                        }
                        ++argStart;
                    }
                }
                int nextIdx = DexWeaver.this.callbacks.size();
                dcv2.visitConstStmt(Op.CONST, 2, (Object)nextIdx);
                String miTypeDesc = "L" + DexWeaver.this.getCurrentInvocationName() + ";";
                dcv2.visitTypeStmt(Op.NEW_INSTANCE, 3, 0, miTypeDesc);
                dcv2.visitMethodStmt(Op.INVOKE_DIRECT, new int[]{3, 0, 1, 2}, new Method(miTypeDesc, "<init>", new String[]{"Ljava/lang/Object;", "[Ljava/lang/Object;", "I"}, "V"));
                Method call = DexWeaver.this.build(mapTo);
                dcv2.visitMethodStmt(Op.INVOKE_STATIC, new int[]{3}, call);
                if (!"V".equals(t.getReturnType())) {
                    switch (call.getReturnType().charAt(0)) {
                        case 'L': 
                        case '[': {
                            dcv2.visitStmt1R(Op.MOVE_RESULT_OBJECT, 0);
                            break;
                        }
                        case 'D': 
                        case 'J': {
                            dcv2.visitStmt1R(Op.MOVE_RESULT_WIDE, 0);
                            break;
                        }
                        default: {
                            dcv2.visitStmt1R(Op.MOVE_RESULT, 0);
                        }
                    }
                    DexWeaver.this.unbox(t.getReturnType(), 0, dcv2);
                    switch (t.getReturnType().charAt(0)) {
                        case 'L': 
                        case '[': {
                            dcv2.visitStmt1R(Op.RETURN_OBJECT, 0);
                            break;
                        }
                        case 'D': 
                        case 'J': {
                            dcv2.visitStmt1R(Op.RETURN_WIDE, 0);
                            break;
                        }
                        default: {
                            dcv2.visitStmt1R(Op.RETURN, 0);
                            break;
                        }
                    }
                } else {
                    dcv2.visitStmt0R(Op.RETURN_VOID);
                }
                BaseWeaver.Callback cb = new BaseWeaver.Callback();
                cb.idx = nextIdx;
                cb.callback = this.newMethodCallback(opcode, t);
                cb.target = src;
                cb.isSpecial = DexWeaver.this.isSuper(opcode);
                cb.isStatic = DexWeaver.this.isStatic(opcode);
                DexWeaver.this.callbacks.add(cb);
            }

            private Method newMethodCallback(Op opcode, Method t) {
                int argStart;
                int totalRegs;
                boolean isStatic = !DexWeaver.this.haveThis(opcode);
                boolean isSuper = DexWeaver.this.isSuper(opcode);
                Method m = isSuper || isStatic ? new Method(t.getOwner(), DexWeaver.this.buildCallbackMethodName(t.getName()), new String[]{"[Ljava/lang/Object;"}, "Ljava/lang/Object;") : new Method(t.getOwner(), DexWeaver.this.buildCallbackMethodName(t.getName()), new String[]{"Ljava/lang/Object;", "[Ljava/lang/Object;"}, "Ljava/lang/Object;");
                DexMethodVisitor dmv = this.superVisitDexMethod(1 | (isSuper ? 0 : 8), m);
                DexCodeVisitor dcv2 = dmv.visitCode();
                if (isStatic) {
                    totalRegs = 1 + DexWeaver.countArgs(t) + 1;
                    argStart = totalRegs - 1;
                } else {
                    totalRegs = 1 + DexWeaver.countArgs(t) + 2;
                    argStart = totalRegs - 2;
                }
                dcv2.visitRegister(totalRegs);
                int[] args = new int[DexWeaver.countArgs(t) + (isStatic ? 0 : 1)];
                int args_index = 0;
                int i = 1;
                if (!isStatic) {
                    if (i != argStart) {
                        dcv2.visitStmt2R(Op.MOVE_OBJECT, i, argStart);
                    }
                    if (!isSuper) {
                        dcv2.visitTypeStmt(Op.CHECK_CAST, i, -1, t.getOwner());
                    }
                    args[args_index++] = i++;
                    ++argStart;
                }
                String[] parameterTypes = t.getParameterTypes();
                for (int i1 = 0; i1 < parameterTypes.length; ++i1) {
                    String argType = parameterTypes[i1];
                    dcv2.visitConstStmt(Op.CONST, 0, (Object)i1);
                    dcv2.visitStmt3R(Op.AGET_OBJECT, i, argStart, 0);
                    DexWeaver.this.unbox(argType, i, dcv2);
                    args[args_index++] = i++;
                    if (argType.charAt(0) != 'J' && argType.charAt(0) != 'D') continue;
                    args[args_index++] = i + 1;
                    i += 2;
                }
                dcv2.visitMethodStmt(opcode, args, t);
                if ("V".equals(t.getReturnType())) {
                    dcv2.visitConstStmt(Op.CONST, 0, (Object)0);
                } else {
                    switch (t.getReturnType().charAt(0)) {
                        case 'L': 
                        case '[': {
                            dcv2.visitStmt1R(Op.MOVE_RESULT_OBJECT, 0);
                            break;
                        }
                        case 'D': 
                        case 'J': {
                            dcv2.visitStmt1R(Op.MOVE_RESULT_WIDE, 0);
                            break;
                        }
                        default: {
                            dcv2.visitStmt1R(Op.MOVE_RESULT, 0);
                        }
                    }
                    DexWeaver.this.box(t.getReturnType().charAt(0), 0, 0, dcv2);
                }
                dcv2.visitStmt1R(Op.RETURN_OBJECT, 0);
                return m;
            }

            private DexMethodVisitor superVisitDexMethod(int accessFlags, Method method) {
                return super.visitMethod(accessFlags, method);
            }
        };
    }

    private String[] join(String a, String[] b) {
        String[] joined = new String[b.length + 1];
        joined[0] = a;
        System.arraycopy(b, 0, joined, 1, b.length);
        return joined;
    }

    private boolean isStatic(Op op) {
        return op == Op.INVOKE_STATIC || op == Op.INVOKE_STATIC_RANGE;
    }

    private boolean isRange(Op op) {
        switch (op) {
            case INVOKE_STATIC_RANGE: 
            case INVOKE_DIRECT_RANGE: 
            case INVOKE_INTERFACE_RANGE: 
            case INVOKE_SUPER_RANGE: 
            case INVOKE_VIRTUAL_RANGE: {
                return true;
            }
        }
        return false;
    }

    private void unbox(String argType, int i, DexCodeVisitor dcv) {
        switch (argType.charAt(0)) {
            case 'L': 
            case '[': {
                dcv.visitTypeStmt(Op.CHECK_CAST, i, i, argType);
                break;
            }
            case 'Z': {
                dcv.visitTypeStmt(Op.CHECK_CAST, i, i, "Ljava/lang/Boolean;");
                dcv.visitMethodStmt(Op.INVOKE_VIRTUAL_RANGE, new int[]{i}, new Method("Ljava/lang/Boolean;", "booleanValue", new String[0], "Z"));
                dcv.visitStmt1R(Op.MOVE_RESULT, i);
                break;
            }
            case 'B': {
                dcv.visitTypeStmt(Op.CHECK_CAST, i, i, "Ljava/lang/Byte;");
                dcv.visitMethodStmt(Op.INVOKE_VIRTUAL_RANGE, new int[]{i}, new Method("Ljava/lang/Byte;", "byteValue", new String[0], "B"));
                dcv.visitStmt1R(Op.MOVE_RESULT, i);
                break;
            }
            case 'S': {
                dcv.visitTypeStmt(Op.CHECK_CAST, i, i, "Ljava/lang/Short;");
                dcv.visitMethodStmt(Op.INVOKE_VIRTUAL_RANGE, new int[]{i}, new Method("Ljava/lang/Short;", "shortValue", new String[0], "S"));
                dcv.visitStmt1R(Op.MOVE_RESULT, i);
                break;
            }
            case 'C': {
                dcv.visitTypeStmt(Op.CHECK_CAST, i, i, "Ljava/lang/Character;");
                dcv.visitMethodStmt(Op.INVOKE_VIRTUAL_RANGE, new int[]{i}, new Method("Ljava/lang/Character;", "charValue", new String[0], "C"));
                dcv.visitStmt1R(Op.MOVE_RESULT, i);
                break;
            }
            case 'I': {
                dcv.visitTypeStmt(Op.CHECK_CAST, i, i, "Ljava/lang/Integer;");
                dcv.visitMethodStmt(Op.INVOKE_VIRTUAL_RANGE, new int[]{i}, new Method("Ljava/lang/Integer;", "intValue", new String[0], "I"));
                dcv.visitStmt1R(Op.MOVE_RESULT, i);
                break;
            }
            case 'F': {
                dcv.visitTypeStmt(Op.CHECK_CAST, i, i, "Ljava/lang/Float;");
                dcv.visitMethodStmt(Op.INVOKE_VIRTUAL_RANGE, new int[]{i}, new Method("Ljava/lang/Float;", "floatValue", new String[0], "F"));
                dcv.visitStmt1R(Op.MOVE_RESULT, i);
                break;
            }
            case 'D': {
                dcv.visitTypeStmt(Op.CHECK_CAST, i, i, "Ljava/lang/Double;");
                dcv.visitMethodStmt(Op.INVOKE_VIRTUAL_RANGE, new int[]{i}, new Method("Ljava/lang/Double;", "doubleValue", new String[0], "D"));
                dcv.visitStmt1R(Op.MOVE_RESULT_WIDE, i);
                break;
            }
            case 'J': {
                dcv.visitTypeStmt(Op.CHECK_CAST, i, i, "Ljava/lang/Long;");
                dcv.visitMethodStmt(Op.INVOKE_VIRTUAL_RANGE, new int[]{i}, new Method("Ljava/lang/Long;", "longValue", new String[0], "J"));
                dcv.visitStmt1R(Op.MOVE_RESULT_WIDE, i);
            }
        }
    }

    private boolean isSuper(Op opcode) {
        return opcode == Op.INVOKE_SUPER || opcode == Op.INVOKE_SUPER_RANGE;
    }

    private Method build(BaseWeaver.MtdInfo mapTo) {
        Type[] ts = Type.getArgumentTypes((String)mapTo.desc);
        String[] ss = new String[ts.length];
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = ts[i].getDescriptor();
        }
        return new Method(mapTo.owner, mapTo.name, ss, Type.getReturnType((String)mapTo.desc).getDescriptor());
    }

    private void box(char type, int from, int to, DexCodeVisitor dcv) {
        switch (type) {
            case 'L': 
            case '[': {
                dcv.visitStmt2R(Op.MOVE_OBJECT, from, to);
                break;
            }
            case 'Z': {
                dcv.visitMethodStmt(Op.INVOKE_STATIC_RANGE, new int[]{from}, new Method("Ljava/lang/Boolean;", "valueOf", new String[]{"Z"}, "Ljava/lang/Boolean;"));
                dcv.visitStmt1R(Op.MOVE_RESULT_OBJECT, to);
                break;
            }
            case 'B': {
                dcv.visitMethodStmt(Op.INVOKE_STATIC_RANGE, new int[]{from}, new Method("Ljava/lang/Byte;", "valueOf", new String[]{"B"}, "Ljava/lang/Byte;"));
                dcv.visitStmt1R(Op.MOVE_RESULT_OBJECT, to);
                break;
            }
            case 'S': {
                dcv.visitMethodStmt(Op.INVOKE_STATIC_RANGE, new int[]{from}, new Method("Ljava/lang/Short;", "valueOf", new String[]{"S"}, "Ljava/lang/Short;"));
                dcv.visitStmt1R(Op.MOVE_RESULT_OBJECT, to);
                break;
            }
            case 'C': {
                dcv.visitMethodStmt(Op.INVOKE_STATIC_RANGE, new int[]{from}, new Method("Ljava/lang/Character;", "valueOf", new String[]{"C"}, "Ljava/lang/Character;"));
                dcv.visitStmt1R(Op.MOVE_RESULT_OBJECT, to);
                break;
            }
            case 'I': {
                dcv.visitMethodStmt(Op.INVOKE_STATIC_RANGE, new int[]{from}, new Method("Ljava/lang/Integer;", "valueOf", new String[]{"I"}, "Ljava/lang/Integer;"));
                dcv.visitStmt1R(Op.MOVE_RESULT_OBJECT, to);
                break;
            }
            case 'F': {
                dcv.visitMethodStmt(Op.INVOKE_STATIC_RANGE, new int[]{from}, new Method("Ljava/lang/Float;", "valueOf", new String[]{"F"}, "Ljava/lang/Float;"));
                dcv.visitStmt1R(Op.MOVE_RESULT_OBJECT, to);
                break;
            }
            case 'D': {
                dcv.visitMethodStmt(Op.INVOKE_STATIC_RANGE, new int[]{from, from + 1}, new Method("Ljava/lang/Double;", "valueOf", new String[]{"D"}, "Ljava/lang/Double;"));
                dcv.visitStmt1R(Op.MOVE_RESULT_OBJECT, to);
                break;
            }
            case 'J': {
                dcv.visitMethodStmt(Op.INVOKE_STATIC_RANGE, new int[]{from, from + 1}, new Method("Ljava/lang/Long;", "valueOf", new String[]{"J"}, "Ljava/lang/Long;"));
                dcv.visitStmt1R(Op.MOVE_RESULT_OBJECT, to);
            }
        }
    }

    private boolean haveThis(Op opcode) {
        return opcode != Op.INVOKE_STATIC && opcode != Op.INVOKE_STATIC_RANGE;
    }

    static int countArgs(Method t) {
        int i = 0;
        for (String arg : t.getParameterTypes()) {
            char type = arg.charAt(0);
            if (type == 'J' || type == 'D') {
                i += 2;
                continue;
            }
            ++i;
        }
        return i;
    }

    static interface CB {
        public String getKey(Method var1);
    }
}

