/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.resource;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.resource.MemoryInputStream;
import io.smallrye.common.resource.Resource;
import io.smallrye.common.resource.ResourceURLStreamHandler;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Instant;

public final class MemoryResource
extends Resource {
    private final ByteBuffer data;
    private final Instant modifiedTime = Instant.now();
    private URL url;

    public MemoryResource(String pathName, ByteBuffer data) {
        super(pathName);
        this.data = ((ByteBuffer)Assert.checkNotNullParam((String)"data", (Object)data)).asReadOnlyBuffer();
    }

    public MemoryResource(String pathName, byte[] data) {
        this(pathName, ByteBuffer.wrap(data));
    }

    @Override
    public URL url() {
        URL url = this.url;
        if (url == null) {
            try {
                this.url = url = new URL("memory", null, -1, this.pathName(), new ResourceURLStreamHandler(this));
            }
            catch (MalformedURLException e) {
                throw new UncheckedIOException("Unexpected URL problem", e);
            }
        }
        return url;
    }

    @Override
    public MemoryInputStream openStream() {
        return new MemoryInputStream(this.data);
    }

    @Override
    public ByteBuffer asBuffer() {
        return this.data.duplicate();
    }

    @Override
    public long copyTo(Path destination) throws IOException {
        try (SeekableByteChannel ch = Files.newByteChannel(destination, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
            long l = this.copyTo(ch);
            return l;
        }
    }

    @Override
    public long copyTo(WritableByteChannel channel) throws IOException {
        SelectableChannel sc;
        if (channel instanceof SelectableChannel && !(sc = (SelectableChannel)((Object)channel)).isBlocking()) {
            return super.copyTo(channel);
        }
        long cnt = 0L;
        ByteBuffer buf = this.data.duplicate();
        while (buf.hasRemaining()) {
            long res = channel.write(buf);
            cnt += res;
        }
        return cnt;
    }

    @Override
    public long copyTo(OutputStream destination) throws IOException {
        if (destination instanceof FileOutputStream) {
            FileOutputStream fos = (FileOutputStream)destination;
            return this.copyTo(fos.getChannel());
        }
        return super.copyTo(destination);
    }

    @Override
    public Instant modifiedTime() {
        return this.modifiedTime;
    }

    @Override
    public long size() {
        return this.data.remaining();
    }
}

