/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.tokenexchange;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.keycloak.authentication.actiontoken.TokenUtils;
import org.keycloak.common.Profile;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.TokenExchangeContext;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.encode.AccessTokenContext;
import org.keycloak.protocol.oidc.encode.TokenContextEncoderProvider;
import org.keycloak.protocol.oidc.tokenexchange.AbstractTokenExchangeProvider;
import org.keycloak.rar.AuthorizationRequestContext;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.util.AuthorizationContextUtil;
import org.keycloak.services.util.UserSessionUtil;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;
import org.keycloak.util.TokenUtil;

public class StandardTokenExchangeProvider
extends AbstractTokenExchangeProvider {
    public int getVersion() {
        return 2;
    }

    public boolean supports(TokenExchangeContext context) {
        String requestedSubject = (String)context.getFormParams().getFirst((Object)"requested_subject");
        if (requestedSubject != null) {
            context.setUnsupportedReason("Parameter 'requested_subject' is not supported for standard token exchange");
            return false;
        }
        String requestedIssuer = (String)context.getFormParams().getFirst((Object)"requested_issuer");
        if (requestedIssuer != null) {
            context.setUnsupportedReason("Parameter 'requested_issuer' is not supported for standard token exchange");
            return false;
        }
        String subjectIssuer = (String)context.getFormParams().getFirst((Object)"subject_issuer");
        if (subjectIssuer != null) {
            context.setUnsupportedReason("Parameter 'subject_issuer' is not supported for standard token exchange");
            return false;
        }
        if (!OIDCAdvancedConfigWrapper.fromClientModel(context.getClient()).isStandardTokenExchangeEnabled()) {
            context.setUnsupportedReason("Standard token exchange is not enabled for the requested client");
            return false;
        }
        String subjectToken = context.getParams().getSubjectToken();
        if (subjectToken == null) {
            context.setUnsupportedReason("Parameter 'subject_token' required for standard token exchange");
            return false;
        }
        String subjectTokenType = context.getParams().getSubjectTokenType();
        if (subjectTokenType == null) {
            context.setUnsupportedReason("Parameter 'subject_token_type' required for standard token exchange");
            return false;
        }
        if (!subjectTokenType.equals("urn:ietf:params:oauth:token-type:access_token")) {
            context.setUnsupportedReason("Parameter 'subject_token' supports access tokens only");
            return false;
        }
        return true;
    }

    @Override
    protected Response tokenExchange() {
        String subjectToken = this.context.getParams().getSubjectToken();
        this.event.detail("requested_token_type", this.context.getParams().getRequestedTokenType());
        AuthenticationManager.AuthResult authResult = AuthenticationManager.verifyIdentityToken(this.session, this.realm, (UriInfo)this.session.getContext().getUri(), this.clientConnection, true, true, null, false, subjectToken, this.context.getHeaders(), verifier -> {});
        if (authResult == null) {
            this.event.detail("reason", "subject_token validation failure");
            this.event.error("invalid_token");
            throw new CorsErrorResponseException(this.cors, "invalid_request", "Invalid token", Response.Status.BAD_REQUEST);
        }
        UserModel tokenUser = authResult.getUser();
        UserSessionModel tokenSession = authResult.getSession();
        AccessToken token = authResult.getToken();
        this.event.user(tokenUser);
        this.event.detail("username", tokenUser.getUsername());
        if (token.getSessionId() != null) {
            this.event.session(tokenSession);
        }
        this.event.detail("subject_token_client_id", token.getIssuedFor());
        return this.exchangeClientToClient(tokenUser, tokenSession, token, true);
    }

    @Override
    protected void validateAudience(AccessToken token, boolean disallowOnHolderOfTokenMismatch, List<ClientModel> targetAudienceClients) {
        ClientModel tokenHolder;
        ClientModel clientModel = tokenHolder = token == null ? null : this.realm.getClientByClientId(token.getIssuedFor());
        if (this.client.isPublicClient()) {
            String errorMessage = "Public client is not allowed to exchange token";
            this.event.detail("reason", errorMessage);
            this.event.error("invalid_client");
            throw new CorsErrorResponseException(this.cors, "invalid_client", errorMessage, Response.Status.BAD_REQUEST);
        }
        for (ClientModel targetClient : targetAudienceClients) {
            if (targetClient.isEnabled()) continue;
            this.event.detail("reason", "audience client disabled");
            this.event.detail("audience", targetClient.getClientId());
            this.event.error("client_disabled");
            throw new CorsErrorResponseException(this.cors, "invalid_client", "Client disabled", Response.Status.BAD_REQUEST);
        }
        if (!this.client.equals(tokenHolder)) {
            this.forbiddenIfClientIsNotWithinTokenAudience(token);
        }
    }

    protected void validateConsents(UserModel targetUser, ClientSessionContext clientSessionCtx) {
        if (!TokenManager.verifyConsentStillAvailable(this.session, targetUser, this.client, clientSessionCtx.getClientScopesStream())) {
            this.event.detail("reason", "Missing consents for Token Exchange in client " + this.client.getClientId());
            this.event.error("consent_denied");
            throw new CorsErrorResponseException(this.cors, "invalid_scope", "Missing consents for Token Exchange in client " + this.client.getClientId(), Response.Status.BAD_REQUEST);
        }
    }

    @Override
    protected String getRequestedScope(AccessToken token, List<ClientModel> targetAudienceClients) {
        boolean validScopes;
        String scope = (String)this.formParams.getFirst((Object)"scope");
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.DYNAMIC_SCOPES)) {
            AuthorizationRequestContext authorizationRequestContext = AuthorizationContextUtil.getAuthorizationRequestContextFromScopes(this.session, scope);
            validScopes = TokenManager.isValidScope(this.session, scope, authorizationRequestContext, this.client, null);
        } else {
            validScopes = TokenManager.isValidScope(this.session, scope, this.client, null);
        }
        if (!validScopes) {
            String errorMessage = "Invalid scopes: " + scope;
            this.event.detail("reason", errorMessage);
            this.event.error("invalid_request");
            throw new CorsErrorResponseException(this.cors, "invalid_scope", errorMessage, Response.Status.BAD_REQUEST);
        }
        return scope;
    }

    @Override
    protected Response exchangeClientToOIDCClient(UserModel targetUser, UserSessionModel targetUserSession, String requestedTokenType, List<ClientModel> targetAudienceClients, String scope, AccessToken subjectToken) {
        RootAuthenticationSessionModel rootAuthSession = new AuthenticationSessionManager(this.session).createAuthenticationSession(this.realm, false);
        AuthenticationSessionModel authSession = this.createSessionModel(targetUserSession, rootAuthSession, targetUser, this.client, scope);
        boolean isOfflineSession = targetUserSession.isOffline();
        if (targetUserSession.getPersistenceState() == UserSessionModel.SessionPersistenceState.TRANSIENT || isOfflineSession) {
            if ("urn:ietf:params:oauth:token-type:refresh_token".equals(requestedTokenType)) {
                this.event.detail("reason", "Refresh token not valid as requested_token_type because creating a new session is needed");
                this.event.error("invalid_request");
                throw new CorsErrorResponseException(this.cors, "invalid_request", "Refresh token not valid as requested_token_type because creating a new session is needed", Response.Status.BAD_REQUEST);
            }
            if (isOfflineSession) {
                targetUserSession = UserSessionUtil.createTransientUserSession(this.session, targetUserSession);
            }
        }
        boolean newClientSessionCreated = targetUserSession.getPersistenceState() != UserSessionModel.SessionPersistenceState.TRANSIENT && targetUserSession.getAuthenticatedClientSessionByClient(this.client.getId()) == null;
        try {
            AccessTokenResponse res;
            ClientSessionContext clientSessionCtx = TokenManager.attachAuthenticationSession(this.session, targetUserSession, authSession, !"urn:ietf:params:oauth:token-type:refresh_token".equals(requestedTokenType));
            if (requestedTokenType.equals("urn:ietf:params:oauth:token-type:refresh_token") && clientSessionCtx.getClientScopesStream().filter(s -> "offline_access".equals(s.getName())).findAny().isPresent()) {
                this.event.detail("reason", "Scope offline_access not allowed for token exchange");
                this.event.error("invalid_request");
                throw new CorsErrorResponseException(this.cors, "invalid_request", "Scope offline_access not allowed for token exchange", Response.Status.BAD_REQUEST);
            }
            this.updateUserSessionFromClientAuth(targetUserSession);
            if (this.params.getAudience() != null && !targetAudienceClients.isEmpty()) {
                clientSessionCtx.setAttribute("req-aud-clients", targetAudienceClients.toArray(ClientModel[]::new));
            }
            this.validateConsents(targetUser, clientSessionCtx);
            clientSessionCtx.setAttribute("grant_type", (Object)"urn:ietf:params:oauth:grant-type:token-exchange");
            TokenContextEncoderProvider encoder = (TokenContextEncoderProvider)this.session.getProvider(TokenContextEncoderProvider.class);
            if (subjectToken != null) {
                AuthenticatedClientSessionModel subjectClientSession;
                ClientModel subjectClient;
                AccessTokenContext subjectTokenContext = encoder.getTokenContextFromTokenId(subjectToken.getId());
                if ("urn:ietf:params:oauth:grant-type:token-exchange".equals(subjectTokenContext.getGrantType()) && (subjectClient = this.session.clients().getClientByClientId(this.realm, subjectToken.getIssuedFor())) != null && (subjectClientSession = targetUserSession.getAuthenticatedClientSessionByClient(subjectClient.getId())) != null) {
                    subjectClientSession.getNotes().entrySet().stream().filter(note -> ((String)note.getKey()).startsWith("token_exchange_subject_client")).forEach(note -> clientSessionCtx.getClientSession().setNote((String)note.getKey(), (String)note.getValue()));
                }
                clientSessionCtx.getClientSession().setNote("token_exchange_subject_client" + subjectToken.getIssuedFor(), subjectToken.getId());
            }
            TokenManager.AccessTokenResponseBuilder responseBuilder = this.tokenManager.responseBuilder(this.realm, this.client, this.event, this.session, clientSessionCtx.getClientSession().getUserSession(), clientSessionCtx).generateAccessToken();
            this.checkRequestedAudiences(responseBuilder);
            if (encoder.getTokenContextFromTokenId(responseBuilder.getAccessToken().getId()).getSessionType() == AccessTokenContext.SessionType.TRANSIENT) {
                responseBuilder.getAccessToken().setSessionId(null);
                this.event.session((String)null);
            }
            if ("urn:ietf:params:oauth:token-type:refresh_token".equals(requestedTokenType)) {
                responseBuilder.generateRefreshToken();
            }
            if ("urn:ietf:params:oauth:token-type:id_token".equals(requestedTokenType)) {
                res = responseBuilder.generateIDToken().build();
                res.setToken(res.getIdToken());
                res.setIdToken(null);
                res.setTokenType("N_A");
            } else {
                String scopeParam = this.params.getScope();
                if (TokenUtil.isOIDCRequest((String)scopeParam)) {
                    responseBuilder.generateIDToken().generateAccessTokenHash();
                }
                res = responseBuilder.build();
            }
            res.setOtherClaims("issued_token_type", (Object)requestedTokenType);
            if (responseBuilder.getAccessToken().getAudience() != null) {
                this.event.detail("audience", CollectionUtil.join(List.of(responseBuilder.getAccessToken().getAudience()), (String)" "));
            }
            this.event.success();
            return this.cors.add(Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE));
        }
        catch (RuntimeException e) {
            if (newClientSessionCreated) {
                targetUserSession.removeAuthenticatedClientSessions(Set.of(this.client.getId()));
            }
            throw e;
        }
    }

    @Override
    protected Response exchangeClientToSAML2Client(UserModel targetUser, UserSessionModel targetUserSession, String requestedTokenType, List<ClientModel> targetAudienceClients) {
        this.event.detail("reason", "requested_token_type unsupported");
        this.event.error("invalid_request");
        throw new CorsErrorResponseException(this.cors, "invalid_request", "requested_token_type unsupported", Response.Status.BAD_REQUEST);
    }

    protected void checkRequestedAudiences(TokenManager.AccessTokenResponseBuilder responseBuilder) {
        Set<String> missingAudience = TokenUtils.checkRequestedAudiences((JsonWebToken)responseBuilder.getAccessToken(), this.params.getAudience());
        if (!missingAudience.isEmpty()) {
            String missingAudienceString = CollectionUtil.join(missingAudience);
            this.event.detail("reason", "Requested audience not available: " + missingAudienceString);
            this.event.error("invalid_request");
            throw new CorsErrorResponseException(this.cors, "invalid_request", "Requested audience not available: " + missingAudienceString, Response.Status.BAD_REQUEST);
        }
    }

    @Override
    protected List<String> getSupportedOAuthResponseTokenTypes() {
        return Arrays.asList("urn:ietf:params:oauth:token-type:access_token", "urn:ietf:params:oauth:token-type:id_token", "urn:ietf:params:oauth:token-type:refresh_token");
    }

    @Override
    protected String getRequestedTokenType() {
        String requestedTokenType = this.params.getRequestedTokenType();
        if (requestedTokenType == null) {
            requestedTokenType = "urn:ietf:params:oauth:token-type:access_token";
            return requestedTokenType;
        }
        if (requestedTokenType.equals("urn:ietf:params:oauth:token-type:access_token") || requestedTokenType.equals("urn:ietf:params:oauth:token-type:id_token") || requestedTokenType.equals("urn:ietf:params:oauth:token-type:saml2")) {
            return requestedTokenType;
        }
        OIDCAdvancedConfigWrapper oidcClient = OIDCAdvancedConfigWrapper.fromClientModel(this.client);
        if (requestedTokenType.equals("urn:ietf:params:oauth:token-type:refresh_token") && oidcClient.isUseRefreshToken() && oidcClient.getStandardTokenExchangeRefreshEnabled() != OIDCAdvancedConfigWrapper.TokenExchangeRefreshTokenEnabled.NO) {
            return requestedTokenType;
        }
        this.event.detail("reason", "requested_token_type unsupported");
        this.event.error("invalid_request");
        throw new CorsErrorResponseException(this.cors, "invalid_request", "requested_token_type unsupported", Response.Status.BAD_REQUEST);
    }
}

