/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class DB2PositionFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    public DB2PositionFunction(TypeConfiguration typeConfiguration) {
        super("position", new ArgumentTypesValidator(StandardArgumentsValidators.between(2, 3), FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.ANY), StandardFunctionReturnTypeResolvers.invariant(typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER)), StandardFunctionArgumentTypeResolvers.invariant(typeConfiguration, FunctionParameterType.STRING, FunctionParameterType.STRING));
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        int argumentCount = arguments.size();
        sqlAppender.appendSql("position(");
        arguments.get(0).accept(walker);
        for (int i = 1; i < argumentCount; ++i) {
            sqlAppender.appendSql(',');
            arguments.get(i).accept(walker);
        }
        if (argumentCount != 3) {
            sqlAppender.appendSql(",codeunits32");
        }
        sqlAppender.appendSql(')');
    }

    @Override
    public String getSignature(String name) {
        return "(STRING pattern in STRING string[, units]])";
    }
}

