/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.Pbuffer;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.util.glu.GLU;
import org.lwjgl.util.vector.Vector2f;

public class PbufferTest {
    private DisplayMode mode;
    private Vector2f quadPosition;
    private Vector2f quadVelocity;
    private float angle;
    private float angleRotation = 1.0f;
    private static final float MAX_SPEED = 20.0f;
    private static Pbuffer pbuffer;
    private static int tex_handle;

    public void execute() {
        this.initialize();
        this.mainLoop();
        this.cleanup();
    }

    private void initialize() {
        try {
            pbuffer = new Pbuffer(512, 512, new PixelFormat(), null, null);
            this.mode = this.findDisplayMode(800, 600, 16);
            Display.setDisplayMode((DisplayMode)this.mode);
            Display.create();
            if ((Pbuffer.getCapabilities() & 1) == 0) {
                System.out.println("No Pbuffer support!");
                System.exit(1);
            }
            System.out.println("Pbuffer support detected");
            this.glInit();
            this.initPbuffer();
            Keyboard.create();
            this.quadPosition = new Vector2f(100.0f, 100.0f);
            this.quadVelocity = new Vector2f(1.0f, 1.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void mainLoop() {
        while (!Keyboard.isKeyDown((int)1) && !Display.isCloseRequested()) {
            if (Display.isVisible()) {
                this.processKeyboard();
                this.logic();
                this.render();
            } else {
                if (Display.isDirty()) {
                    this.render();
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Display.update();
        }
    }

    private void logic() {
        this.angle += this.angleRotation;
        if (this.angle > 90.0f) {
            this.angle = 0.0f;
        }
        this.quadPosition.x += this.quadVelocity.x;
        this.quadPosition.y += this.quadVelocity.y;
        if (this.quadPosition.x + 50.0f >= (float)this.mode.getWidth() || this.quadPosition.x - 50.0f <= 0.0f) {
            this.quadVelocity.x *= -1.0f;
        }
        if (this.quadPosition.y + 50.0f >= (float)this.mode.getHeight() || this.quadPosition.y - 50.0f <= 0.0f) {
            this.quadVelocity.y *= -1.0f;
        }
    }

    private void render() {
        if (pbuffer.isBufferLost()) {
            System.out.println("Buffer contents lost - will recreate the buffer");
            pbuffer.destroy();
            try {
                pbuffer = new Pbuffer(512, 512, new PixelFormat(), null, null);
                this.initPbuffer();
            }
            catch (LWJGLException e) {
                e.printStackTrace();
            }
        }
        try {
            pbuffer.makeCurrent();
        }
        catch (LWJGLException e) {
            throw new RuntimeException(e);
        }
        GL11.glClear((int)16384);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.quadPosition.x, (float)this.quadPosition.y, (float)0.0f);
        GL11.glRotatef((float)this.angle, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glVertex2i((int)-50, (int)-50);
        GL11.glVertex2i((int)50, (int)-50);
        GL11.glVertex2i((int)50, (int)50);
        GL11.glVertex2i((int)-50, (int)50);
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glCopyTexImage2D((int)3553, (int)0, (int)6407, (int)0, (int)0, (int)512, (int)512, (int)0);
        try {
            Display.makeCurrent();
        }
        catch (LWJGLException e) {
            throw new RuntimeException(e);
        }
        GL11.glClear((int)16384);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.quadPosition.x, (float)this.quadPosition.y, (float)0.0f);
        GL11.glRotatef((float)this.angle, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2i((int)-50, (int)-50);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2i((int)50, (int)-50);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2i((int)50, (int)50);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2i((int)-50, (int)50);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    private void initPbuffer() {
        try {
            pbuffer.makeCurrent();
            this.initGLState(256, 256, 0.5f);
            GL11.glBindTexture((int)3553, (int)tex_handle);
            Display.makeCurrent();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processKeyboard() {
        Keyboard.poll();
        if (Keyboard.isKeyDown((int)33)) {
            try {
                Display.setDisplayMode((DisplayMode)this.mode);
                Display.setFullscreen((boolean)true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Keyboard.isKeyDown((int)17)) {
            try {
                Display.setFullscreen((boolean)false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Keyboard.isKeyDown((int)200)) {
            this.quadVelocity.y += 0.1f;
        }
        if (Keyboard.isKeyDown((int)208)) {
            this.quadVelocity.y -= 0.1f;
        }
        if (Keyboard.isKeyDown((int)205)) {
            this.quadVelocity.x += 0.1f;
        }
        if (Keyboard.isKeyDown((int)203)) {
            this.quadVelocity.x -= 0.1f;
        }
        if (Keyboard.isKeyDown((int)78)) {
            this.angleRotation += 0.1f;
        }
        if (Keyboard.isKeyDown((int)74)) {
            this.angleRotation -= 0.1f;
        }
        if (this.quadVelocity.x < -20.0f) {
            this.quadVelocity.x = -20.0f;
        }
        if (this.quadVelocity.x > 20.0f) {
            this.quadVelocity.x = 20.0f;
        }
        if (this.quadVelocity.y < -20.0f) {
            this.quadVelocity.y = -20.0f;
        }
        if (this.quadVelocity.y > 20.0f) {
            this.quadVelocity.y = 20.0f;
        }
        if (this.angleRotation < 0.0f) {
            this.angleRotation = 0.0f;
        }
        if (this.angleRotation > 20.0f) {
            this.angleRotation = 20.0f;
        }
    }

    private void destroyTexture() {
        IntBuffer buffer = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asIntBuffer();
        buffer.put(0, tex_handle);
        GL11.glDeleteTextures((IntBuffer)buffer);
    }

    private void cleanup() {
        this.destroyTexture();
        pbuffer.destroy();
        Display.destroy();
    }

    private DisplayMode findDisplayMode(int width, int height, int bpp) throws LWJGLException {
        DisplayMode[] modes;
        for (DisplayMode mode : modes = Display.getAvailableDisplayModes()) {
            if (mode.getWidth() != width || mode.getHeight() != height || mode.getBitsPerPixel() < bpp) continue;
            return mode;
        }
        return null;
    }

    private void initGLState(int width, int height, float color) {
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GLU.gluOrtho2D((float)0.0f, (float)this.mode.getWidth(), (float)0.0f, (float)this.mode.getHeight());
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glViewport((int)0, (int)0, (int)width, (int)height);
        GL11.glClearColor((float)color, (float)color, (float)color, (float)0.0f);
    }

    private void glInit() {
        Display.setVSyncEnabled((boolean)true);
        GL11.glTexEnvf((int)8960, (int)8704, (float)7681.0f);
        GL11.glEnable((int)3553);
        IntBuffer buffer = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asIntBuffer();
        GL11.glGenTextures((IntBuffer)buffer);
        tex_handle = buffer.get(0);
        GL11.glBindTexture((int)3553, (int)tex_handle);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        this.initGLState(this.mode.getWidth(), this.mode.getHeight(), 0.0f);
    }

    public static void main(String[] args) {
        System.out.println("Change between fullscreen and windowed mode, by pressing F and W respectively");
        System.out.println("Move quad using arrowkeys, and change rotation using +/-");
        PbufferTest fswTest = new PbufferTest();
        fswTest.execute();
        System.exit(0);
    }
}

