/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.keystore.model;

import java.util.Map;

public class CreateKeyInput {
    private final String branchKeyIdentifier;
    private final Map<String, String> encryptionContext;

    protected CreateKeyInput(BuilderImpl builder) {
        this.branchKeyIdentifier = builder.branchKeyIdentifier();
        this.encryptionContext = builder.encryptionContext();
    }

    public String branchKeyIdentifier() {
        return this.branchKeyIdentifier;
    }

    public Map<String, String> encryptionContext() {
        return this.encryptionContext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String branchKeyIdentifier;
        protected Map<String, String> encryptionContext;

        protected BuilderImpl() {
        }

        protected BuilderImpl(CreateKeyInput model) {
            this.branchKeyIdentifier = model.branchKeyIdentifier();
            this.encryptionContext = model.encryptionContext();
        }

        @Override
        public Builder branchKeyIdentifier(String branchKeyIdentifier) {
            this.branchKeyIdentifier = branchKeyIdentifier;
            return this;
        }

        @Override
        public String branchKeyIdentifier() {
            return this.branchKeyIdentifier;
        }

        @Override
        public Builder encryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = encryptionContext;
            return this;
        }

        @Override
        public Map<String, String> encryptionContext() {
            return this.encryptionContext;
        }

        @Override
        public CreateKeyInput build() {
            return new CreateKeyInput(this);
        }
    }

    public static interface Builder {
        public Builder branchKeyIdentifier(String var1);

        public String branchKeyIdentifier();

        public Builder encryptionContext(Map<String, String> var1);

        public Map<String, String> encryptionContext();

        public CreateKeyInput build();
    }
}

