/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class StoreStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, StoreStats> {
    @Nullable
    private final String reserved;
    private final long reservedInBytes;
    @Nullable
    private final String size;
    private final long sizeInBytes;
    public static final JsonpDeserializer<StoreStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StoreStats::setupStoreStatsDeserializer);

    private StoreStats(Builder builder) {
        this.reserved = builder.reserved;
        this.reservedInBytes = ApiTypeHelper.requireNonNull(builder.reservedInBytes, this, "reservedInBytes");
        this.size = builder.size;
        this.sizeInBytes = ApiTypeHelper.requireNonNull(builder.sizeInBytes, this, "sizeInBytes");
    }

    public static StoreStats of(Function<Builder, ObjectBuilder<StoreStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String reserved() {
        return this.reserved;
    }

    public final long reservedInBytes() {
        return this.reservedInBytes;
    }

    @Nullable
    public final String size() {
        return this.size;
    }

    public final long sizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.reserved != null) {
            generator.writeKey("reserved");
            generator.write(this.reserved);
        }
        generator.writeKey("reserved_in_bytes");
        generator.write(this.reservedInBytes);
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size);
        }
        generator.writeKey("size_in_bytes");
        generator.write(this.sizeInBytes);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupStoreStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::reserved, JsonpDeserializer.stringDeserializer(), "reserved");
        op.add(Builder::reservedInBytes, JsonpDeserializer.longDeserializer(), "reserved_in_bytes");
        op.add(Builder::size, JsonpDeserializer.stringDeserializer(), "size");
        op.add(Builder::sizeInBytes, JsonpDeserializer.longDeserializer(), "size_in_bytes");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.reserved);
        result = 31 * result + Long.hashCode(this.reservedInBytes);
        result = 31 * result + Objects.hashCode(this.size);
        result = 31 * result + Long.hashCode(this.sizeInBytes);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreStats other = (StoreStats)o;
        return Objects.equals(this.reserved, other.reserved) && this.reservedInBytes == other.reservedInBytes && Objects.equals(this.size, other.size) && this.sizeInBytes == other.sizeInBytes;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, StoreStats> {
        @Nullable
        private String reserved;
        private Long reservedInBytes;
        @Nullable
        private String size;
        private Long sizeInBytes;

        public Builder() {
        }

        private Builder(StoreStats o) {
            this.reserved = o.reserved;
            this.reservedInBytes = o.reservedInBytes;
            this.size = o.size;
            this.sizeInBytes = o.sizeInBytes;
        }

        private Builder(Builder o) {
            this.reserved = o.reserved;
            this.reservedInBytes = o.reservedInBytes;
            this.size = o.size;
            this.sizeInBytes = o.sizeInBytes;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder reserved(@Nullable String value) {
            this.reserved = value;
            return this;
        }

        @Nonnull
        public final Builder reservedInBytes(long value) {
            this.reservedInBytes = value;
            return this;
        }

        @Nonnull
        public final Builder size(@Nullable String value) {
            this.size = value;
            return this;
        }

        @Nonnull
        public final Builder sizeInBytes(long value) {
            this.sizeInBytes = value;
            return this;
        }

        @Override
        @Nonnull
        public StoreStats build() {
            this._checkSingleUse();
            return new StoreStats(this);
        }
    }
}

