/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.weighted_routing;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilderBase;

public abstract class WeightsBase
implements PlainJsonSerializable {
    @Nullable
    private final Long version;
    @Nonnull
    private final Map<String, String> weights;

    protected WeightsBase(AbstractBuilder<?> builder) {
        this.version = ((AbstractBuilder)builder).version;
        this.weights = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).weights);
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Nonnull
    public final Map<String, String> weights() {
        return this.weights;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.version != null) {
            generator.writeKey("_version");
            generator.write(this.version.longValue());
        }
        if (ApiTypeHelper.isDefined(this.weights)) {
            generator.writeKey("weights");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.weights.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupWeightsBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::version, JsonpDeserializer.longDeserializer(), "_version");
        op.add(AbstractBuilder::weights, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "weights");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.version);
        result = 31 * result + Objects.hashCode(this.weights);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeightsBase other = (WeightsBase)o;
        return Objects.equals(this.version, other.version) && Objects.equals(this.weights, other.weights);
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends ObjectBuilderBase {
        @Nullable
        private Long version;
        @Nullable
        private Map<String, String> weights;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(WeightsBase o) {
            this.version = o.version;
            this.weights = AbstractBuilder._mapCopy(o.weights);
        }

        protected AbstractBuilder(AbstractBuilder<BuilderT> o) {
            this.version = o.version;
            this.weights = AbstractBuilder._mapCopy(o.weights);
        }

        @Nonnull
        protected abstract BuilderT self();

        @Nonnull
        public final BuilderT version(@Nullable Long value) {
            this.version = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT weights(Map<String, String> map) {
            this.weights = AbstractBuilder._mapPutAll(this.weights, map);
            return this.self();
        }

        @Nonnull
        public final BuilderT weights(String key, String value) {
            this.weights = AbstractBuilder._mapPut(this.weights, key, value);
            return this.self();
        }
    }
}

