/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.client;

import java.util.function.Function;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.ad.client.AnomalyDetectionClient;
import org.opensearch.ad.transport.GetAnomalyDetectorAction;
import org.opensearch.ad.transport.GetAnomalyDetectorResponse;
import org.opensearch.ad.transport.SearchAnomalyDetectorAction;
import org.opensearch.ad.transport.SearchAnomalyResultAction;
import org.opensearch.ad.transport.SuggestAnomalyDetectorParamAction;
import org.opensearch.ad.transport.ValidateAnomalyDetectorAction;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.timeseries.transport.GetConfigRequest;
import org.opensearch.timeseries.transport.SuggestConfigParamRequest;
import org.opensearch.timeseries.transport.SuggestConfigParamResponse;
import org.opensearch.timeseries.transport.ValidateConfigRequest;
import org.opensearch.timeseries.transport.ValidateConfigResponse;
import org.opensearch.transport.client.Client;

public class AnomalyDetectionNodeClient
implements AnomalyDetectionClient {
    private final Client client;
    private final NamedWriteableRegistry namedWriteableRegistry;

    public AnomalyDetectionNodeClient(Client client, NamedWriteableRegistry namedWriteableRegistry) {
        this.client = client;
        this.namedWriteableRegistry = namedWriteableRegistry;
    }

    @Override
    public void searchAnomalyDetectors(SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        this.client.execute((ActionType)SearchAnomalyDetectorAction.INSTANCE, (ActionRequest)searchRequest, ActionListener.wrap(searchResponse -> listener.onResponse(searchResponse), arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public void searchAnomalyResults(SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        this.client.execute((ActionType)SearchAnomalyResultAction.INSTANCE, (ActionRequest)searchRequest, ActionListener.wrap(searchResponse -> listener.onResponse(searchResponse), arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public void getDetectorProfile(GetConfigRequest profileRequest, ActionListener<GetAnomalyDetectorResponse> listener) {
        this.client.execute((ActionType)GetAnomalyDetectorAction.INSTANCE, (ActionRequest)profileRequest, this.getAnomalyDetectorResponseActionListener(listener));
    }

    @Override
    public void validateAnomalyDetector(ValidateConfigRequest validateRequest, ActionListener<ValidateConfigResponse> listener) {
        this.client.execute((ActionType)ValidateAnomalyDetectorAction.INSTANCE, (ActionRequest)validateRequest, this.validateConfigResponseActionListener(listener));
    }

    @Override
    public void suggestAnomalyDetector(SuggestConfigParamRequest suggestRequest, ActionListener<SuggestConfigParamResponse> listener) {
        this.client.execute((ActionType)SuggestAnomalyDetectorParamAction.INSTANCE, (ActionRequest)suggestRequest, this.suggestConfigResponseActionListener(listener));
    }

    private ActionListener<GetAnomalyDetectorResponse> getAnomalyDetectorResponseActionListener(ActionListener<GetAnomalyDetectorResponse> listener) {
        ActionListener internalListener = ActionListener.wrap(getAnomalyDetectorResponse -> listener.onResponse((Object)getAnomalyDetectorResponse), arg_0 -> listener.onFailure(arg_0));
        ActionListener<GetAnomalyDetectorResponse> actionListener = this.wrapActionListener(internalListener, actionResponse -> {
            GetAnomalyDetectorResponse response = GetAnomalyDetectorResponse.fromActionResponse(actionResponse, this.namedWriteableRegistry);
            return response;
        });
        return actionListener;
    }

    private ActionListener<ValidateConfigResponse> validateConfigResponseActionListener(ActionListener<ValidateConfigResponse> listener) {
        ActionListener internalListener = ActionListener.wrap(validateConfigResponse -> listener.onResponse((Object)validateConfigResponse), arg_0 -> listener.onFailure(arg_0));
        ActionListener<ValidateConfigResponse> actionListener = this.wrapActionListener(internalListener, actionResponse -> {
            ValidateConfigResponse response = ValidateConfigResponse.fromActionResponse(actionResponse, this.namedWriteableRegistry);
            return response;
        });
        return actionListener;
    }

    private ActionListener<SuggestConfigParamResponse> suggestConfigResponseActionListener(ActionListener<SuggestConfigParamResponse> listener) {
        ActionListener internalListener = ActionListener.wrap(suggestConfigResponse -> listener.onResponse(suggestConfigResponse), arg_0 -> listener.onFailure(arg_0));
        ActionListener<SuggestConfigParamResponse> actionListener = this.wrapActionListener(internalListener, actionResponse -> {
            SuggestConfigParamResponse response = SuggestConfigParamResponse.fromActionResponse(actionResponse, this.namedWriteableRegistry);
            return response;
        });
        return actionListener;
    }

    private <T extends ActionResponse> ActionListener<T> wrapActionListener(ActionListener<T> listener, Function<ActionResponse, T> recreate) {
        ActionListener actionListener = ActionListener.wrap(r -> listener.onResponse((Object)((ActionResponse)recreate.apply((ActionResponse)r))), e -> listener.onFailure(e));
        return actionListener;
    }
}

