/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.rules.action.live_queries;

import java.io.IOException;
import org.opensearch.Version;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.plugin.insights.rules.model.MetricType;

public class LiveQueriesRequest
extends ActionRequest {
    private final boolean verbose;
    private final MetricType sortBy;
    private final int size;
    private final String[] nodeIds;
    private String wlmGroupId;

    public LiveQueriesRequest(StreamInput in) throws IOException {
        super(in);
        this.verbose = in.readBoolean();
        this.sortBy = MetricType.readFromStream(in);
        this.size = in.readInt();
        this.nodeIds = in.readStringArray();
        if (in.getVersion().onOrAfter(Version.V_3_3_0)) {
            this.wlmGroupId = in.readOptionalString();
        }
    }

    public LiveQueriesRequest(boolean verbose, MetricType sortBy, int size, String[] nodeIds, String wlmGroupId) {
        this.verbose = verbose;
        this.sortBy = sortBy;
        this.size = size;
        this.nodeIds = nodeIds;
        this.wlmGroupId = wlmGroupId;
    }

    public LiveQueriesRequest(boolean verbose, String ... nodeIds) {
        this(verbose, MetricType.LATENCY, 100, nodeIds, null);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public MetricType getSortBy() {
        return this.sortBy;
    }

    public int getSize() {
        return this.size;
    }

    public String[] nodesIds() {
        return this.nodeIds;
    }

    public String getWlmGroupId() {
        return this.wlmGroupId;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.verbose);
        MetricType.writeTo(out, this.sortBy);
        out.writeInt(this.size);
        out.writeStringArray(this.nodeIds);
        if (out.getVersion().onOrAfter(Version.V_3_3_0)) {
            out.writeOptionalString(this.wlmGroupId);
        }
    }

    public ActionRequestValidationException validate() {
        return null;
    }
}

