/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.tools.cli.fips.truststore;

import java.io.PrintWriter;
import java.security.Security;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import picocli.CommandLine;

public class SecurityConfigurationPrinter {
    public static void printCurrentConfiguration(CommandLine.Model.CommandSpec spec) {
        PrintWriter out = spec.commandLine().getOut();
        AtomicInteger counter = new AtomicInteger();
        out.println("Available Security Providers:");
        Arrays.stream(Security.getProviders()).peek(provider -> out.printf(Locale.ROOT, "  %d. %s (version %s)\n", counter.incrementAndGet(), provider.getName(), provider.getVersionStr())).flatMap(provider -> provider.getServices().stream().filter(service -> "KeyStore".equals(service.getType()))).forEach(service -> out.printf(Locale.ROOT, "     \u2514\u2500 KeyStore.%s\n", service.getAlgorithm()));
    }
}

