/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.anomaly.libsvm;

import java.util.Collections;
import java.util.List;
import libsvm.svm;
import libsvm.svm_model;
import libsvm.svm_node;
import org.tribuo.Example;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.Output;
import org.tribuo.Prediction;
import org.tribuo.anomaly.Event;
import org.tribuo.common.libsvm.LibSVMModel;
import org.tribuo.common.libsvm.LibSVMTrainer;
import org.tribuo.provenance.ModelProvenance;

public class LibSVMAnomalyModel
extends LibSVMModel<Event> {
    private static final long serialVersionUID = 1L;

    LibSVMAnomalyModel(String name, ModelProvenance description, ImmutableFeatureMap featureIDMap, ImmutableOutputInfo<Event> labelIDMap, List<svm_model> models) {
        super(name, description, featureIDMap, labelIDMap, models.get((int)0).param.probability == 1, models);
    }

    public int getNumberOfSupportVectors() {
        return ((svm_model)this.models.get((int)0)).SV.length;
    }

    public Prediction<Event> predict(Example<Event> example) {
        svm_node[] features = LibSVMTrainer.exampleToNodes(example, (ImmutableFeatureMap)this.featureIDMap, null);
        if (features.length == 0) {
            throw new IllegalArgumentException("No features found in Example " + example.toString());
        }
        double[] score = new double[1];
        double prediction = svm.svm_predict_values((svm_model)((svm_model)this.models.get(0)), (svm_node[])features, (double[])score);
        if (prediction < 0.0) {
            return new Prediction((Output)new Event(Event.EventType.ANOMALOUS, score[0]), features.length, example);
        }
        return new Prediction((Output)new Event(Event.EventType.EXPECTED, score[0]), features.length, example);
    }

    protected LibSVMAnomalyModel copy(String newName, ModelProvenance newProvenance) {
        return new LibSVMAnomalyModel(newName, newProvenance, this.featureIDMap, (ImmutableOutputInfo<Event>)this.outputIDInfo, Collections.singletonList(LibSVMModel.copyModel((svm_model)((svm_model)this.models.get(0)))));
    }
}

