/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.datetime;

import java.util.List;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.opensearch.sql.calcite.utils.PPLOperandTypes;
import org.opensearch.sql.calcite.utils.PPLReturnTypes;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.datetime.DateTimeFunctions;
import org.opensearch.sql.expression.function.FunctionProperties;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class YearweekFunction
extends ImplementorUDF {
    public YearweekFunction() {
        super(new YearweekImplementor(), NullPolicy.ANY);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return PPLReturnTypes.INTEGER_FORCE_NULLABLE;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return PPLOperandTypes.DATETIME_OPTIONAL_INTEGER;
    }

    public static int yearweek(FunctionProperties properties, ExprValue date) {
        return YearweekFunction.yearweek(properties, date, ExprValueUtils.integerValue(0));
    }

    public static int yearweek(FunctionProperties properties, ExprValue date, ExprValue mode) {
        if (date.type() == ExprCoreType.TIME) {
            return DateTimeFunctions.yearweekToday(mode, properties.getQueryStartClock()).integerValue();
        }
        ExprValue yearWeekValue = DateTimeFunctions.exprYearweek(date, mode);
        return yearWeekValue.integerValue();
    }

    public static class YearweekImplementor
    implements NotNullImplementor {
        public Expression implement(RexToLixTranslator rexToLixTranslator, RexCall rexCall, List<Expression> list) {
            List<Expression> operands = UserDefinedFunctionUtils.convertToExprValues(list, rexCall);
            List<Expression> operandsWithProperties = UserDefinedFunctionUtils.prependFunctionProperties(operands, rexToLixTranslator);
            return Expressions.call(YearweekFunction.class, (String)"yearweek", operandsWithProperties);
        }
    }
}

