"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RangeField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("../../hook_form_lib");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); } /*
                                                                                                                                                                                                                                                                                      * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                      *
                                                                                                                                                                                                                                                                                      * The OpenSearch Contributors require contributions made to
                                                                                                                                                                                                                                                                                      * this file be licensed under the Apache-2.0 license or a
                                                                                                                                                                                                                                                                                      * compatible open source license.
                                                                                                                                                                                                                                                                                      *
                                                                                                                                                                                                                                                                                      * Any modifications Copyright OpenSearch Contributors. See
                                                                                                                                                                                                                                                                                      * GitHub history for details.
                                                                                                                                                                                                                                                                                      */ /*
                                                                                                                                                                                                                                                                                          * Licensed to Elasticsearch B.V. under one or more contributor
                                                                                                                                                                                                                                                                                          * license agreements. See the NOTICE file distributed with
                                                                                                                                                                                                                                                                                          * this work for additional information regarding copyright
                                                                                                                                                                                                                                                                                          * ownership. Elasticsearch B.V. licenses this file to you under
                                                                                                                                                                                                                                                                                          * the Apache License, Version 2.0 (the "License"); you may
                                                                                                                                                                                                                                                                                          * not use this file except in compliance with the License.
                                                                                                                                                                                                                                                                                          * You may obtain a copy of the License at
                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                          *    http://www.apache.org/licenses/LICENSE-2.0
                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                          * Unless required by applicable law or agreed to in writing,
                                                                                                                                                                                                                                                                                          * software distributed under the License is distributed on an
                                                                                                                                                                                                                                                                                          * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
                                                                                                                                                                                                                                                                                          * KIND, either express or implied.  See the License for the
                                                                                                                                                                                                                                                                                          * specific language governing permissions and limitations
                                                                                                                                                                                                                                                                                          * under the License.
                                                                                                                                                                                                                                                                                          */
const RangeField = ({
  field,
  euiFieldProps = {},
  ...rest
}) => {
  const {
    isInvalid,
    errorMessage
  } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
  const {
    onChange: onFieldChange
  } = field;
  const onChange = (0, _react.useCallback)(e => {
    const event = {
      ...e,
      value: `${e.currentTarget.value}`
    };
    onFieldChange(event);
  }, [onFieldChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCompressedFormRow, {
    label: field.label,
    helpText: typeof field.helpText === 'function' ? field.helpText() : field.helpText,
    error: errorMessage,
    isInvalid: isInvalid,
    fullWidth: true,
    "data-test-subj": rest['data-test-subj'],
    describedByIds: rest.idAria ? [rest.idAria] : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRange, _extends({
    value: field.value,
    onChange: onChange,
    max: 10,
    min: 0,
    showRange: true,
    showInput: true,
    fullWidth: true,
    "data-test-subj": "range"
  }, euiFieldProps)));
};
exports.RangeField = RangeField;