/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.pkg;

import java.lang.invoke.MethodHandles;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.apache.solr.common.MapWriter;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.pkg.PackageAPI;
import org.apache.solr.pkg.SolrPackageLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageListeners {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PACKAGE_VERSIONS = "PKG_VERSIONS";
    private final SolrCore core;
    private final List<Reference<Listener>> listeners = new CopyOnWriteArrayList<Reference<Listener>>();

    public PackageListeners(SolrCore core) {
        this.core = core;
    }

    public synchronized void addListener(Listener listener) {
        this.listeners.add(new SoftReference<Listener>(listener));
    }

    public synchronized void addListener(Listener listener, boolean addFirst) {
        if (addFirst) {
            this.listeners.add(0, new SoftReference<Listener>(listener));
        } else {
            this.addListener(listener);
        }
    }

    public synchronized void removeListener(Listener listener) {
        Iterator<Reference<Listener>> it = this.listeners.iterator();
        while (it.hasNext()) {
            Reference<Listener> ref = it.next();
            Listener pkgListener = ref.get();
            if (pkgListener != null && pkgListener != listener) continue;
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void packagesUpdated(List<SolrPackageLoader.SolrPackage> pkgs) {
        MDCLoggingContext.setCore(this.core);
        Listener.Ctx ctx = new Listener.Ctx();
        try {
            for (SolrPackageLoader.SolrPackage pkgInfo : pkgs) {
                this.invokeListeners(pkgInfo, ctx);
            }
        }
        finally {
            ctx.runLaterTasks(r -> this.core.getCoreContainer().runAsync((Runnable)r));
            MDCLoggingContext.clear();
        }
    }

    private synchronized void invokeListeners(SolrPackageLoader.SolrPackage pkg, Listener.Ctx ctx) {
        for (Reference<Listener> ref : this.listeners) {
            Listener listener = ref.get();
            if (listener == null || listener.packageName() != null && !listener.packageName().equals(pkg.name())) continue;
            listener.changed(pkg, ctx);
        }
    }

    public List<Listener> getListeners() {
        ArrayList<Listener> result = new ArrayList<Listener>();
        for (Reference<Listener> ref : this.listeners) {
            Listener l = ref.get();
            if (l == null) continue;
            result.add(l);
        }
        return result;
    }

    public static interface Listener {
        public String packageName();

        public Map<String, PackageAPI.PkgVersion> packageDetails();

        public void changed(SolrPackageLoader.SolrPackage var1, Ctx var2);

        default public MapWriter getPackageVersion(PluginInfo.ClassName cName) {
            return null;
        }

        public static class Ctx {
            private Map<String, Runnable> runLater;

            public void runLater(String name, Runnable runnable) {
                if (this.runLater == null) {
                    this.runLater = new LinkedHashMap<String, Runnable>();
                }
                if (name == null) {
                    name = runnable.getClass().getSimpleName() + "@" + runnable.hashCode();
                }
                this.runLater.put((String)name, runnable);
            }

            private void runLaterTasks(Consumer<Runnable> runnableExecutor) {
                if (this.runLater == null) {
                    return;
                }
                for (Runnable r : this.runLater.values()) {
                    runnableExecutor.accept(r);
                }
            }
        }
    }
}

