/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java;

import javax.swing.Icon;
import org.graalvm.visualvm.heapviewer.java.Bundle;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.java.InstanceNodeRenderer;
import org.graalvm.visualvm.heapviewer.java.InstanceReferenceNode;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerRenderer;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.MultiRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.NormalBoldGrayRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;

public class InstanceReferenceNodeRenderer
extends MultiRenderer
implements HeapViewerRenderer {
    protected static final Icon ICON_PRIMITIVE = Icons.getIcon((String)"LanguageIcons.Primitive");
    protected static final Icon ICON_INSTANCE = Icons.getIcon((String)"LanguageIcons.Instance");
    protected static final Icon ICON_ARRAY = Icons.getIcon((String)"LanguageIcons.Array");
    protected final NormalBoldGrayRenderer nameRenderer;
    protected final LabelRenderer equalsRenderer;
    private final LabelRenderer loopToRenderer;
    private final InstanceNodeRenderer instanceRenderer;
    private final ProfilerRenderer[] renderers;
    protected final Heap heap;

    public InstanceReferenceNodeRenderer(Heap heap) {
        this.heap = heap;
        this.nameRenderer = new NormalBoldGrayRenderer(){

            public void setValue(Object value, int row) {
                InstanceReferenceNode node = (InstanceReferenceNode)((Object)value);
                String name = node.getFieldName();
                if (name.startsWith("static ")) {
                    this.setNormalValue("static ");
                    this.setBoldValue(name.substring("static ".length()));
                } else {
                    this.setNormalValue("");
                    this.setBoldValue(name);
                }
                this.setIcon(Icons.getIcon((String)(InstanceNode.Mode.INCOMING_REFERENCE.equals((Object)node.getMode()) ? "ProfilerIcons.NodeReverse" : "ProfilerIcons.NodeForward")));
            }
        };
        this.equalsRenderer = new LabelRenderer(){

            public void setValue(Object value, int row) {
                InstanceReferenceNode node = (InstanceReferenceNode)((Object)value);
                if (InstanceNode.Mode.INCOMING_REFERENCE.equals((Object)node.getMode())) {
                    this.setText("in");
                    this.setMargin(3, 2, 3, 0);
                } else {
                    this.setText("=");
                    this.setMargin(3, 0, 3, 0);
                }
            }

            public String toString() {
                return " " + this.getText() + " ";
            }
        };
        this.loopToRenderer = new LabelRenderer(){

            public void setValue(Object value, int row) {
                this.setVisible(value != null);
            }

            public String toString() {
                return this.getText() + " ";
            }
        };
        this.loopToRenderer.setText(Bundle.InstanceReferenceNodeRenderer_LoopTo());
        this.instanceRenderer = new InstanceNodeRenderer(heap);
        this.renderers = new ProfilerRenderer[]{this.nameRenderer, this.equalsRenderer, this.loopToRenderer, this.instanceRenderer};
    }

    @Override
    public Icon getIcon() {
        return this.nameRenderer.getIcon();
    }

    @Override
    public String getShortName() {
        return this.nameRenderer.toString();
    }

    protected ProfilerRenderer[] valueRenderers() {
        return this.renderers;
    }

    public void setValue(Object value, int row) {
        HeapViewerNode node = (HeapViewerNode)((Object)value);
        HeapViewerNode loop = HeapViewerNode.getValue(node, DataType.LOOP, this.heap);
        if (loop != null) {
            node = loop;
        }
        this.nameRenderer.setValue((Object)node, row);
        this.equalsRenderer.setValue((Object)node, row);
        this.loopToRenderer.setValue((Object)loop, row);
        this.instanceRenderer.setValue((Object)node, row);
        if (this.loopToRenderer.isVisible()) {
            this.instanceRenderer.flagLoopTo();
        }
    }
}

