﻿/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef WIDGET_H
#define WIDGET_H

#include <QWidget>
#include <QApplication>
#include <QTranslator>
#include <QDesktopWidget>
#include <QPainter>
#include <QPainterPath>
#include <QStyleOption>
#include <QLabel>
#include <QVBoxLayout>
#include <QPushButton>
#include <QDebug>
#include <QDialog>

class MessageBoxPowerIntel : public QDialog
{
    Q_OBJECT

public:
    explicit MessageBoxPowerIntel(QWidget *parent = nullptr);
    ~MessageBoxPowerIntel();
    QHBoxLayout  *m_pfirstlayout    = nullptr;
    QVBoxLayout  *m_pmainlayout     = nullptr;
    QVBoxLayout  *m_ptestlayout     = nullptr;
    QHBoxLayout  *buttonlayout      = nullptr;
    QHBoxLayout  *m_pcenterlayout     = nullptr;

    QWidget *topWidget;
    QWidget *contentWidget;
    QWidget *buttonWidget;
    QWidget *leftIconWidget;
    QWidget *centerWidget;


    QPushButton *closeButton;



    QLabel *firstlabel;

    QPushButton *remindButton;
    QPushButton *confirmButton;

    QLabel *iconBigLabel;

    QTimer *timer;

    void initUI();
    void paintEvent(QPaintEvent *e);

public Q_SLOTS:
    void otaevent();
    void timetask();

protected slots:
    void remindslots();
    void restartslots();
};
#endif // WIDGET_H
