/*! For license information please see audubon.bundle.js.LICENSE.txt */
!function(){"use strict";var t={86:function(t){t.exports=function(t){t.katakanaRegex=new RegExp("([\\u30a1-\\u30f4\\u30f7-\\u30fa\\u30fd-\\u30ff\\u31f0-\\u31ff]|\\ud869\\udf08\\u3099|\\ud869\\udf08|\\ud82c\\udc00)","g"),t.hiraganaRegex=new RegExp("([\\u3041-\\u3094\\u309d-\\u309f]|\\ud82c\\udc01)","g"),t.specialHiraganizationTable={"ヿ":"こと","𪜈":"とも","𪜈゙":"ども","ヷ":"わ゙","ヸ":"ゐ゙","ヹ":"ゑ゙","ヺ":"を゙","𛀀":"え","ㇰ":"く","ㇱ":"し","ㇲ":"す","ㇳ":"と","ㇴ":"ぬ","ㇵ":"は","ㇶ":"ひ","ㇷ":"ふ","ㇸ":"へ","ㇹ":"ほ","ㇺ":"む","ㇻ":"ら","ㇼ":"り","ㇽ":"る","ㇾ":"れ","ㇿ":"ろ"},t.specialKatakanizationTable={"ゟ":"ヨリ","𛀁":"エ"};var i=String.fromCharCode,e=function(t){return t.charCodeAt(0)};t.hiraganize=function(n){return n.replace(t.katakanaRegex,function(n){return n.match(/^[\u30a1-\u30f4\u30fd\u30fe]$/)?i(e(n)-e("ァ")+e("ぁ")):t.specialHiraganizationTable[n]?t.specialHiraganizationTable[n]:void 0})},t.katakanize=function(n){return n.replace(t.hiraganaRegex,function(n){return n.match(/^[\u3041-\u3094\u309d\u309e]$/)?i(e(n)-e("ぁ")+e("ァ")):t.specialKatakanizationTable[n]?t.specialKatakanizationTable[n]:void 0})}}},126:function(t,i,e){var n={};e(86)(n),e(946)(n),e(941)(n),t.exports=n},889:function(t){function i(t){return i="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},i(t)}var e=Object.prototype.hasOwnProperty,n=Object.prototype.toString,o=Object.defineProperty,r=Object.getOwnPropertyDescriptor,s=function(t){return"function"==typeof Array.isArray?Array.isArray(t):"[object Array]"===n.call(t)},a=function(t){if(!t||"[object Object]"!==n.call(t))return!1;var i,o=e.call(t,"constructor"),r=t.constructor&&t.constructor.prototype&&e.call(t.constructor.prototype,"isPrototypeOf");if(t.constructor&&!o&&!r)return!1;for(i in t);return void 0===i||e.call(t,i)},u=function(t,i){o&&"__proto__"===i.name?o(t,i.name,{enumerable:!0,configurable:!0,value:i.newValue,writable:!0}):t[i.name]=i.newValue},l=function(t,i){if("__proto__"===i){if(!e.call(t,i))return;if(r)return r(t,i).value}return t[i]};t.exports=function t(){var e,n,o,r,c,h,f=arguments[0],_=1,y=arguments.length,H=!1;for("boolean"==typeof f&&(H=f,f=arguments[1]||{},_=2),(null==f||"object"!==i(f)&&"function"!=typeof f)&&(f={});_<y;++_)if(null!=(e=arguments[_]))for(n in e)o=l(f,n),f!==(r=l(e,n))&&(H&&r&&(a(r)||(c=s(r)))?(c?(c=!1,h=o&&s(o)?o:[]):h=o&&a(o)?o:{},u(f,{name:n,newValue:t(H,h,r)})):void 0!==r&&u(f,{name:n,newValue:r}));return f}},941:function(t,i,e){function n(t){return n="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},n(t)}var o=e(889);t.exports=function(t){return t.transcriptionConfigs={default:{minusSign:"マイナス",decimalPoint:"・",digits:"common",unitNames:"jinkoki3",specialUnitNames:"none",truncateOne:["十","百","千","拾","佰","阡","仟"],smallUnitNames:"none"},formal:{digits:"formal",unitNames:"formal",specialUnitNames:"common",smallUnitNames:"common"},traditional:{digits:"traditional",specialUnitNames:"full",smallUnitNames:"full"}},t.predefineedTranscriptionConfigs={digits:{arabic:{0:"0",1:"1",2:"2",3:"3",4:"4",5:"5",6:"6",7:"7",8:"8",9:"9"},common:{0:"〇",1:"一",2:"二",3:"三",4:"四",5:"五",6:"六",7:"七",8:"八",9:"九"},formal:{0:"〇",1:"壱",2:"弐",3:"参",4:"四",5:"五",6:"六",7:"七",8:"八",9:"九"},traditional:{0:"零",1:"壱",2:"弐",3:"参",4:"肆",5:"伍",6:"陸",7:"柒",8:"捌",9:"玖"},traditionalOld:{0:"零",1:"壹",2:"貳",3:"參",4:"肆",5:"伍",6:"陸",7:"柒",8:"捌",9:"玖"},simplified:{0:"零",1:"壹",2:"贰",3:"叁",4:"肆",5:"伍",6:"陆",7:"柒",8:"捌",9:"玖"},chineseMilitary:{0:"洞",1:"幺",2:"两",3:"三",4:"刀",5:"五",6:"六",7:"拐",8:"八",9:"勾"},vietnam:{0:"〇",1:"𠬠",2:"𠄩",3:"𠀧",4:"𦊚",5:"𠄼",6:"𦒹",7:"𦉱",8:"𠔭",9:"𠃩"}},unitNames:{jinkoki1:{1:"十",2:"百",3:"千",4:"万",5:"億",6:"兆",7:"京",8:"垓",9:"𥝱",10:"穣",11:"溝",12:"澗",13:"正",14:"載",15:"極",23:"恒河沙",31:"阿僧祇",39:"那由他",47:"不可思議",55:"無量大数",lit:63},jinkoki2:{1:"十",2:"百",3:"千",4:"万",8:"億",12:"兆",16:"京",20:"垓",24:"𥝱",28:"穣",32:"溝",36:"澗",40:"正",44:"載",48:"極",56:"恒河沙",64:"阿僧祇",72:"那由他",80:"不可思議",88:"無量大数",lit:96},jinkoki3:{1:"十",2:"百",3:"千",4:"万",8:"億",12:"兆",16:"京",20:"垓",24:"𥝱",28:"穣",32:"溝",36:"澗",40:"正",44:"載",48:"極",52:"恒河沙",56:"阿僧祇",60:"那由他",64:"不可思議",68:"無量大数",lit:72},josu:{1:"十",2:"百",3:"千",4:"万",8:"億",16:"兆",32:"京",64:"垓",128:"𥝱",256:"穣",512:"溝",1024:"澗",2048:"正",4096:"載",8192:"極",16384:"恒河沙",32768:"阿僧祇",65536:"那由他",131072:"不可思議",262144:"無量大数",lit:524288},formal:{1:"拾",2:"百",3:"千",4:"万",8:"億",12:"兆",16:"京",20:"垓",24:"𥝱",28:"穣",32:"溝",36:"澗",40:"正",44:"載",48:"極",52:"恒河沙",56:"阿僧祇",60:"那由他",64:"不可思議",68:"無量大数",lit:72}},specialUnitNames:{none:{},common:{20:"廿",30:"卅"},full:{20:"廿",30:"卅",40:"卌",200:"皕"}},smallUnitNames:{none:{},common:{1:"分",2:"厘",3:"毛",4:"糸"},wari:{1:"割",2:"分",3:"厘",4:"毛",5:"糸"},full:{1:"分",2:"厘",3:"毛",4:"糸",5:"忽",6:"微",7:"繊",8:"沙",9:"塵",10:"埃",11:"渺",12:"漠",13:"模糊",14:"逡巡",15:"須臾",16:"瞬息",17:"弾指",18:"刹那",19:"六徳",20:"虚空",21:"清浄"},wariFull:{1:"割",2:"分",3:"厘",4:"毛",5:"糸",6:"忽",7:"微",8:"繊",9:"沙",10:"塵",11:"埃",12:"渺",13:"漠",14:"模糊",15:"逡巡",16:"須臾",17:"瞬息",18:"弾指",19:"刹那",20:"六徳",21:"虚空",22:"清浄"}}},t.transcribeNumber=function(i,e){if(void 0===e&&(e=t.transcriptionConfigs.default),"string"==typeof e&&void 0===(e=t.transcriptionConfigs[e]))throw new ReferenceError('Transcription method "'+e+'" is undefined');if("object"!==n(e))throw new Error("You specified unknown config to japanese.transcribeNumber");if("string"==typeof(e=o({},t.transcriptionConfigs.default,e)).digits&&(e.digits=t.predefineedTranscriptionConfigs.digits[e.digits],void 0===e.digits))throw new ReferenceError('Transcription method of digits "'+e.digits+'" is undefined');if("string"==typeof e.unitNames&&(e.unitNames=t.predefineedTranscriptionConfigs.unitNames[e.unitNames],void 0===e.unitNames))throw new ReferenceError('Transcription method of unitNames "'+e.unitNames+'" is undefined');if("string"==typeof e.specialUnitNames&&(e.specialUnitNames=t.predefineedTranscriptionConfigs.specialUnitNames[e.specialUnitNames],void 0===e.specialUnitNames))throw new ReferenceError('Transcription method of specialUnitNames "'+e.specialUnitNames+'" is undefined');if("string"==typeof e.smallUnitNames&&(e.smallUnitNames=t.predefineedTranscriptionConfigs.smallUnitNames[e.smallUnitNames],void 0===e.smallUnitNames))throw new ReferenceError('Transcription method of smallUnitNames "'+e.smallUnitNames+'" is undefined');if("number"==typeof i)i=i.toString();else if("string"!=typeof i)throw new ReferenceError("Type of `number` is unsupported");var r=i.length;if("0"===i)return e.digits[0];var s="";"0"!==i.slice(-1)&&(s+=e.digits[i.slice(-1)]);var a=Object.keys(e.unitNames).map(function(t){return parseInt(t)}).filter(function(t,i,e){return e.indexOf(t)===i}).filter(function(t){return isFinite(t)&&t>0}).sort(function(t,i){return t-i});return a.forEach(function(n,o){var u=a[o+1]||1/0,l=i.slice(Math.max(r-u,0),Math.max(r-n,0));l.length>0&&(l.split("").every(function(t){return"0"===t})||(s=-1!==e.truncateOne.indexOf(e.unitNames[n])&&1===parseInt(l)?e.unitNames[n]+s:t.transcribeNumber(l,e)+e.unitNames[n]+s))}),s},t}},946:function(t,i,e){function n(t){return n="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},n(t)}var o=e(889);t.exports=function(t){t.romanizationTable={"あ":"a","い":"i","う":"u","え":"e","お":"o","か":"ka","き":"ki","く":"ku","け":"ke","こ":"ko","さ":"sa","し":"si","す":"su","せ":"se","そ":"so","た":"ta","ち":"ti","つ":"tu","て":"te","と":"to","な":"na","に":"ni","ぬ":"nu","ね":"ne","の":"no","は":"ha","ひ":"hi","ふ":"hu","へ":"he","ほ":"ho","ま":"ma","み":"mi","む":"mu","め":"me","も":"mo","や":"ya","ゆ":"yu","よ":"yo","ら":"ra","り":"ri","る":"ru","れ":"re","ろ":"ro","わ":"wa","ゐ":"wi","ゑ":"we","を":"wo","ん":"n","が":"ga","ぎ":"gi","ぐ":"gu","げ":"ge","ご":"go","ざ":"za","じ":"zi","ず":"zu","ぜ":"ze","ぞ":"zo","だ":"da","ぢ":"di","づ":"du","で":"de","ど":"do","ば":"ba","び":"bi","ぶ":"bu","べ":"be","ぼ":"bo","ゔ":"vu","ぱ":"pa","ぴ":"pi","ぷ":"pu","ぺ":"pe","ぽ":"po","きゃ":"kya","きゅ":"kyu","きぇ":"kye","きょ":"kyo","しゃ":"sya","しゅ":"syu","しぇ":"sye","しょ":"syo","ちゃ":"tya","ちゅ":"tyu","ちぇ":"tye","ちょ":"tyo","にゃ":"nya","にゅ":"nyu","にぇ":"nye","にょ":"nyo","ひゃ":"hya","ひゅ":"hyu","ひぇ":"hye","ひょ":"hyo","みゃ":"mya","みゅ":"my","みぇ":"mye","みょ":"myo","りゃ":"rya","りゅ":"ryu","りぇ":"rye","りょ":"ryo","ぎゃ":"gya","ぎゅ":"gyu","ぎぇ":"gye","ぎょ":"gyo","じゃ":"zya","じゅ":"zyu","じぇ":"zye","じょ":"zyo","ぢゃ":"dya","ぢゅ":"dyu","ぢぇ":"dye","ぢょ":"dyo","びゃ":"bya","びゅ":"byu","びぇ":"bye","びょ":"byo","ゔぁ":"va","ゔぃ":"vi","ゔぇ":"ve","ゔぉ":"vo","ぴゃ":"pya","ぴゅ":"pyu","ぴぇ":"pye","ぴょ":"pyo","いぃ":"yi","いぇ":"ye","うぁ":"wa","うぃ":"wi","うぅ":"wu","うぇ":"we","うぉ":"wo","うゅ":"wyu","ゔゃ":"vya","ゔゅ":"vyu","ゔょ":"vyo","くぁ":"kwa","くぃ":"kwi","くぅ":"kwu","くぇ":"kwe","くぉ":"kwo","くゎ":"kwa","ぐぁ":"gwa","ぐぃ":"gwi","ぐぅ":"gwu","ぐぇ":"gwe","ぐぉ":"gwo","ぐゎ":"gwa","すぃ":"si","ずぃ":"zi","つぁ":"tua","つぃ":"tui","つぇ":"tue","つぉ":"tuo","つゅ":"tuyu","づぁ":"dua","づぃ":"dui","づぇ":"due","づぉ":"duo","てゃ":"tea","てぃ":"tei","てゅ":"teu","てぇ":"tee","てょ":"teo","とぅ":"tou","でゃ":"dea","でぃ":"dei","でゅ":"deu","でぇ":"dee","でょ":"deo","どぅ":"dou","ふぁ":"hua","ふぃ":"hui","ふぇ":"hue","ふぉ":"huo","ふゃ":"huya","ふゅ":"huyu","ふょ":"huyo","ほぅ":"hu","ら゚":"la","り゚":"li","る゚":"lu","れ゚":"le","ろ゚":"lo","わ゙":"va","ゐ゙":"vi","ゑ゙":"ve","を゙":"vo","ぁ":"a","ぃ":"i","ぅ":"u","ぇ":"e","ぉ":"o","ゃ":"ya","ゅ":"yu","ょ":"yo","っ":"tu","ゎ":"wa","ヵ":"ka","ヶ":"ke"},t.romanizePuncutuationTable={"。":".","、":",","・":"-","－":"-","「":"“","」":"”","（":"(","）":")","　":" "," ":" "},t.defaultRomanizationConfig={"し":"shi","ち":"chi","つ":"tsu","ふ":"fu","じ":"ji","ぢ":"ji","づ":"zu","ああ":"aa","いい":"ii","うう":"ū","ええ":"ee","おお":"ō","あー":"ā","えい":"ei","おう":"ō","んあ":"n'a","んば":"nba","っち":"tchi","ゐ":"i","を":"o",punctuation:!0},t.romanizationConfigs={wikipedia:{},"traditional hepburn":{"を":"wo","んあ":"n-a","んば":"mba"},"modified hepburn":{"ああ":"ā","いい":"ii","うう":"ū","ええ":"ē","おお":"ō"},kunrei:{"し":"si","ち":"ti","つ":"tu","ふ":"hu","じ":"zi","ぢ":"zi","づ":"zu","ああ":"â","いい":"î","うう":"û","ええ":"ê","おお":"ô","あー":"â","おう":"ô","っち":"tti"},nihon:{"し":"si","ち":"ti","つ":"tu","ふ":"hu","じ":"zi","ぢ":"di","づ":"du","ああ":"ā","いい":"ī","うう":"ū","ええ":"ē","おお":"ō","あー":"ā","おう":"ō","っち":"tti","ゐ":"wi","を":"wo"}},t.romanize=function(i,e){if(void 0===e&&(e="wikipedia"),"string"==typeof e&&void 0===(e=t.romanizationConfigs[e]))throw new ReferenceError('Romanization method "'+e+'" is undefined');if("object"!==n(e))throw new Error("You specified unknown config to japanese.romanize");e=o({},t.defaultRomanizationConfig,e);var r=o({},t.romanizationTable);"shi"===e["し"]&&o(r,{"し":"shi","しゃ":"sha","しゅ":"shu","しぇ":"she","しょ":"sho"}),"chi"===e["ち"]&&o(r,{"ち":"chi","ちゃ":"cha","ちゅ":"chu","ちぇ":"che","ちょ":"cho","てぃ":"ti","てゅ":"tyu"}),"tsu"===e["つ"]&&o(r,{"つ":"tsu","つぁ":"tsa","つぃ":"tsi","つぇ":"tse","つぉ":"tso","つゅ":"tsyu","とぅ":"tu"}),"fu"===e["ふ"]&&o(r,{"ふ":"fu","ふぁ":"fa","ふぃ":"fi","ふぇ":"fe","ふぉ":"fo","ふゃ":"fya","ふゅ":"fyu","ふょ":"fyo"}),"ji"===e["じ"]&&o(r,{"じ":"ji","じゃ":"ja","じゅ":"ju","じぇ":"je","じょ":"jo"}),"ji"===e["ぢ"]&&o(r,{"ぢ":"ji","ぢゃ":"ja","ぢゅ":"ju","ぢぇ":"je","ぢょ":"jo","でぃ":"di","でゅ":"dyu"}),"zi"===e["ぢ"]&&o(r,{"ぢ":"zi","ぢゃ":"zya","ぢゅ":"zyu","ぢぇ":"zye","ぢょ":"zyo","でぃ":"di","でゅ":"dyu"}),"zu"===e["づ"]&&o(r,{"づ":"zu","づぁ":"zua","づぃ":"zui","づぇ":"zue","づぉ":"zuo","どぅ":"du"}),"i"===e["ゐ"]&&o(r,{"ゐ":"i","ゑ":"e"}),"o"===e["を"]&&o(r,{"を":"o"}),i=t.hiraganize(i);for(var s="",a="";i.length>0;){var u="";if(r[i.slice(0,2)]?(u=i.slice(0,2),i=i.slice(2)):(u=i[0],i=i.slice(1)),"っ"!==u){var l=r[u]||"";"っ"===a&&(l.match(/^[^aiueo]/)?l="ち"===u[0]?"tchi"===e["っち"]?{"ち":"tchi","ちゃ":"tcha","ちゅ":"tchu","ちぇ":"tche","ちょ":"tcho"}[u]:"cchi"===e["っち"]?{"ち":"cchi","ちゃ":"ccha","ちゅ":"cchu","ちぇ":"cche","ちょ":"ccho"}[u]:{"ち":"tti","ちゃ":"ttya","ちゅ":"ttyu","ちぇ":"ttye","ちょ":"ttyo"}[u]:l[0]+l:s+="'"),"ー"===u?s.match(/[aiueo]$/)?("a"===e["あー"]||("ah"===e["あー"]?s+="h":"a-"===e["あー"]?s+="-":"aa"===e["あー"]?s=s.slice(0,-1)+{a:"aa",i:"ii",u:"uu",e:"ee",o:"oo"}[s.slice(-1)]:"â"===e["あー"]?s=s.slice(0,-1)+{a:"â",i:"î",u:"û",e:"ê",o:"ô"}[s.slice(-1)]:"ā"===e["あー"]&&(s=s.slice(0,-1)+{a:"ā",i:"ī",u:"ū",e:"ē",o:"ō"}[s.slice(-1)])),l=""):l="-":"e"===s.slice(-1)&&"i"===l[0]?(l=l.slice(1),"ei"===e["えい"]?s+="i":"ee"===e["えい"]?s+="e":"eh"===e["えい"]?s+="h":"ê"===e["えい"]?s=s.slice(0,-1)+"ê":"ē"===e["えい"]?s=s.slice(0,-1)+"ē":e["えい"]):"o"===s.slice(-1)&&"u"===l[0]?(l=l.slice(1),"ou"===e["おう"]?s+="u":"oo"===e["おう"]?s+="o":"oh"===e["おう"]?s+="h":"ô"===e["おう"]?s=s.slice(0,-1)+"ô":"ō"===e["おう"]?s=s.slice(0,-1)+"ō":e["おう"]):s.match(/[aiueo]$/)&&s.slice(-1)===l[0]&&"を"!==u&&(l=l.slice(1),s=s.slice(0,-1)+e[{a:"ああ",i:"いい",u:"うう",e:"ええ",o:"おお"}[s.slice(-1)]]),l.match(/^[bpm]/)&&"ん"===a&&("nba"===e["んば"]||"mba"===e["んば"]&&(s=s.slice(0,-1)+"m")),l.match(/^[aiueoy]/)&&"ん"===a&&("na"===e["んあ"]||("n'a"===e["んあ"]?l="'"+l:"n-a"===e["んあ"]&&(l="-"+l))),e.punctuation&&t.romanizePuncutuationTable[u]&&(l=t.romanizePuncutuationTable[u]),s+=l,a=u}else a=u}return"っ"===a&&(s+="'"),s}}}},i={};function e(n){var o=i[n];if(void 0!==o)return o.exports;var r=i[n]={exports:{}};return t[n](r,r.exports,e),r.exports}e.d=function(t,i){for(var n in i)e.o(i,n)&&!e.o(t,n)&&Object.defineProperty(t,n,{enumerable:!0,get:i[n]})},e.o=function(t,i){return Object.prototype.hasOwnProperty.call(t,i)};var n={};function o(t){return o="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},o(t)}function r(t){return function(t){if(Array.isArray(t))return a(t)}(t)||function(t){if("undefined"!=typeof Symbol&&null!=t[Symbol.iterator]||null!=t["@@iterator"])return Array.from(t)}(t)||s(t)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function s(t,i){if(t){if("string"==typeof t)return a(t,i);var e={}.toString.call(t).slice(8,-1);return"Object"===e&&t.constructor&&(e=t.constructor.name),"Map"===e||"Set"===e?Array.from(t):"Arguments"===e||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(e)?a(t,i):void 0}}function a(t,i){(null==i||i>t.length)&&(i=t.length);for(var e=0,n=Array(i);e<i;e++)n[e]=t[e];return n}function u(t,i){for(var e=0;e<i.length;e++){var n=i[e];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(t,l(n.key),n)}}function l(t){var i=function(t){if("object"!=o(t)||!t)return t;var i=t[Symbol.toPrimitive];if(void 0!==i){var e=i.call(t,"string");if("object"!=o(e))return e;throw new TypeError("@@toPrimitive must return a primitive value.")}return String(t)}(t);return"symbol"==o(i)?i:i+""}e.d(n,{default:function(){return y}});var c=function(){return t=function t(i){!function(t,i){if(!(t instanceof i))throw new TypeError("Cannot call a class as a function")}(this,t),this.model=new Map(Object.entries(i).map(function(t){var i=function(t,i){return function(t){if(Array.isArray(t))return t}(t)||function(t,i){var e=null==t?null:"undefined"!=typeof Symbol&&t[Symbol.iterator]||t["@@iterator"];if(null!=e){var n,o,r,s,a=[],u=!0,l=!1;try{if(r=(e=e.call(t)).next,0===i){if(Object(e)!==e)return;u=!1}else for(;!(u=(n=r.call(e)).done)&&(a.push(n.value),a.length!==i);u=!0);}catch(t){l=!0,o=t}finally{try{if(!u&&null!=e.return&&(s=e.return(),Object(s)!==s))return}finally{if(l)throw o}}return a}}(t,i)||s(t,i)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}(t,2),e=i[0],n=i[1];return[e,new Map(Object.entries(n))]})),this.baseScore=-.5*r(this.model.values()).map(function(t){return r(t.values())}).flat().reduce(function(t,i){return t+i},0)},i=[{key:"parse",value:function(t){if(""===t)return[];var i,e=[],n=0,o=function(t){var i="undefined"!=typeof Symbol&&t[Symbol.iterator]||t["@@iterator"];if(!i){if(Array.isArray(t)||(i=s(t))){i&&(t=i);var e=0,n=function(){};return{s:n,n:function(){return e>=t.length?{done:!0}:{done:!1,value:t[e++]}},e:function(t){throw t},f:n}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var o,r=!0,a=!1;return{s:function(){i=i.call(t)},n:function(){var t=i.next();return r=t.done,t},e:function(t){a=!0,o=t},f:function(){try{r||null==i.return||i.return()}finally{if(a)throw o}}}}(this.parseBoundaries(t));try{for(o.s();!(i=o.n()).done;){var r=i.value;e.push(t.slice(n,r)),n=r}}catch(t){o.e(t)}finally{o.f()}return e.push(t.slice(n)),e}},{key:"parseBoundaries",value:function(t){for(var i,e,n,o,r,s,a,u,l,c,h,f,_,y=[],H=1;H<t.length;H++){var m=this.baseScore;m+=(null===(i=this.model.get("UW1"))||void 0===i?void 0:i.get(t.substring(H-3,H-2)))||0,m+=(null===(e=this.model.get("UW2"))||void 0===e?void 0:e.get(t.substring(H-2,H-1)))||0,m+=(null===(n=this.model.get("UW3"))||void 0===n?void 0:n.get(t.substring(H-1,H)))||0,m+=(null===(o=this.model.get("UW4"))||void 0===o?void 0:o.get(t.substring(H,H+1)))||0,m+=(null===(r=this.model.get("UW5"))||void 0===r?void 0:r.get(t.substring(H+1,H+2)))||0,m+=(null===(s=this.model.get("UW6"))||void 0===s?void 0:s.get(t.substring(H+2,H+3)))||0,m+=(null===(a=this.model.get("BW1"))||void 0===a?void 0:a.get(t.substring(H-2,H)))||0,m+=(null===(u=this.model.get("BW2"))||void 0===u?void 0:u.get(t.substring(H-1,H+1)))||0,m+=(null===(l=this.model.get("BW3"))||void 0===l?void 0:l.get(t.substring(H,H+2)))||0,m+=(null===(c=this.model.get("TW1"))||void 0===c?void 0:c.get(t.substring(H-3,H)))||0,m+=(null===(h=this.model.get("TW2"))||void 0===h?void 0:h.get(t.substring(H-2,H+1)))||0,m+=(null===(f=this.model.get("TW3"))||void 0===f?void 0:f.get(t.substring(H-1,H+2)))||0,(m+=(null===(_=this.model.get("TW4"))||void 0===_?void 0:_.get(t.substring(H,H+3)))||0)>0&&y.push(H)}return y}}],i&&u(t.prototype,i),Object.defineProperty(t,"prototype",{writable:!1}),t;var t,i}(),h=e(126),f=new c({UW3:{"。":6699,"に":3897,"、":4784,"の":3706,"が":4162,"を":5769,"は":4221,"と":2900,"る":2971,"く":2902,"も":3155,"う":2242,"て":2447,"で":3372,"た":2217,"い":1855,"な":2357,"っ":-1853,"方":2814,"ら":1353,"ん":967,"ば":1790,"］":2166,"か":1899,"，":3358,"り":1013,"！":3252,"ー":-102,"や":2149,"？":3703,"．":2093,"・":1074,"…":2428,"部":1732,"ど":992,"ご":-2327,"）":2573,"ッ":-2137,"☆":2675,"お":-1495,"上":428,"以":-1870,"つ":1078,"」":1608,"♪":2714,"電":-1669,"ク":335,"だ":866,"へ":2073,"ろ":1142,"笑":2335,"ず":1456,"面":475,"び":514,"あ":1179,"今":1080,"ぐ":2053,"分":1111,"感":1389,"大":-1134,"京":-1396,"中":998,"人":486,"場":-794,"イ":-568,"す":938,"さ":-599,"ま":-370,"利":-681,"間":752,"０":-870,"ぁ":1322,"フ":-1285,"ン":-284,"「":-1434,"当":-337,"き":530,"日":713,"ス":-901,"ゃ":1112,"後":1224,"々":1435,"シ":-1196,"度":982,"観":-976,"食":-517,"行":-725,"ド":-995,"リ":-636,"え":728,"空":902,"夜":1480,"ア":-700,"』":1404,"１":-550,"体":1e3,"秋":1464,"入":-819,"プ":-718,"昔":1287,"［":-960,"題":1113,"能":-710,"皆":1294,"む":920,"学":-552,"態":-749,"月":584,"係":701,"変":328,"超":976,"ぶ":672,"然":515,"〜":489,"れ":295,"由":680,"段":13,"非":768,"光":-218,"意":-477,"ぞ":825,"年":344,"べ":-711,"機":-463,"言":-419,"ち":363,"気":130,"み":275,"ｏ":-520,"＞":588,"し":181,"け":159,"移":-635,"見":160,"ズ":304,"自":-352,"果":767,"番":252,"色":469,"　":257,"ぱ":454,"出":-160,"屋":338,"カ":-102,"メ":-136,"指":-240,"店":203,"一":-50,"別":285,"頭":486,"朝":270,"想":398,"味":101,"生":-160,"語":159,"”":215,"着":-149,"所":189,"：":94,"神":-111,"応":149,"程":145,"不":-93,"料":-76,"寺":50,"水":54,"レ":-54,"パ":-29,"サ":33,"グ":12,"有":-16},UW4:{"。":-7440,"の":-4018,"が":-3577,"に":-4299,"て":-3839,"る":-5462,"、":-7452,"は":-3332,"っ":-4313,"で":-3120,"を":-4861,"う":-2446,"と":-2917,"り":-4081,"ま":-1296,"た":-1675,"あ":501,"れ":-4326,"な":-1928,"そ":456,"く":-2884,"か":-2662,"ら":-4391,"ご":591,"し":-1725,"こ":-517,"だ":-2037,"き":-2074,"い":-1531,"ん":-3821,"ー":-2899,"も":-2746,"み":-1111,"食":652,"行":411,"思":1386,"す":-1159,"空":2526,"大":788,"」":-5393,"じ":-2352,"や":-1257,"け":-3441,"め":-1867,"さ":-1716,"よ":-643,"「":2301,"表":1003,"日":695,"広":1811,"場":333,"一":576,"時":564,"ち":-1762,"冷":2351,"京":614,"，":-4205,"わ":-1624,"人":512,"私":1957,"！":-4469,"え":-1844,"ッ":-2189,"当":384,"・":-677,"ン":-2078,"１":710,"方":-816,"べ":-2964,"手":270,"来":430,"ろ":-2793,"せ":-1498,"ル":-1178,"ば":-2432,"つ":-1195,"使":1131,"（":2399,"持":180,"…":-2208,"ゆ":-2265,"？":-3412,"）":-4207,"ぶ":-2267,"何":1291,"彼":1247,"び":-1619,"笑":-3444,"本":-1249,"ど":-697,"［":1760,"．":-2874,"言":227,"お":820,"ず":-1966,"イ":-507,"今":1002,"ゃ":-2441,"見":386,"自":792,"２":533,"最":1072,"用":-716,"帯":-1138,"間":-393,"携":441,"多":1062,"リ":-707,"能":-1270,"』":-3209,"］":-1427,"気":235,"入":412,"有":744,"ね":-1659,"白":451,"ぁ":-1501,"ぎ":-1428,"中":34,"ひ":1076,"遊":1409,"”":-817,"風":673,"コ":344,"ょ":-1527,"水":286,"情":-375,"０":-374,"む":-1261,"合":-948,"公":724,"ぼ":-949,"♪":-1513,"小":736,"僕":856,"☆":-1296,"〜":-1156,"ド":-76,"楽":308,"全":475,"書":411,"ス":-218,"二":481,"態":-582,"少":436,"不":505,"返":-347,"定":-356,"ぜ":-907,"高":229,"特":623,"祭":413,"他":368,"づ":-776,"目":117,"ぞ":-935,"話":316,"子":-233,"ぐ":-840,"年":-625,"３":22,"道":181,"的":-500,"ｏ":-489,"実":368,"買":366,"無":192,"街":443,"東":470,"物":-204,"ュ":-434,"ほ":-176,"込":-568,"甘":383,"タ":-212,"換":-278,"現":191,"新":150,"夏":403,"フ":-157,"ト":-148,"げ":-455,"ざ":-327,"デ":174,"券":-471,"感":28,"秋":307,"難":179,"外":153,"へ":-247,"ョ":-156,"流":254,"舞":138,"サ":75,"前":-75,"店":101,"押":264,"開":61,"　":-148,"＾":-256,"度":-125,"５":52,"々":-142,"写":159,"回":-154,"ラ":-56,"関":-145,"安":63,"相":54,"参":45,"百":45,"取":-45,"ム":-41,"屋":-8,"通":-8,"勝":4,"美":4},UW5:{"。":-2177,"で":-955,"す":-681,"、":-1011,"な":-608,"ま":-353,"て":169,"っ":964,"る":175,"は":-874,"き":1177,"し":-394,"お":345,"を":-674,"く":287,"こ":500,"じ":886,"に":-612,"そ":-421,"能":219,"わ":710,"べ":1871,"え":637,"ん":1001,"あ":-271,"た":198,"み":293,"い":345,"・":-1082,"と":-617,"よ":-587,"の":-641,"ろ":-360,"上":-1087,"か":210,"だ":-338,"め":851,"帯":303,"れ":495,"ざ":1494,"ら":222,"ず":1173,"さ":-327,"つ":1091,"ル":-472,"面":776,"」":-1068,"電":-285,"ぼ":1415,"日":342,"が":-272,"び":826,"せ":-303,"思":-891,"ち":572,"冷":1123,"り":409,"年":876,"使":-1390,"利":365,"葉":791,"！":-384,"］":-470,"合":255,"ぶ":15,"券":-1133,"意":708,"ぐ":159,"バ":-254,"も":-93,"う":325,"入":-341,"移":-571,"ト":-313,"体":-1085,"当":401,"々":505,"分":173,"イ":171,"見":-272,"来":-122,"料":579,"寺":-461,"ぎ":348,"手":179,"続":-872,"む":458,"通":-209,"．":-184,"タ":244,"行":-180,"？":-192,"水":-154,"先":-562,"都":40,"一":-151,"ど":-41,"ば":209,"ア":-123,"学":49,"最":-116,"降":104,"ｏ":95,"へ":-146,"何":-176,"効":111,"ン":-30,"ょ":90,"ー":4,"　":-135,"（":-67,"種":42,"７":-101,"的":-54,"成":46,"ラ":29,"Ｎ":104,"１":-29,"有":-37,"中":8,"場":4},UW2:{"。":-1401,"、":-1370,"を":-2403,"に":-1207,"が":-653,"は":-1010,"か":18,"れ":5,"っ":269,"以":2215,"て":-985,"う":-489,"全":1762,"の":-695,"そ":-534,"で":-810,"だ":523,"ゆ":1668,"さ":922,"く":-812,"め":81,"と":-751,"も":-813,"あ":-233,"一":1197,"し":-49,"ん":344,"お":-711,"食":981,"ご":-682,"き":-556,"毎":1671,"結":1952,"彼":754,"少":676,"最":445,"ほ":1001,"わ":-118,"舞":2257,"上":-421,"よ":577,"同":567,"り":-479,"機":1341,"人":201,"意":531,"な":-492,"「":-482,"ば":-464,"関":745,"京":-377,"本":694,"い":-79,"大":266,"目":-1004,"多":387,"着":-477,"つ":-423,"ケ":-246,"振":-1313,"ゃ":283,"題":848,"手":663,"ひ":-1353,"容":956,"水":335,"我":-1421,"る":-207,"裏":-1437,"ー":274,"ぜ":567,"ぱ":396,"名":341,"フ":-264,"寺":-551,"葉":787,"ま":-173,"夕":826,"ぶ":435,"絶":1181,"高":498,"今":276,"友":494,"ら":-91,"ン":167,"た":-109,"み":-123,"料":70,"イ":-122,"電":315,"冷":-664,"打":557,"メ":-47,"世":-793,"パ":289,"女":-487,"ｒ":990,"プ":-195,"取":-360,"＾":149,"場":190,"こ":161,"，":-306,"落":-499,"選":313,"知":-361,"極":748,"入":-160,"良":183,"ラ":-210,"ス":54,"遊":-310,"用":-161,"式":93,"々":80,"車":124,"立":-292,"下":154,"ル":31,"甘":227,"実":97,"重":159,"乗":-115,"当":94,"：":106,"］":-50,"Ｈ":-84,"的":42,"相":75,"三":58,"け":16,"格":130,"正":100,"［":-16,"日":-25,"公":-33,"４":20,"ィ":-12,"ろ":-4},UW6:{"が":320,"。":-307,"て":-16,"で":219,"は":307,"し":581,"入":621,"ど":828,"あ":-496,"空":1589,"な":218,"す":-90,"だ":95,"め":1415,"券":1711,"さ":555,"ご":-283,"の":85,"性":2064,"う":35,"や":819,"り":578,"場":-864,"に":245,"つ":506,"ろ":352,"き":-17,"っ":301,"る":71,"か":231,"い":365,"ら":65,"そ":-101,"ば":527,"け":-213,"ー":-66,"ん":324,"彼":-1272,"ク":-346,"ル":207,"０":626,"く":240,"、":180,"食":-284,"遊":-906,"寺":611,"・":-639,"：":1217,"言":-361,"ゆ":755,"態":221,"込":679,"を":85,"的":479,"可":567,"タ":380,"気":415,"思":-111,"ぱ":813,"ま":170,"メ":239,"お":-18,"ピ":780,"カ":292,"送":-896,"来":-261,"過":846,"イ":-244,"効":-725,"シ":-130,"ケ":-388,"ず":-403,"ぶ":-248,"焼":643,"れ":119,"広":-150,"機":216,"わ":60,"ン":-64,"方":-235,"１":33,"こ":41,"店":164,"印":360,"び":129,"回":-94,"ぎ":280,"不":204,"も":-18,"自":123,"む":168,"パ":-112,"周":275,"出":68,"参":114,"神":33,"着":-20,"間":-4,"練":8,"ゃ":-4},UW1:{"は":-273,"う":275,"ま":128,"お":922,"ご":890,"と":165,"が":-385,"る":-34,"せ":210,"い":-91,"ん":289,"あ":-230,"で":-127,"学":209,"り":-102,"浮":1464,"に":-344,"甘":-1424,"つ":241,"バ":511,"な":-220,"て":60,"水":1969,"、":-26,"電":127,"当":-1038,"ふ":1899,"ら":72,"れ":-44,"携":-86,"を":-176,"そ":137,"っ":194,"ろ":303,"［":-601,"ー":113,"か":-110,"間":572,"ち":285,"ゆ":-428,"し":-30,"外":301,"フ":-155,"も":-96,"０":275,"空":-524,"ス":-251,"く":134,"自":412,"す":151,"用":599,"さ":-164,"チ":183,"ケ":-196,"入":266,"ツ":134,"困":574,"利":-371,"生":254,"機":318,"安":-400,"画":-53,"庭":619,"イ":211,"３":-258,"メ":96,"面":-306,"何":173,"こ":64,"問":588,"方":124,"白":-248,"じ":-49,"社":225,"様":365,"田":137,"国":-382,"込":42,"の":-31,"高":170,"。":-17,"ッ":117,"だ":63,"新":178,"．":-72,"ラ":92,"使":-79,"見":76,"？":113,"振":209,"！":65,"撮":-182,"券":79,"ざ":120,"周":137,"長":144,"や":-42,"山":114,"パ":63,"好":50,"ペ":126,"着":-16,"め":-12,"み":-8,"個":-79,"上":12,"え":-8,"連":-29,"ボ":16},BW2:{"たと":1475,"とお":-3875,"とい":274,"うや":-2003,"ない":-2999,"のみ":-2622,"てい":-1296,"であ":-3302,"のよ":-838,"です":-3035,"たま":-2116,"いた":-1737,"の機":-2082,"ので":-921,"でき":-2119,"には":-1012,"にも":-1213,"はじ":-2465,"、そ":-1810,"がと":-1022,"くな":-1771,"でも":-1689,"はな":-331,"のは":-1100,"ると":-643,"てお":-2518,"など":-1807,"帯電":-1351,"でし":-1856,"、と":-558,"また":-2737,"ただ":-2687,"くし":-1520,"るよ":-944,"いも":709,"もあ":-935,"りも":-1014,"てあ":-2039,"たい":-1183,"てみ":-1524,"そこ":-652,"もし":-490,"てく":-1248,"ども":-675,"うど":-1684,"の前":-820,"のだ":-873,"なく":-956,"にな":-362,"人が":1674,"んど":-722,"もの":-753,"いま":-421,"と思":545,"れた":-890,"はい":-770,"すご":-1196,"くだ":-1043,"・・":-1221,"てき":-1069,"がっ":-1494,"はあ":-1185,"では":-1027,"いつ":-659,"とな":159,"時間":-681,"がし":280,"にし":-458,"うま":-1227,"たち":-851,"のお":458,"ばい":-968,"、な":-145,"た時":421,"のも":-489,"とか":-782,"らな":-64,"なか":-299,"のか":-278,"でな":-1003,"たも":318,"とこ":-337,"もな":-157,"した":-402,"もつ":-433,"いい":-357,"ード":-523,"とき":-230,"もち":-157,"たよ":-393,"はで":41,"とも":-359,"いし":-401,"いよ":-494,"はず":-333,"やす":-524,"と同":-442,"よう":-175,"いな":-144,"ーな":476,"るの":-197,"しい":-297,"、１":-643,"ても":-151,"りな":191,"がよ":195,"の１":-539,"うか":-137,"、清":-374,"今日":-360,"とす":-127,"つの":186,"］京":-152,"うい":-93,"のが":-101,"い人":80,"けど":-126,"ーで":83,"がち":62,"の方":96,"らい":-54,"でい":-33,"てた":-37,"どこ":-20},BW1:{"のみ":3058,"以上":1223,"まま":2830,"から":1723,"たま":2162,"れた":1494,"白い":3534,"ちが":-2703,"めて":969,"ない":1045,"その":-1066,"では":-518,"った":166,"たと":-948,"こと":-1455,"くれ":922,"とか":1688,"るの":-1593,"うな":513,"たの":-1543,"のは":1277,"より":1376,"でも":667,"とが":-1393,"しい":917,"かも":-1290,"ック":631,"よう":-1620,"んな":471,"とう":1085,"。・":2456,"たら":949,"気に":-70,"ても":623,"利用":1018,"最近":1515,"がと":-1545,"この":-1039,"にも":816,"もつ":1694,"が、":1178,"れて":-1090,"りが":-96,"りと":1198,"んで":-325,"まだ":1343,"には":588,"もう":1414,"少し":1375,"とき":1349,"こそ":1413,"りも":1231,"れば":936,"けど":1014,"同じ":1427,"ると":202,"た．":1736,"まり":1018,"いう":138,"は、":436,"とい":-725,"い、":-329,"なら":1251,"思い":-1273,"て、":702,"ある":141,"って":-196,"で、":572,"なぜ":1571,"りに":356,"りの":-399,"まる":-429,"れる":350,"たい":242,"それ":293,"もし":1050,"の間":1155,"など":1137,"いの":-369,"うや":-1096,"だけ":391,"てい":-522,"とで":941,"くて":680,"んだ":515,"ケー":-781,"いで":-844,"普段":655,"のも":725,"思う":57,"えば":791,"きな":687,"に感":-579,"いた":310,"、と":310,"もの":-538,"ただ":398,"のが":482,"てる":372,"大変":401,"の後":753,"る人":626,"しか":96,"でき":-364,"るで":252,"まぁ":444,"使い":-715,"こう":-591,"かな":-137,"買い":-698,"！！":322,"める":-429,"に、":564,"０円":304,"、今":302,"ージ":789,"する":-159,"友達":625,"クル":437,"るに":-442,"やら":416,"。あ":-619,"きり":449,"と、":245,"の上":589,"ため":524,"まで":160,"か、":-255,"うち":218,"なく":149,"来て":386,"きた":236,"べき":424,"じて":254,"ぱり":342,"んど":-303,"・・":237,"だな":-302,"ろう":-315,"現在":281,"。３":274,"お店":199,"てた":147,"すら":190,"いも":-216,"にか":180,"いな":-98,"気が":115,"たり":102,"わら":-71,"実際":83,"とに":-20,"も、":29,"くさ":-24,"国人":24,"うか":12,"は１":37,"とは":-4},BW3:{"うま":4971,"もの":3479,"あり":1053,"いた":712,"よう":-404,"いう":719,"上が":1571,"ます":-943,"はじ":3173,"とう":-693,"たま":1383,"ちが":1979,"いい":1237,"おり":-2875,"のみ":3096,"可能":402,"ちゃ":-1016,"こと":899,"そこ":647,"でも":1643,"その":1844,"なっ":-512,"とい":-1257,"ある":-339,"この":1656,"とき":1917,"そう":-1050,"手に":1242,"から":-1223,"持っ":1098,"でき":980,"かけ":2909,"とて":2245,"なる":481,"はし":3011,"ちょ":1986,"して":278,"とお":678,"もら":2538,"メー":364,"ころ":-190,"そし":-184,"かか":1752,"もう":2306,"どん":-397,"・・":-1499,"より":-1463,"しま":-93,"とも":1038,"めて":-1778,"もん":1078,"いろ":832,"まぁ":1442,"だけ":-941,"した":813,"さん":-1566,"うち":444,"きっ":727,"よく":1082,"すご":897,"以上":-807,"ない":287,"ため":686,"これ":1075,"どう":296,"はま":1041,"す。":-152,"とっ":917,"来た":408,"しゃ":1283,"かっ":-802,"ただ":1198,"しい":-519,"すぐ":1094,"もと":1264,"やっ":422,"かも":-670,"める":-1304,"電車":121,"まし":-670,"いか":480,"パソ":589,"わか":691,"なく":348,"いる":556,"とこ":742,"中で":414,"さい":-672,"みた":-739,"かつ":821,"いて":-372,"なか":198,"なら":-160,"だい":680,"あっ":-93,"もっ":626,"また":-479,"いや":732,"考え":429,"うか":-268,"もつ":666,"まだ":296,"きま":-514,"まで":-677,"お茶":627,"こそ":-520,"とり":539,"いら":621,"です":-239,"まり":-596,"出来":-428,"つな":437,"ほし":-350,"たい":-238,"ここ":552,"はい":272,"行き":-218,"楽し":128,"し、":-136,"めっ":260,"んは":438,"出て":128,"いま":85,"つけ":251,"みが":-374,"まず":233,"だろ":-357,"ルー":249,"がち":-345,"料理":8,"祭り":214,"使っ":109,"と思":-161,"ぼく":329,"イン":203,"逆に":246,"で、":119,"どこ":46,"ずっ":121,"つい":62,"ませ":-58,"あの":71,"過ぎ":-95,"始め":-28,"まっ":-24,"程度":-24,"書い":12},TW3:{"という":970,"もなく":-1899,"ところ":-1724,"として":655,"、ある":-2756,"ている":-1375,"はない":-473,"のまま":-961,"すこと":710,"てしま":-1361,"らない":-1075,"はそれ":-1539,"ていく":-289,"とした":-1169,"と言っ":-1166,"ていう":769,"である":-749,"、なん":-293,"ること":-49,"であっ":-812,"となっ":229,"なんで":574,"いとこ":75,"もいい":-408,"もあり":-183,"であり":-535,"ういう":-120,"ばいい":-137,"にして":-37,"ていた":-66,"るとき":108,"でした":-54,"うこと":-4},TW4:{"ところ":2195,"ように":-1673,"くらい":1598,"した。":-1569,"ありま":-1767,"かなり":2848,"できた":2069,"ます。":-1366,"ような":-2232,"ことが":-824,"いた。":1066,"だから":1092,"うどん":1258,"そうで":-925,"ことに":-856,"もちろ":1697,"しかし":1383,"ことで":380,"ない。":191,"ことも":-588,"あり、":-595,"ちなみ":1130,"だった":-1150,"すると":406,"こと。":683,"でも、":628,"いろい":590,"いかな":651,"メール":256,"ようで":-896,"なかな":669,"なくな":253,"しない":438,"ソフト":512,"ことを":255,"わけで":-234,"まって":-824,"なんと":481,"すごい":314,"してき":278,"いえば":397,"らしい":424,"しかも":494,"ことは":-232,"あたり":-390,"食べて":140,"しても":-174,"できま":52,"なんか":116,"なんて":-102,"いくら":170,"観光客":-75,"いいと":-63,"いる。":37,"ちょっ":20,"そうい":16},TW2:{"気に入":-4086,"ではな":-1086,"とがあ":-1130,"かもし":-463,"んでい":-2306,"そもそ":-1441,"うにな":-803,"してい":-406,"でもあ":-936,"ったこ":-267,"しかな":440,"ともあ":-757,"からな":-477,"えるこ":-436,"でもな":-207,"とはい":-59,"えてい":50,"してお":-37},TW1:{"という":545,"ていく":1686,"ような":1298,"・・・":1104,"持って":-1851,"しかし":2079,"てくれ":1444,"のまま":1162,"かなり":2083,"やはり":1728,"ながら":1223,"ょうど":1174,"もなく":947,"思った":811,"とんど":1250,"、それ":412,"ない、":-1039,"なんと":-691,"を利用":-1017,"がって":-418,"ひとつ":732,"と思う":251,"ました":-268,"である":267,"かなか":698,"そして":556,"っかり":599,"。ただ":676,"リーグ":309,"きない":141,"はその":-68,"ちろん":196,"くさん":225,"ること":-271,"だって":164,"なって":-86,"すごく":163,"ろいろ":54,"。その":16,"くらい":4}});function _(){var t={"[一二三四五六七八九十百千万億兆]":"M","[一-龠々〆ヵヶ]":"H","[ぁ-ん]":"I","[ァ-ヴーｱ-ﾝﾞｰ]":"K","[a-zA-Zａ-ｚＡ-Ｚ]":"A","[0-9０-９]":"N"};for(var i in this.chartype_=[],t){var e=new RegExp;e.compile(i),this.chartype_.push([e,t[i]])}return this.BIAS__=-332,this.BC1__={HH:6,II:2461,KH:406,OH:-1378},this.BC2__={AA:-3267,AI:2744,AN:-878,HH:-4070,HM:-1711,HN:4012,HO:3761,IA:1327,IH:-1184,II:-1332,IK:1721,IO:5492,KI:3831,KK:-8741,MH:-3132,MK:3334,OO:-2920},this.BC3__={HH:996,HI:626,HK:-721,HN:-1307,HO:-836,IH:-301,KK:2762,MK:1079,MM:4034,OA:-1652,OH:266},this.BP1__={BB:295,OB:304,OO:-125,UB:352},this.BP2__={BO:60,OO:-1762},this.BQ1__={BHH:1150,BHM:1521,BII:-1158,BIM:886,BMH:1208,BNH:449,BOH:-91,BOO:-2597,OHI:451,OIH:-296,OKA:1851,OKH:-1020,OKK:904,OOO:2965},this.BQ2__={BHH:118,BHI:-1159,BHM:466,BIH:-919,BKK:-1720,BKO:864,OHH:-1139,OHM:-181,OIH:153,UHI:-1146},this.BQ3__={BHH:-792,BHI:2664,BII:-299,BKI:419,BMH:937,BMM:8335,BNN:998,BOH:775,OHH:2174,OHM:439,OII:280,OKH:1798,OKI:-793,OKO:-2242,OMH:-2402,OOO:11699},this.BQ4__={BHH:-3895,BIH:3761,BII:-4654,BIK:1348,BKK:-1806,BMI:-3385,BOO:-12396,OAH:926,OHH:266,OHK:-2036,ONN:-973},this.BW1__={",と":660,",同":727,"B1あ":1404,"B1同":542,"、と":660,"、同":727,"」と":1682,"あっ":1505,"いう":1743,"いっ":-2055,"いる":672,"うし":-4817,"うん":665,"から":3472,"がら":600,"こう":-790,"こと":2083,"こん":-1262,"さら":-4143,"さん":4573,"した":2641,"して":1104,"すで":-3399,"そこ":1977,"それ":-871,"たち":1122,"ため":601,"った":3463,"つい":-802,"てい":805,"てき":1249,"でき":1127,"です":3445,"では":844,"とい":-4915,"とみ":1922,"どこ":3887,"ない":5713,"なっ":3015,"など":7379,"なん":-1113,"にし":2468,"には":1498,"にも":1671,"に対":-912,"の一":-501,"の中":741,"ませ":2448,"まで":1711,"まま":2600,"まる":-2155,"やむ":-1947,"よっ":-2565,"れた":2369,"れで":-913,"をし":1860,"を見":731,"亡く":-1886,"京都":2558,"取り":-2784,"大き":-2604,"大阪":1497,"平方":-2314,"引き":-1336,"日本":-195,"本当":-2423,"毎日":-2113,"目指":-724,"Ｂ１あ":1404,"Ｂ１同":542,"｣と":1682},this.BW2__={"..":-11822,11:-669,"――":-5730,"−−":-13175,"いう":-1609,"うか":2490,"かし":-1350,"かも":-602,"から":-7194,"かれ":4612,"がい":853,"がら":-3198,"きた":1941,"くな":-1597,"こと":-8392,"この":-4193,"させ":4533,"され":13168,"さん":-3977,"しい":-1819,"しか":-545,"した":5078,"して":972,"しな":939,"その":-3744,"たい":-1253,"たた":-662,"ただ":-3857,"たち":-786,"たと":1224,"たは":-939,"った":4589,"って":1647,"っと":-2094,"てい":6144,"てき":3640,"てく":2551,"ては":-3110,"ても":-3065,"でい":2666,"でき":-1528,"でし":-3828,"です":-4761,"でも":-4203,"とい":1890,"とこ":-1746,"とと":-2279,"との":720,"とみ":5168,"とも":-3941,"ない":-2488,"なが":-1313,"など":-6509,"なの":2614,"なん":3099,"にお":-1615,"にし":2748,"にな":2454,"によ":-7236,"に対":-14943,"に従":-4688,"に関":-11388,"のか":2093,"ので":-7059,"のに":-6041,"のの":-6125,"はい":1073,"はが":-1033,"はず":-2532,"ばれ":1813,"まし":-1316,"まで":-6621,"まれ":5409,"めて":-3153,"もい":2230,"もの":-10713,"らか":-944,"らし":-1611,"らに":-1897,"りし":651,"りま":1620,"れた":4270,"れて":849,"れば":4114,"ろう":6067,"われ":7901,"を通":-11877,"んだ":728,"んな":-4115,"一人":602,"一方":-1375,"一日":970,"一部":-1051,"上が":-4479,"会社":-1116,"出て":2163,"分の":-7758,"同党":970,"同日":-913,"大阪":-2471,"委員":-1250,"少な":-1050,"年度":-8669,"年間":-1626,"府県":-2363,"手権":-1982,"新聞":-4066,"日新":-722,"日本":-7068,"日米":3372,"曜日":-601,"朝鮮":-2355,"本人":-2697,"東京":-1543,"然と":-1384,"社会":-1276,"立て":-990,"第に":-1612,"米国":-4268,"１１":-669},this.BW3__={"あた":-2194,"あり":719,"ある":3846,"い.":-1185,"い。":-1185,"いい":5308,"いえ":2079,"いく":3029,"いた":2056,"いっ":1883,"いる":5600,"いわ":1527,"うち":1117,"うと":4798,"えと":1454,"か.":2857,"か。":2857,"かけ":-743,"かっ":-4098,"かに":-669,"から":6520,"かり":-2670,"が,":1816,"が、":1816,"がき":-4855,"がけ":-1127,"がっ":-913,"がら":-4977,"がり":-2064,"きた":1645,"けど":1374,"こと":7397,"この":1542,"ころ":-2757,"さい":-714,"さを":976,"し,":1557,"し、":1557,"しい":-3714,"した":3562,"して":1449,"しな":2608,"しま":1200,"す.":-1310,"す。":-1310,"する":6521,"ず,":3426,"ず、":3426,"ずに":841,"そう":428,"た.":8875,"た。":8875,"たい":-594,"たの":812,"たり":-1183,"たる":-853,"だ.":4098,"だ。":4098,"だっ":1004,"った":-4748,"って":300,"てい":6240,"てお":855,"ても":302,"です":1437,"でに":-1482,"では":2295,"とう":-1387,"とし":2266,"との":541,"とも":-3543,"どう":4664,"ない":1796,"なく":-903,"など":2135,"に,":-1021,"に、":-1021,"にし":1771,"にな":1906,"には":2644,"の,":-724,"の、":-724,"の子":-1e3,"は,":1337,"は、":1337,"べき":2181,"まし":1113,"ます":6943,"まっ":-1549,"まで":6154,"まれ":-793,"らし":1479,"られ":6820,"るる":3818,"れ,":854,"れ、":854,"れた":1850,"れて":1375,"れば":-3246,"れる":1091,"われ":-605,"んだ":606,"んで":798,"カ月":990,"会議":860,"入り":1232,"大会":2217,"始め":1681,"市":965,"新聞":-5055,"日,":974,"日、":974,"社会":2024,"ｶ月":990},this.TC1__={AAA:1093,HHH:1029,HHM:580,HII:998,HOH:-390,HOM:-331,IHI:1169,IOH:-142,IOI:-1015,IOM:467,MMH:187,OOI:-1832},this.TC2__={HHO:2088,HII:-1023,HMM:-1154,IHI:-1965,KKH:703,OII:-2649},this.TC3__={AAA:-294,HHH:346,HHI:-341,HII:-1088,HIK:731,HOH:-1486,IHH:128,IHI:-3041,IHO:-1935,IIH:-825,IIM:-1035,IOI:-542,KHH:-1216,KKA:491,KKH:-1217,KOK:-1009,MHH:-2694,MHM:-457,MHO:123,MMH:-471,NNH:-1689,NNO:662,OHO:-3393},this.TC4__={HHH:-203,HHI:1344,HHK:365,HHM:-122,HHN:182,HHO:669,HIH:804,HII:679,HOH:446,IHH:695,IHO:-2324,IIH:321,III:1497,IIO:656,IOO:54,KAK:4845,KKA:3386,KKK:3065,MHH:-405,MHI:201,MMH:-241,MMM:661,MOM:841},this.TQ1__={BHHH:-227,BHHI:316,BHIH:-132,BIHH:60,BIII:1595,BNHH:-744,BOHH:225,BOOO:-908,OAKK:482,OHHH:281,OHIH:249,OIHI:200,OIIH:-68},this.TQ2__={BIHH:-1401,BIII:-1033,BKAK:-543,BOOO:-5591},this.TQ3__={BHHH:478,BHHM:-1073,BHIH:222,BHII:-504,BIIH:-116,BIII:-105,BMHI:-863,BMHM:-464,BOMH:620,OHHH:346,OHHI:1729,OHII:997,OHMH:481,OIHH:623,OIIH:1344,OKAK:2792,OKHH:587,OKKA:679,OOHH:110,OOII:-685},this.TQ4__={BHHH:-721,BHHM:-3604,BHII:-966,BIIH:-607,BIII:-2181,OAAA:-2763,OAKK:180,OHHH:-294,OHHI:2446,OHHO:480,OHIH:-1573,OIHH:1935,OIHI:-493,OIIH:626,OIII:-4007,OKAK:-8156},this.TW1__={"につい":-4681,"東京都":2026},this.TW2__={"ある程":-2049,"いった":-1256,"ころが":-2434,"しょう":3873,"その後":-4430,"だって":-1049,"ていた":1833,"として":-4657,"ともに":-4517,"もので":1882,"一気に":-792,"初めて":-1512,"同時に":-8097,"大きな":-1255,"対して":-2721,"社会党":-3216},this.TW3__={"いただ":-1734,"してい":1314,"として":-4314,"につい":-5483,"にとっ":-5989,"に当た":-6247,"ので,":-727,"ので、":-727,"のもの":-600,"れから":-3752,"十二月":-2287},this.TW4__={"いう.":8576,"いう。":8576,"からな":-2348,"してい":2958,"たが,":1516,"たが、":1516,"ている":1538,"という":1349,"ました":5543,"ません":1097,"ようと":-4258,"よると":5865},this.UC1__={A:484,K:93,M:645,O:-505},this.UC2__={A:819,H:1059,I:409,M:3987,N:5775,O:646},this.UC3__={A:-1370,I:2311},this.UC4__={A:-2643,H:1809,I:-1032,K:-3450,M:3565,N:3876,O:6646},this.UC5__={H:313,I:-1238,K:-799,M:539,O:-831},this.UC6__={H:-506,I:-253,K:87,M:247,O:-387},this.UP1__={O:-214},this.UP2__={B:69,O:935},this.UP3__={B:189},this.UQ1__={BH:21,BI:-12,BK:-99,BN:142,BO:-56,OH:-95,OI:477,OK:410,OO:-2422},this.UQ2__={BH:216,BI:113,OK:1759},this.UQ3__={BA:-479,BH:42,BI:1913,BK:-7198,BM:3160,BN:6427,BO:14761,OI:-827,ON:-3212},this.UW1__={",":156,"、":156,"「":-463,"あ":-941,"う":-127,"が":-553,"き":121,"こ":505,"で":-201,"と":-547,"ど":-123,"に":-789,"の":-185,"は":-847,"も":-466,"や":-470,"よ":182,"ら":-292,"り":208,"れ":169,"を":-446,"ん":-137,"・":-135,"主":-402,"京":-268,"区":-912,"午":871,"国":-460,"大":561,"委":729,"市":-411,"日":-141,"理":361,"生":-408,"県":-386,"都":-718,"｢":-463,"･":-135},this.UW2__={",":-829,"、":-829,"〇":892,"「":-645,"」":3145,"あ":-538,"い":505,"う":134,"お":-502,"か":1454,"が":-856,"く":-412,"こ":1141,"さ":878,"ざ":540,"し":1529,"す":-675,"せ":300,"そ":-1011,"た":188,"だ":1837,"つ":-949,"て":-291,"で":-268,"と":-981,"ど":1273,"な":1063,"に":-1764,"の":130,"は":-409,"ひ":-1273,"べ":1261,"ま":600,"も":-1263,"や":-402,"よ":1639,"り":-579,"る":-694,"れ":571,"を":-2516,"ん":2095,"ア":-587,"カ":306,"キ":568,"ッ":831,"三":-758,"不":-2150,"世":-302,"中":-968,"主":-861,"事":492,"人":-123,"会":978,"保":362,"入":548,"初":-3025,"副":-1566,"北":-3414,"区":-422,"大":-1769,"天":-865,"太":-483,"子":-1519,"学":760,"実":1023,"小":-2009,"市":-813,"年":-1060,"強":1067,"手":-1519,"揺":-1033,"政":1522,"文":-1355,"新":-1682,"日":-1815,"明":-1462,"最":-630,"朝":-1843,"本":-1650,"東":-931,"果":-665,"次":-2378,"民":-180,"気":-1740,"理":752,"発":529,"目":-1584,"相":-242,"県":-1165,"立":-763,"第":810,"米":509,"自":-1353,"行":838,"西":-744,"見":-3874,"調":1010,"議":1198,"込":3041,"開":1758,"間":-1257,"｢":-645,"｣":3145,"ｯ":831,"ｱ":-587,"ｶ":306,"ｷ":568},this.UW3__={",":4889,1:-800,"−":-1723,"、":4889,"々":-2311,"〇":5827,"」":2670,"〓":-3573,"あ":-2696,"い":1006,"う":2342,"え":1983,"お":-4864,"か":-1163,"が":3271,"く":1004,"け":388,"げ":401,"こ":-3552,"ご":-3116,"さ":-1058,"し":-395,"す":584,"せ":3685,"そ":-5228,"た":842,"ち":-521,"っ":-1444,"つ":-1081,"て":6167,"で":2318,"と":1691,"ど":-899,"な":-2788,"に":2745,"の":4056,"は":4555,"ひ":-2171,"ふ":-1798,"へ":1199,"ほ":-5516,"ま":-4384,"み":-120,"め":1205,"も":2323,"や":-788,"よ":-202,"ら":727,"り":649,"る":5905,"れ":2773,"わ":-1207,"を":6620,"ん":-518,"ア":551,"グ":1319,"ス":874,"ッ":-1350,"ト":521,"ム":1109,"ル":1591,"ロ":2201,"ン":278,"・":-3794,"一":-1619,"下":-1759,"世":-2087,"両":3815,"中":653,"主":-758,"予":-1193,"二":974,"人":2742,"今":792,"他":1889,"以":-1368,"低":811,"何":4265,"作":-361,"保":-2439,"元":4858,"党":3593,"全":1574,"公":-3030,"六":755,"共":-1880,"円":5807,"再":3095,"分":457,"初":2475,"別":1129,"前":2286,"副":4437,"力":365,"動":-949,"務":-1872,"化":1327,"北":-1038,"区":4646,"千":-2309,"午":-783,"協":-1006,"口":483,"右":1233,"各":3588,"合":-241,"同":3906,"和":-837,"員":4513,"国":642,"型":1389,"場":1219,"外":-241,"妻":2016,"学":-1356,"安":-423,"実":-1008,"家":1078,"小":-513,"少":-3102,"州":1155,"市":3197,"平":-1804,"年":2416,"広":-1030,"府":1605,"度":1452,"建":-2352,"当":-3885,"得":1905,"思":-1291,"性":1822,"戸":-488,"指":-3973,"政":-2013,"教":-1479,"数":3222,"文":-1489,"新":1764,"日":2099,"旧":5792,"昨":-661,"時":-1248,"曜":-951,"最":-937,"月":4125,"期":360,"李":3094,"村":364,"東":-805,"核":5156,"森":2438,"業":484,"氏":2613,"民":-1694,"決":-1073,"法":1868,"海":-495,"無":979,"物":461,"特":-3850,"生":-273,"用":914,"町":1215,"的":7313,"直":-1835,"省":792,"県":6293,"知":-1528,"私":4231,"税":401,"立":-960,"第":1201,"米":7767,"系":3066,"約":3663,"級":1384,"統":-4229,"総":1163,"線":1255,"者":6457,"能":725,"自":-2869,"英":785,"見":1044,"調":-562,"財":-733,"費":1777,"車":1835,"軍":1375,"込":-1504,"通":-1136,"選":-681,"郎":1026,"郡":4404,"部":1200,"金":2163,"長":421,"開":-1432,"間":1302,"関":-1282,"雨":2009,"電":-1045,"非":2066,"駅":1620,"１":-800,"｣":2670,"･":-3794,"ｯ":-1350,"ｱ":551,"ｸﾞ":1319,"ｽ":874,"ﾄ":521,"ﾑ":1109,"ﾙ":1591,"ﾛ":2201,"ﾝ":278},this.UW4__={",":3930,".":3508,"―":-4841,"、":3930,"。":3508,"〇":4999,"「":1895,"」":3798,"〓":-5156,"あ":4752,"い":-3435,"う":-640,"え":-2514,"お":2405,"か":530,"が":6006,"き":-4482,"ぎ":-3821,"く":-3788,"け":-4376,"げ":-4734,"こ":2255,"ご":1979,"さ":2864,"し":-843,"じ":-2506,"す":-731,"ず":1251,"せ":181,"そ":4091,"た":5034,"だ":5408,"ち":-3654,"っ":-5882,"つ":-1659,"て":3994,"で":7410,"と":4547,"な":5433,"に":6499,"ぬ":1853,"ね":1413,"の":7396,"は":8578,"ば":1940,"ひ":4249,"び":-4134,"ふ":1345,"へ":6665,"べ":-744,"ほ":1464,"ま":1051,"み":-2082,"む":-882,"め":-5046,"も":4169,"ゃ":-2666,"や":2795,"ょ":-1544,"よ":3351,"ら":-2922,"り":-9726,"る":-14896,"れ":-2613,"ろ":-4570,"わ":-1783,"を":13150,"ん":-2352,"カ":2145,"コ":1789,"セ":1287,"ッ":-724,"ト":-403,"メ":-1635,"ラ":-881,"リ":-541,"ル":-856,"ン":-3637,"・":-4371,"ー":-11870,"一":-2069,"中":2210,"予":782,"事":-190,"井":-1768,"人":1036,"以":544,"会":950,"体":-1286,"作":530,"側":4292,"先":601,"党":-2006,"共":-1212,"内":584,"円":788,"初":1347,"前":1623,"副":3879,"力":-302,"動":-740,"務":-2715,"化":776,"区":4517,"協":1013,"参":1555,"合":-1834,"和":-681,"員":-910,"器":-851,"回":1500,"国":-619,"園":-1200,"地":866,"場":-1410,"塁":-2094,"士":-1413,"多":1067,"大":571,"子":-4802,"学":-1397,"定":-1057,"寺":-809,"小":1910,"屋":-1328,"山":-1500,"島":-2056,"川":-2667,"市":2771,"年":374,"庁":-4556,"後":456,"性":553,"感":916,"所":-1566,"支":856,"改":787,"政":2182,"教":704,"文":522,"方":-856,"日":1798,"時":1829,"最":845,"月":-9066,"木":-485,"来":-442,"校":-360,"業":-1043,"氏":5388,"民":-2716,"気":-910,"沢":-939,"済":-543,"物":-735,"率":672,"球":-1267,"生":-1286,"産":-1101,"田":-2900,"町":1826,"的":2586,"目":922,"省":-3485,"県":2997,"空":-867,"立":-2112,"第":788,"米":2937,"系":786,"約":2171,"経":1146,"統":-1169,"総":940,"線":-994,"署":749,"者":2145,"能":-730,"般":-852,"行":-792,"規":792,"警":-1184,"議":-244,"谷":-1e3,"賞":730,"車":-1481,"軍":1158,"輪":-1433,"込":-3370,"近":929,"道":-1291,"選":2596,"郎":-4866,"都":1192,"野":-1100,"銀":-2213,"長":357,"間":-2344,"院":-2297,"際":-2604,"電":-878,"領":-1659,"題":-792,"館":-1984,"首":1749,"高":2120,"｢":1895,"｣":3798,"･":-4371,"ｯ":-724,"ｰ":-11870,"ｶ":2145,"ｺ":1789,"ｾ":1287,"ﾄ":-403,"ﾒ":-1635,"ﾗ":-881,"ﾘ":-541,"ﾙ":-856,"ﾝ":-3637},this.UW5__={",":465,".":-299,1:-514,E2:-32768,"]":-2762,"、":465,"。":-299,"「":363,"あ":1655,"い":331,"う":-503,"え":1199,"お":527,"か":647,"が":-421,"き":1624,"ぎ":1971,"く":312,"げ":-983,"さ":-1537,"し":-1371,"す":-852,"だ":-1186,"ち":1093,"っ":52,"つ":921,"て":-18,"で":-850,"と":-127,"ど":1682,"な":-787,"に":-1224,"の":-635,"は":-578,"べ":1001,"み":502,"め":865,"ゃ":3350,"ょ":854,"り":-208,"る":429,"れ":504,"わ":419,"を":-1264,"ん":327,"イ":241,"ル":451,"ン":-343,"中":-871,"京":722,"会":-1153,"党":-654,"務":3519,"区":-901,"告":848,"員":2104,"大":-1296,"学":-548,"定":1785,"嵐":-1304,"市":-2991,"席":921,"年":1763,"思":872,"所":-814,"挙":1618,"新":-1682,"日":218,"月":-4353,"査":932,"格":1356,"機":-1508,"氏":-1347,"田":240,"町":-3912,"的":-3149,"相":1319,"省":-1052,"県":-4003,"研":-997,"社":-278,"空":-813,"統":1955,"者":-2233,"表":663,"語":-1073,"議":1219,"選":-1018,"郎":-368,"長":786,"間":1191,"題":2368,"館":-689,"１":-514,"Ｅ２":-32768,"｢":363,"ｲ":241,"ﾙ":451,"ﾝ":-343},this.UW6__={",":227,".":808,1:-270,E1:306,"、":227,"。":808,"あ":-307,"う":189,"か":241,"が":-73,"く":-121,"こ":-200,"じ":1782,"す":383,"た":-428,"っ":573,"て":-1014,"で":101,"と":-105,"な":-253,"に":-149,"の":-417,"は":-236,"も":-206,"り":187,"る":-135,"を":195,"ル":-673,"ン":-496,"一":-277,"中":201,"件":-800,"会":624,"前":302,"区":1792,"員":-1212,"委":798,"学":-960,"市":887,"広":-695,"後":535,"業":-697,"相":753,"社":-507,"福":974,"空":-822,"者":1811,"連":463,"郎":1082,"１":-270,"Ｅ１":306,"ﾙ":-673,"ﾝ":-496},this}_.prototype.ctype_=function(t){for(var i in this.chartype_)if(t.match(this.chartype_[i][0]))return this.chartype_[i][1];return"O"},_.prototype.ts_=function(t){return t||0},_.prototype.segment=function(t){if(null==t||null==t||""==t)return[];var i=[],e=["B3","B2","B1"],n=["O","O","O"],o=t.split("");for(l=0;l<o.length;++l)e.push(o[l]),n.push(this.ctype_(o[l]));e.push("E1"),e.push("E2"),e.push("E3"),n.push("O"),n.push("O"),n.push("O");for(var r=e[3],s="U",a="U",u="U",l=4;l<e.length-3;++l){var c=this.BIAS__,h=e[l-3],f=e[l-2],_=e[l-1],y=e[l],H=e[l+1],m=e[l+2],p=n[l-3],d=n[l-2],O=n[l-1],I=n[l],b=n[l+1],g=n[l+2];c+=this.ts_(this.UP1__[s]),c+=this.ts_(this.UP2__[a]),c+=this.ts_(this.UP3__[u]),c+=this.ts_(this.BP1__[s+a]),c+=this.ts_(this.BP2__[a+u]),c+=this.ts_(this.UW1__[h]),c+=this.ts_(this.UW2__[f]),c+=this.ts_(this.UW3__[_]),c+=this.ts_(this.UW4__[y]),c+=this.ts_(this.UW5__[H]),c+=this.ts_(this.UW6__[m]),c+=this.ts_(this.BW1__[f+_]),c+=this.ts_(this.BW2__[_+y]),c+=this.ts_(this.BW3__[y+H]),c+=this.ts_(this.TW1__[h+f+_]),c+=this.ts_(this.TW2__[f+_+y]),c+=this.ts_(this.TW3__[_+y+H]),c+=this.ts_(this.TW4__[y+H+m]),c+=this.ts_(this.UC1__[p]),c+=this.ts_(this.UC2__[d]),c+=this.ts_(this.UC3__[O]),c+=this.ts_(this.UC4__[I]),c+=this.ts_(this.UC5__[b]),c+=this.ts_(this.UC6__[g]),c+=this.ts_(this.BC1__[d+O]),c+=this.ts_(this.BC2__[O+I]),c+=this.ts_(this.BC3__[I+b]),c+=this.ts_(this.TC1__[p+d+O]),c+=this.ts_(this.TC2__[d+O+I]),c+=this.ts_(this.TC3__[O+I+b]),c+=this.ts_(this.TC4__[I+b+g]),c+=this.ts_(this.UQ1__[s+p]),c+=this.ts_(this.UQ2__[a+d]),c+=this.ts_(this.UQ3__[u+O]),c+=this.ts_(this.BQ1__[a+d+O]),c+=this.ts_(this.BQ2__[a+O+I]),c+=this.ts_(this.BQ3__[u+d+O]),c+=this.ts_(this.BQ4__[u+O+I]),c+=this.ts_(this.TQ1__[a+p+d+O]),c+=this.ts_(this.TQ2__[a+d+O+I]),c+=this.ts_(this.TQ3__[u+p+d+O]);var v="O";(c+=this.ts_(this.TQ4__[u+d+O+I]))>0&&(i.push(r),r="",v="B"),s=a,a=u,u=v,r+=e[l]}return i.push(r),i};var y={japanese:h,parser:f,tinysegmenter:new _};window.audubon=n.default}();