/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.decomposition;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.data.LogSign;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.UpperTriangularMatrix;

public class LUDecomposition {
    private final FastMatrix lu;
    private final int[] pivot;

    public LUDecomposition(FastMatrix lu, int[] pivot) {
        this.lu = lu;
        this.pivot = pivot;
    }

    public LUDecomposition(FastMatrix lu) {
        this.lu = lu;
        this.pivot = null;
    }

    public LogSign logDeterminant() {
        return LogSign.of((DoubleSeq)this.lu.diagonal(), this.pivotSign() == -1);
    }

    public DoubleSeq uDiagonal() {
        return this.lu.diagonal();
    }

    public FastMatrix lu() {
        return this.lu;
    }

    public int rank(double rcond) {
        return UpperTriangularMatrix.rank(this.lu, rcond);
    }

    public int[] pivot() {
        return this.pivot;
    }

    public int pivotSign() {
        if (this.pivot == null) {
            return 1;
        }
        int n = 0;
        for (int i = 0; i < this.pivot.length; ++i) {
            for (int j = 0; j < i; ++j) {
                if (this.pivot[j] <= this.pivot[i]) continue;
                ++n;
            }
        }
        return n % 2 == 0 ? 1 : -1;
    }

    public int[] reversePivot() {
        if (this.pivot == null) {
            return null;
        }
        int[] rpiv = new int[this.pivot.length];
        for (int i = 0; i < this.pivot.length; ++i) {
            rpiv[this.pivot[i]] = i;
        }
        return rpiv;
    }

    public void solve(DataBlock b) {
        if (this.pivot != null) {
            this.swap(b);
        }
        LowerTriangularMatrix.solveL1x(this.lu, b);
        UpperTriangularMatrix.solveUx(this.lu, b);
    }

    public void solve(FastMatrix B) {
        if (this.pivot != null) {
            this.swap(B);
        }
        LowerTriangularMatrix.solveL1X(this.lu, B);
        UpperTriangularMatrix.solveUX(this.lu, B);
    }

    private void swap(DataBlock b) {
        double[] tmp = b.toArray();
        for (int i = 0; i < this.pivot.length; ++i) {
            b.set(i, tmp[this.pivot[i]]);
        }
    }

    private void swap(FastMatrix B) {
        double[] tmp = new double[this.lu.getRowsCount()];
        DataBlockIterator cols = B.columnsIterator();
        while (cols.hasNext()) {
            DataBlock b = cols.next();
            b.copyTo(tmp, 0);
            for (int i = 0; i < this.pivot.length; ++i) {
                b.set(i, tmp[this.pivot[i]]);
            }
        }
    }

    @FunctionalInterface
    public static interface Decomposer {
        public LUDecomposition decompose(FastMatrix var1, double var2);
    }
}

