# enrichit 0.1.2

+ improve robustness of `calculate_qvalue()` (2026-02-02, Mon)
    - handle missing `qvalue` package gracefully
    - retry with different parameters if `qvalue()` fails
    - handle invalid p-values (NA, infinite, out of range)
+ validate p-values in `ora_gson()` (2026-02-02, Mon)
    - ensure p-values are within [0, 1] range
    - warn and report invalid p-values
+ optimize ORA p-value calculation in C++ (2026-02-02, Mon)
    - use `phyper` instead of summing `dhyper` for better performance and precision

# enrichit 0.1.1

+ update `setReadable()` to support converting gene ID to other types (not limited to SYMBOL) (2026-01-21, Wed)
+ add `organism` slot in `compareClusterResult` (2026-01-20, Tue)

# enrichit 0.1.0

+ fix bugs in `gsea_gson()` and `ora_gson()` (2026-01-11, Sun)
    - handle missing columns (e.g., qvalues) gracefully by filling with NA
    - handle `NA` or duplicate gene set IDs in result rownames to prevent errors
+ improve robustness of `calculate_qvalue()` (2026-01-11, Sun)
    - return NA instead of NULL when qvalue calculation fails
+ update `ora_gson()` output columns (2026-01-11, Sun)

# enrichit 0.0.9

+ add leading edge analysis for GSEA (2026-01-10, Sat)

# enrichit 0.0.8

+ fixed bugs of multilevel GSEA in p value calculation (2025-12-10, Wed)
    - by learning the source code of 'fgsea'

# enrichit 0.0.7

+ add `gseaScores` function (2025-12-07, Sun)
    - to calculate GSEA scores for a single gene set

# enrichit 0.0.6

+ add vignette (2025-12-07, Sun)

# enrichit 0.0.5

+ implement multi-level GSEA algorithm (2025-12-06, Sat)
    
# enrichit 0.0.4

+ implement a simplified adaptive early-stopping GSEA algorithm (2025-12-05, Fri)
    - For each gene set:
    - 1. Run initial batch (e.g., 1000 permutations)
    - 2. If p-value > threshold (e.g., 0.05), stop
    - 3. If significant, increase permutations geometrically (2x, 4x, 8x...)
    - 4. Continue until p-value stabilizes or max permutations reached

# enrichit 0.0.3

+ implement `ora_gson` and `gsea_gson` (2025-12-05, Fri)
    - as replacement for `enricher_internal` and `GSEA_internal`
+ mv helper functions and class definitions from `DOSE` to `enrichit` (2025-12-05, Fri)
    - to extend this package as the base package for the `clusterProfiler` family

# enrichplot 0.0.2

+ `gsea` function (2025-12-04, Thu)
    - Gene Set Enrichment Analysis (GSEA) using C++ via Rcpp.

# enrichit 0.0.1

+ `ora` function (2025-12-03, Wed)
    - Fast Over-Representation Analysis (ORA) using C++ via Rcpp.
