## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
skip_vignette <- !reticulate::py_module_available("kuzu")

## ----eval=FALSE---------------------------------------------------------------
# remotes::install_github("WickM/kuzuR")

## ----eval=FALSE---------------------------------------------------------------
# install.packages("kuzuR")

## ----eval=!skip_vignette------------------------------------------------------
library(kuzuR)

# Create an in-memory database connection
con <- kuzu_connection(":memory:")

## ----eval=!skip_vignette------------------------------------------------------
kuzu_execute(con, paste("CREATE NODE TABLE Person(name STRING, age INT64,",
                        "PRIMARY KEY (name))"))
kuzu_execute(con, "CREATE REL TABLE Knows(FROM Person TO Person, since INT64)")

## ----eval=!skip_vignette------------------------------------------------------
# Create a data frame of persons
persons_df <- data.frame(
  name = c("Alice", "Bob", "Carol"),
  age = c(35, 45, 25)
)

# Create a data frame of relationships
knows_df <- data.frame(
  from_person = c("Alice", "Bob"),
  to_person = c("Bob", "Carol"),
  since = c(2010, 2015)
)

# Load data into Kuzu
kuzu_copy_from_df(con, persons_df, "Person")
kuzu_copy_from_df(con, knows_df, "Knows")

## ----eval=!skip_vignette------------------------------------------------------
# Execute a query
result <- kuzu_execute(con, paste("MATCH (a:Person)-[k:Knows]->(b:Person)",
                                  "RETURN a.name, b.name, k.since"))

# Convert the result to a data frame
df <- as.data.frame(result)
print(df)

