/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.tsp.cube;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class CubeId {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final CubeId VOID = new CubeId(EMPTY_STRING_ARRAY, EMPTY_STRING_ARRAY);
    private final String[] dimensionIds;
    private final String[] dimensionsValues;

    @NonNull
    public static CubeId root(String ... dimensionIds) throws IllegalArgumentException {
        if (dimensionIds == null) {
            throw new NullPointerException("dimensionIds is marked non-null but is null");
        }
        for (String o : dimensionIds) {
            if (o != null) continue;
            throw new IllegalArgumentException("Dimensions cannot be null");
        }
        return dimensionIds.length == 0 ? VOID : new CubeId((String[])dimensionIds.clone(), EMPTY_STRING_ARRAY);
    }

    @NonNull
    public static CubeId root(@NonNull List<String> dimensionIds) throws IllegalArgumentException {
        if (dimensionIds == null) {
            throw new NullPointerException("dimensionIds is marked non-null but is null");
        }
        for (String o : dimensionIds) {
            if (o != null) continue;
            throw new IllegalArgumentException("Dimensions cannot be null");
        }
        return dimensionIds.isEmpty() ? VOID : new CubeId(dimensionIds.toArray(new String[dimensionIds.size()]), EMPTY_STRING_ARRAY);
    }

    private CubeId(@NonNull String[] dimensionIds, @NonNull String[] dimensionsValues) {
        if (dimensionIds == null) {
            throw new NullPointerException("dimensionIds is marked non-null but is null");
        }
        if (dimensionsValues == null) {
            throw new NullPointerException("dimensionsValues is marked non-null but is null");
        }
        this.dimensionsValues = dimensionsValues;
        this.dimensionIds = dimensionIds;
    }

    public int getLevel() {
        return this.dimensionsValues.length;
    }

    public int getMaxLevel() {
        return this.dimensionIds.length;
    }

    @NonNull
    public String getDimensionValue(int index) throws IndexOutOfBoundsException {
        return this.dimensionsValues[index];
    }

    @NonNull
    public Stream<String> getDimensionValueStream() {
        return Stream.of(this.dimensionsValues);
    }

    @NonNull
    public String getDimensionId(int index) throws IndexOutOfBoundsException {
        return this.dimensionIds[index];
    }

    public int getDepth() {
        return this.getMaxLevel() - this.getLevel();
    }

    public boolean isRoot() {
        return this.getLevel() == 0;
    }

    public boolean isSeries() {
        return this.getLevel() == this.getMaxLevel();
    }

    public boolean isVoid() {
        return this.getMaxLevel() == 0;
    }

    @NonNull
    public CubeId child(@NonNull String[] dimensionValues, int length) throws IllegalArgumentException {
        Objects.requireNonNull(dimensionValues);
        if (length == 0) {
            return this;
        }
        int level = this.getLevel();
        if (level + length > this.getMaxLevel()) {
            throw new IllegalArgumentException("Too much values");
        }
        String[] result = new String[level + length];
        for (int i = 0; i < length; ++i) {
            result[i + level] = dimensionValues[i];
            if (result[i + level] != null) continue;
            throw new IllegalArgumentException("Dimension values cannot be null");
        }
        System.arraycopy(this.dimensionsValues, 0, result, 0, level);
        return new CubeId(this.dimensionIds, result);
    }

    @NonNull
    public CubeId child(String ... dimensionValues) throws IllegalArgumentException {
        if (dimensionValues == null) {
            throw new NullPointerException("dimensionValues is marked non-null but is null");
        }
        return this.child(dimensionValues, dimensionValues.length);
    }

    public boolean isAncestorOf(@NonNull CubeId input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (!this.haveSameDimensions(this, input) || this.getLevel() >= input.getLevel()) {
            return false;
        }
        for (int i = this.getLevel() - 1; i >= 0; --i) {
            if (input.getDimensionValue(i).equals(this.getDimensionValue(i))) continue;
            return false;
        }
        return true;
    }

    @Nullable CubeId getParent() {
        return this.getAncestor(this.getLevel() - 1);
    }

    public @Nullable CubeId getAncestor(int level) {
        return 0 <= level && level < this.getLevel() ? new CubeId(this.dimensionIds, Arrays.copyOf(this.dimensionsValues, level)) : null;
    }

    public String toString() {
        return Arrays.toString(this.dimensionsValues);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof CubeId && this.equals((CubeId)obj);
    }

    public int hashCode() {
        return Arrays.deepHashCode(this.dimensionIds) + Arrays.deepHashCode(this.dimensionsValues);
    }

    private boolean equals(@NonNull CubeId that) {
        if (that == null) {
            throw new NullPointerException("that is marked non-null but is null");
        }
        return CubeId.equalsReversed(this.dimensionsValues, that.dimensionsValues) && Arrays.equals(this.dimensionIds, that.dimensionIds);
    }

    private static boolean equalsReversed(@Nullable Object[] l, @Nullable Object[] r) {
        if (l == r) {
            return true;
        }
        if (l == null || r == null || l.length != r.length) {
            return false;
        }
        for (int i = l.length - 1; i >= 0; --i) {
            if (Objects.equals(l[i], r[i])) continue;
            return false;
        }
        return true;
    }

    private boolean haveSameDimensions(CubeId l, CubeId r) {
        return Arrays.equals(l.dimensionIds, r.dimensionIds);
    }
}

