/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.com.github.miachm.sods;

import java.util.HashMap;
import java.util.Map;
import standalone_spreadsheet.com.github.miachm.sods.Color;
import standalone_spreadsheet.com.github.miachm.sods.ColumnStyle;
import standalone_spreadsheet.com.github.miachm.sods.ConditionalFormat;
import standalone_spreadsheet.com.github.miachm.sods.RowStyle;
import standalone_spreadsheet.com.github.miachm.sods.Style;
import standalone_spreadsheet.com.github.miachm.sods.TableStyle;
import standalone_spreadsheet.com.github.miachm.sods.XmlReaderInstance;

class StylesParser {
    private Map<String, Style> cellStyles = new HashMap<String, Style>();
    private Map<String, ColumnStyle> columnStyles = new HashMap<String, ColumnStyle>();
    private Map<String, RowStyle> rowStyles = new HashMap<String, RowStyle>();
    private Map<String, TableStyle> tableStyles = new HashMap<String, TableStyle>();

    public StylesParser() {
        this.cellStyles.put("Default", new Style());
    }

    public void parseStyles(XmlReaderInstance reader) {
        if (reader == null) {
            return;
        }
        while (reader.hasNext()) {
            XmlReaderInstance instance = reader.nextElement("style:style");
            if (instance == null) {
                return;
            }
            String name = instance.getAttribValue("style:name");
            String family = instance.getAttribValue("style:family");
            if (name == null || family == null) continue;
            switch (family) {
                case "table-cell": {
                    Style style = this.readCellStyleEntry(instance);
                    this.cellStyles.put(name, style);
                    break;
                }
                case "table-column": {
                    ColumnStyle columnStyle = this.readColumnStyleEntry(instance);
                    this.columnStyles.put(name, columnStyle);
                    break;
                }
                case "table-row": {
                    RowStyle rowStyle = this.readRowStyleEntry(instance);
                    this.rowStyles.put(name, rowStyle);
                    break;
                }
                case "table": {
                    TableStyle tableStyle = this.readTableStyleEntry(instance);
                    this.tableStyles.put(name, tableStyle);
                }
            }
        }
    }

    private Style readCellStyleEntry(XmlReaderInstance reader) {
        Style style = new Style();
        while (reader.hasNext()) {
            XmlReaderInstance instance = reader.nextElement("style:text-properties", "style:table-cell-properties", "style:paragraph-properties", "style:map");
            if (instance == null) {
                return style;
            }
            switch (instance.getTag()) {
                case "style:text-properties": {
                    String fontsize;
                    String fontcolor;
                    String underline;
                    String italic;
                    String bold = instance.getAttribValue("fo:font-weight");
                    if (bold != null) {
                        style.setBold(bold.equals("bold"));
                    }
                    if ((italic = instance.getAttribValue("fo:font-style")) != null) {
                        style.setItalic(italic.equals("italic"));
                    }
                    if ((underline = instance.getAttribValue("style:text-underline-style")) != null) {
                        style.setUnderline(underline.equals("solid"));
                    }
                    if ((fontcolor = instance.getAttribValue("fo:color")) != null && !fontcolor.equals("transparent")) {
                        try {
                            style.setFontColor(new Color(fontcolor));
                        }
                        catch (IllegalArgumentException e) {
                            System.err.println(e.getMessage());
                        }
                    }
                    if ((fontsize = instance.getAttribValue("fo:font-size")) == null || !fontsize.endsWith("pt")) break;
                    try {
                        int index = fontsize.lastIndexOf("pt");
                        int fontSize = (int)Math.round(Double.parseDouble(fontsize.substring(0, index)));
                        style.setFontSize(fontSize);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Error, invalid font size " + fontsize);
                    }
                    break;
                }
                case "style:table-cell-properties": {
                    String verticalAlign;
                    String backgroundColor = instance.getAttribValue("fo:background-color");
                    if (backgroundColor != null && !backgroundColor.equals("transparent")) {
                        try {
                            style.setBackgroundColor(new Color(backgroundColor));
                        }
                        catch (IllegalArgumentException e) {
                            System.err.println(e.getMessage());
                        }
                    }
                    if ((verticalAlign = instance.getAttribValue("style:vertical-align")) == null) break;
                    Style.VERTICAL_TEXT_ALIGMENT pos = null;
                    switch (verticalAlign.toLowerCase()) {
                        case "middle": {
                            pos = Style.VERTICAL_TEXT_ALIGMENT.Middle;
                            break;
                        }
                        case "top": {
                            pos = Style.VERTICAL_TEXT_ALIGMENT.Top;
                            break;
                        }
                        case "bottom": {
                            pos = Style.VERTICAL_TEXT_ALIGMENT.Bottom;
                        }
                    }
                    style.setVerticalTextAligment(pos);
                    break;
                }
                case "style:paragraph-properties": {
                    String align = instance.getAttribValue("fo:text-align");
                    if (align == null) break;
                    Style.TEXT_ALIGMENT pos = null;
                    switch (align) {
                        case "center": {
                            pos = Style.TEXT_ALIGMENT.Center;
                            break;
                        }
                        case "end": {
                            pos = Style.TEXT_ALIGMENT.Right;
                            break;
                        }
                        case "start": {
                            pos = Style.TEXT_ALIGMENT.Left;
                        }
                    }
                    style.setTextAligment(pos);
                    break;
                }
                case "style:map": {
                    String key = instance.getAttribValue("style:apply-style-name");
                    String condition = instance.getAttribValue("style:condition");
                    if (key == null || condition == null) break;
                    Style other = this.cellStyles.get(key);
                    if (other == null) {
                        other = new Style();
                        this.cellStyles.put(key, other);
                    }
                    ConditionalFormat conditionalFormat = new ConditionalFormat(other, condition);
                    style.addCondition(conditionalFormat);
                }
            }
        }
        return style;
    }

    private ColumnStyle readColumnStyleEntry(XmlReaderInstance reader) {
        ColumnStyle style = new ColumnStyle();
        while (reader.hasNext()) {
            XmlReaderInstance instance = reader.nextElement("style:table-column-properties");
            if (instance == null) {
                return style;
            }
            String columnWidth = instance.getAttribValue("style:column-width");
            if (columnWidth == null) continue;
            style.setWidth(columnWidth);
        }
        return style;
    }

    private RowStyle readRowStyleEntry(XmlReaderInstance reader) {
        RowStyle style = new RowStyle();
        while (reader.hasNext()) {
            XmlReaderInstance instance = reader.nextElement("style:table-row-properties");
            if (instance == null) {
                return style;
            }
            String rowHeight = instance.getAttribValue("style:row-height");
            if (rowHeight == null) continue;
            style.setHeight(rowHeight);
        }
        return style;
    }

    private TableStyle readTableStyleEntry(XmlReaderInstance reader) {
        TableStyle style = new TableStyle();
        while (reader.hasNext()) {
            XmlReaderInstance instance = reader.nextElement("style:table-properties");
            if (instance == null) {
                return style;
            }
            String display = instance.getAttribValue("table:display");
            if (display == null) continue;
            style.setHidden(display.equals("false"));
        }
        return style;
    }

    public Style getCellStyle(String name) {
        return this.cellStyles.get(name);
    }

    public ColumnStyle getColumnStyle(String name) {
        return this.columnStyles.get(name);
    }

    public RowStyle getRowStyle(String name) {
        return this.rowStyles.get(name);
    }

    public TableStyle getTableStyle(String name) {
        return this.tableStyles.get(name);
    }
}

