/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.stats.RobustStandardDeviationComputer;

public class FastDifferencingModule {
    private int[] d;
    private double tmean;
    private final int[] maxd;
    private final boolean mad;
    private final double centile;
    private final double k;
    private final double tstat;

    public static Builder builder() {
        return new Builder();
    }

    private FastDifferencingModule(int[] maxd, boolean mad, double centile, double k, double tstat) {
        this.maxd = maxd;
        this.mad = mad;
        this.k = k;
        this.tstat = tstat;
        this.centile = centile;
    }

    public boolean isMeanCorrection() {
        return Math.abs(this.tmean) > this.tstat;
    }

    private double std(DoubleSeq z) {
        if (!this.mad) {
            return Math.sqrt(z.ssqc(z.average()) / (double)z.length());
        }
        return RobustStandardDeviationComputer.mad(this.centile, this.mad).compute(z);
    }

    public int[] process(DoubleSeq x, int[] periods, int[] start) {
        boolean ok;
        DataBlock z = DataBlock.of(x);
        if (start != null) {
            for (int j = 0; j < periods.length; ++j) {
                for (int i = 0; i < start[0]; ++i) {
                    z.autoApply(-periods[j], (a, b) -> a - b);
                    z = z.drop(periods[j], 0);
                }
            }
            this.d = (int[])start.clone();
        } else {
            this.d = new int[periods.length];
        }
        double refe = this.std((DoubleSeq)z);
        do {
            ok = false;
            for (int j = 0; j < periods.length; ++j) {
                if (this.d[j] >= this.maxd[j]) continue;
                DataBlock tmp = z.deepClone();
                tmp.autoApply(-periods[j], (a, b) -> a - b);
                tmp = tmp.drop(periods[j], 0);
                double e = this.std((DoubleSeq)tmp);
                if (!(e < refe * this.k)) continue;
                z = tmp;
                refe = e;
                int n = j;
                this.d[n] = this.d[n] + 1;
                if (this.d[n] >= this.maxd[j]) continue;
                ok = true;
            }
        } while (ok);
        this.testMean((DoubleSeq)z);
        return this.d;
    }

    private void testMean(DoubleSeq z) {
        double s = z.sum();
        double s2 = z.ssq();
        int n = z.length();
        this.tmean = s / Math.sqrt((s2 * (double)n - s * s) / (double)n);
    }

    public double getTmean() {
        return this.tmean;
    }

    public double getK() {
        return this.k;
    }

    public double getTstat() {
        return this.tstat;
    }

    public boolean isMad() {
        return this.mad;
    }

    public static class Builder {
        public static final int MAXD = 2;
        public static final int MAXBD = 1;
        private int[] maxd = new int[]{2, 1};
        private double k = 1.2;
        private double tstat = 1.96;
        private boolean mad = true;
        private double centile = 90.0;

        private Builder() {
        }

        public Builder maxDifferencing(int[] maxd) {
            this.maxd = (int[])maxd.clone();
            return this;
        }

        public Builder mad(boolean mad) {
            this.mad = mad;
            return this;
        }

        public Builder centile(double centile) {
            this.centile = centile;
            return this;
        }

        public Builder k(double k) {
            this.k = k;
            return this;
        }

        public Builder tstat(double tstat) {
            this.tstat = tstat;
            return this;
        }

        public FastDifferencingModule build() {
            return new FastDifferencingModule(this.maxd, this.mad, this.centile, this.k, this.tstat);
        }
    }
}

