/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.arima;

import java.util.Arrays;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.arima.AutoCovarianceFunction;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.math.polynomials.RationalFunction;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.StateComponent;
import jdplus.toolkit.base.core.ssf.basic.Loading;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class SsfAr2 {
    public static StateComponent of(@NonNull double[] ar, double var, int nlags, int fcasts) {
        if (ar == null) {
            throw new NullPointerException("ar is marked non-null but is null");
        }
        if (ar.length == 0) {
            throw new IllegalArgumentException();
        }
        if (fcasts < ar.length - 1) {
            fcasts = ar.length - 1;
        }
        Polynomial p = SsfAr2.polynomial(ar);
        AutoCovarianceFunction acf = SsfAr2.acf(p, var);
        double[] psi = SsfAr2.psi(p).coefficients(fcasts + 1);
        Data data = new Data(ar, psi, var, acf, nlags);
        return new StateComponent(new Initialization(data), new Dynamics(data));
    }

    public static ISsfLoading defaultLoading(int nlags) {
        return Loading.fromPosition(nlags);
    }

    private static Polynomial polynomial(double[] phi) {
        double[] c = new double[1 + phi.length];
        c[0] = 1.0;
        for (int i = 0; i < phi.length; ++i) {
            c[i + 1] = -phi[i];
        }
        return Polynomial.ofInternal(c);
    }

    private static AutoCovarianceFunction acf(Polynomial ar, double var) {
        return new AutoCovarianceFunction(Polynomial.ONE, ar, var);
    }

    private static RationalFunction psi(Polynomial ar) {
        return RationalFunction.of(Polynomial.ONE, ar);
    }

    @Generated
    private SsfAr2() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class Data {
        private final double[] phi;
        private final double[] psi;
        private final double var;
        private final AutoCovarianceFunction acf;
        private final int nlags;

        int dim() {
            return this.psi.length + this.nlags;
        }

        int last() {
            return this.psi.length + this.nlags - 1;
        }

        double se() {
            return Math.sqrt(this.var);
        }

        @Generated
        public Data(double[] phi, double[] psi, double var, AutoCovarianceFunction acf, int nlags) {
            this.phi = phi;
            this.psi = psi;
            this.var = var;
            this.acf = acf;
            this.nlags = nlags;
        }

        @Generated
        public double[] getPhi() {
            return this.phi;
        }

        @Generated
        public double[] getPsi() {
            return this.psi;
        }

        @Generated
        public double getVar() {
            return this.var;
        }

        @Generated
        public AutoCovarianceFunction getAcf() {
            return this.acf;
        }

        @Generated
        public int getNlags() {
            return this.nlags;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Data)) {
                return false;
            }
            Data other = (Data)o;
            if (Double.compare(this.getVar(), other.getVar()) != 0) {
                return false;
            }
            if (this.getNlags() != other.getNlags()) {
                return false;
            }
            if (!Arrays.equals(this.getPhi(), other.getPhi())) {
                return false;
            }
            if (!Arrays.equals(this.getPsi(), other.getPsi())) {
                return false;
            }
            AutoCovarianceFunction this$acf = this.getAcf();
            AutoCovarianceFunction other$acf = other.getAcf();
            return !(this$acf == null ? other$acf != null : !this$acf.equals(other$acf));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $var = Double.doubleToLongBits(this.getVar());
            result = result * 59 + (int)($var >>> 32 ^ $var);
            result = result * 59 + this.getNlags();
            result = result * 59 + Arrays.hashCode(this.getPhi());
            result = result * 59 + Arrays.hashCode(this.getPsi());
            AutoCovarianceFunction $acf = this.getAcf();
            result = result * 59 + ($acf == null ? 43 : $acf.hashCode());
            return result;
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "SsfAr2.Data(phi=" + Arrays.toString(this.getPhi()) + ", psi=" + Arrays.toString(this.getPsi()) + ", var=" + this.getVar() + ", acf=" + String.valueOf(this.getAcf()) + ", nlags=" + this.getNlags() + ")";
        }
    }

    private static class Initialization
    implements ISsfInitialization {
        private final Data info;

        Initialization(Data info) {
            this.info = info;
        }

        @Override
        public int getStateDim() {
            return this.info.dim();
        }

        @Override
        public boolean isDiffuse() {
            return false;
        }

        @Override
        public int getDiffuseDim() {
            return 0;
        }

        @Override
        public void diffuseConstraints(FastMatrix b) {
        }

        @Override
        public void a0(DataBlock a0) {
        }

        @Override
        public void Pi0(FastMatrix pf0) {
        }

        @Override
        public void Pf0(FastMatrix pf0) {
            int dim = this.info.psi.length;
            int nl = this.info.nlags;
            this.info.acf.prepare(dim + nl);
            pf0.diagonal().set(this.info.acf.get(0));
            for (int i = 1; i < dim + nl; ++i) {
                pf0.subDiagonal(i).set(this.info.acf.get(i));
                pf0.subDiagonal(-i).set(this.info.acf.get(i));
            }
            int j = 0;
            int J = nl;
            while (j < dim - 1) {
                double psij = this.info.psi[j];
                pf0.set(J + 1, J + 1, pf0.get(J, J) - psij * psij * this.info.var);
                int k = 0;
                int K = nl;
                while (k < j) {
                    double q = pf0.get(J, K) - psij * this.info.psi[k] * this.info.var;
                    pf0.set(J + 1, K + 1, q);
                    pf0.set(K + 1, J + 1, q);
                    ++k;
                    ++K;
                }
                ++j;
                ++J;
            }
        }
    }

    static class Dynamics
    implements ISsfDynamics {
        private final Data data;
        private final DataBlock z;
        private final FastMatrix V;

        static FastMatrix v(double var, double[] psi) {
            FastMatrix v = SymmetricMatrix.xxt(DataBlock.of(psi));
            v.mul(var);
            return v;
        }

        public Dynamics(Data data) {
            this.data = data;
            this.z = DataBlock.make(data.dim());
            this.V = Dynamics.v(data.var, data.psi);
        }

        @Override
        public void T(int pos, FastMatrix tr) {
            this.T(tr);
        }

        public void T(FastMatrix tr) {
            tr.subDiagonal(1).set(1.0);
            int l = this.data.last();
            for (int i = 0; i < this.data.phi.length; ++i) {
                tr.set(l, l - i, this.data.phi[i]);
            }
        }

        @Override
        public void TVT(int pos, FastMatrix vm) {
            int l = this.data.last();
            this.z.set(0.0);
            DataBlockIterator cols = vm.reverseColumnsIterator();
            for (int i = 0; i < this.data.phi.length; ++i) {
                this.z.addAY(this.data.phi[i], cols.next());
            }
            this.TX(pos, this.z);
            vm.upLeftShift(1);
            vm.column(l).copy(this.z);
            vm.row(l).copy(this.z);
        }

        @Override
        public void TX(int pos, DataBlock x) {
            double z = 0.0;
            DoubleSeqCursor reader = x.reverseReader();
            for (int i = 0; i < this.data.phi.length; ++i) {
                z += this.data.phi[i] * reader.getAndNext();
            }
            x.bshift(1);
            x.set(this.data.last(), z);
        }

        @Override
        public void XT(int pos, DataBlock x) {
            int l = this.data.last();
            double last = x.get(l);
            x.fshift(1);
            x.set(0, 0.0);
            if (last != 0.0) {
                int i = 0;
                int j = l;
                while (i < this.data.phi.length) {
                    if (this.data.phi[i] != 0.0) {
                        x.add(j, last * this.data.phi[i]);
                    }
                    ++i;
                    --j;
                }
            }
        }

        @Override
        public boolean isTimeInvariant() {
            return true;
        }

        @Override
        public boolean areInnovationsTimeInvariant() {
            return true;
        }

        @Override
        public int getInnovationsDim() {
            return 1;
        }

        @Override
        public void V(int pos, FastMatrix qm) {
            qm.extract(this.data.nlags, this.data.psi.length, this.data.nlags, this.data.psi.length).copy(this.V);
        }

        @Override
        public void S(int pos, FastMatrix sm) {
            DataBlock s = sm.column(0).drop(this.data.nlags, 0);
            s.copyFrom(this.data.psi, 0);
            s.mul(this.data.se());
        }

        @Override
        public boolean hasInnovations(int pos) {
            return true;
        }

        @Override
        public void addV(int pos, FastMatrix p) {
            p.extract(this.data.nlags, this.data.psi.length, this.data.nlags, this.data.psi.length).add(this.V);
        }

        @Override
        public void XS(int pos, DataBlock x, DataBlock sx) {
            double a = x.drop(this.data.nlags, 0).dot(DataBlock.of(this.data.psi)) * this.data.se();
            sx.set(0, a);
        }

        @Override
        public void addSU(int pos, DataBlock x, DataBlock u) {
            double a = u.get(this.data.nlags) * this.data.se();
            x.addAY(a, DataBlock.of(this.data.psi));
        }
    }
}

