/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.diagnostics;

import jdplus.toolkit.base.api.stats.ProbabilityType;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.core.dstats.Normal;

public class SignificantSeasonalityTest {
    private final Position pos;
    private final double limit;

    public static int[] test(TsData s, TsData es, TsData fs, TsData fes, double sig) {
        int[] rslt = new int[3];
        if (s != null && es != null) {
            SignificantSeasonalityTest thist = new SignificantSeasonalityTest(Position.Middle, sig);
            rslt[0] = thist.significantSeasonalFactors(s, es);
            SignificantSeasonalityTest tend = new SignificantSeasonalityTest(Position.End, sig);
            rslt[1] = tend.significantSeasonalFactors(s, es);
        } else {
            rslt[1] = -1;
            rslt[0] = -1;
        }
        if (fs != null && fes != null) {
            SignificantSeasonalityTest tfcast = new SignificantSeasonalityTest(Position.Start, sig);
            rslt[2] = tfcast.significantSeasonalFactors(fs, fes);
        } else {
            rslt[2] = -1;
        }
        return rslt;
    }

    public SignificantSeasonalityTest() {
        this.pos = Position.End;
        Normal N = new Normal();
        this.limit = N.getProbabilityInverse(0.005, ProbabilityType.Upper);
    }

    public SignificantSeasonalityTest(Position pos, double eps) {
        this.pos = pos;
        Normal N = new Normal();
        this.limit = N.getProbabilityInverse(eps / 2.0, ProbabilityType.Upper);
    }

    public int significantSeasonalFactors(TsData s, TsData es) {
        int i0 = this.start(s.getDomain());
        if (i0 < 0) {
            return -1;
        }
        int i1 = i0 + s.getAnnualFrequency();
        int ns = 0;
        for (int i = i0; i < i1; ++i) {
            if (!(Math.abs(s.getValue(i)) / es.getValue(i) > this.limit)) continue;
            ++ns;
        }
        return ns;
    }

    public boolean[] significantSeasons(TsData s, TsData es) {
        int i0 = this.start(s.getDomain());
        if (i0 < 0) {
            return null;
        }
        int f = s.getAnnualFrequency();
        boolean[] ss = new boolean[f];
        for (int j = 0; j < f; ++j) {
            ss[j] = Math.abs(s.getValue(i0 + j)) / es.getValue(i0 + j) > this.limit;
        }
        return ss;
    }

    private int start(TsDomain s) {
        int f;
        int n = s.getLength();
        if (n < (f = s.getAnnualFrequency())) {
            return -1;
        }
        return switch (this.pos.ordinal()) {
            case 0 -> 0;
            case 1 -> (n - f) / 2;
            default -> n - f;
        };
    }

    public static enum Position {
        Start,
        Middle,
        End;

    }
}

