/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.modelling.highfreq;

import jdplus.toolkit.base.api.timeseries.TimeSelector;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class EstimateSpec {
    public static final EstimateSpec DEFAULT = EstimateSpec.builder().build();
    public static final boolean DEF_APP_HESSIAN = false;
    public static final double EPS = 1.0E-7;
    @NonNull
    private final TimeSelector span;
    private final double precision;
    private final boolean approximateHessian;

    public static Builder builder() {
        return new Builder().span(TimeSelector.all()).precision(1.0E-7).approximateHessian(false);
    }

    public boolean isDefault() {
        return this.equals(DEFAULT);
    }

    @Generated
    EstimateSpec(@NonNull TimeSelector span, double precision, boolean approximateHessian) {
        if (span == null) {
            throw new NullPointerException("span is marked non-null but is null");
        }
        this.span = span;
        this.precision = precision;
        this.approximateHessian = approximateHessian;
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        return new Builder().span(this.span).precision(this.precision).approximateHessian(this.approximateHessian);
    }

    @NonNull
    @Generated
    public TimeSelector getSpan() {
        return this.span;
    }

    @Generated
    public double getPrecision() {
        return this.precision;
    }

    @Generated
    public boolean isApproximateHessian() {
        return this.approximateHessian;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EstimateSpec)) {
            return false;
        }
        EstimateSpec other = (EstimateSpec)o;
        if (Double.compare(this.getPrecision(), other.getPrecision()) != 0) {
            return false;
        }
        if (this.isApproximateHessian() != other.isApproximateHessian()) {
            return false;
        }
        TimeSelector this$span = this.getSpan();
        TimeSelector other$span = other.getSpan();
        return !(this$span == null ? other$span != null : !((Object)this$span).equals(other$span));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $precision = Double.doubleToLongBits(this.getPrecision());
        result = result * 59 + (int)($precision >>> 32 ^ $precision);
        result = result * 59 + (this.isApproximateHessian() ? 79 : 97);
        TimeSelector $span = this.getSpan();
        result = result * 59 + ($span == null ? 43 : ((Object)$span).hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "EstimateSpec(span=" + String.valueOf(this.getSpan()) + ", precision=" + this.getPrecision() + ", approximateHessian=" + this.isApproximateHessian() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private TimeSelector span;
        @Generated
        private double precision;
        @Generated
        private boolean approximateHessian;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder span(@NonNull TimeSelector span) {
            if (span == null) {
                throw new NullPointerException("span is marked non-null but is null");
            }
            this.span = span;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder precision(double precision) {
            this.precision = precision;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder approximateHessian(boolean approximateHessian) {
            this.approximateHessian = approximateHessian;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull EstimateSpec build() {
            return new EstimateSpec(this.span, this.precision, this.approximateHessian);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "EstimateSpec.Builder(span=" + String.valueOf(this.span) + ", precision=" + this.precision + ", approximateHessian=" + this.approximateHessian + ")";
        }
    }
}

