/*
 * Decompiled with CFR 0.152.
 */
package usf.saav.common.algorithm;

public class ArrayDisjointSet {
    protected int[] sets;

    public ArrayDisjointSet(int n) {
        this.clear(n);
    }

    public void clear(int n) {
        this.sets = new int[n];
        for (int i = 0; i < n; ++i) {
            this.sets[i] = i;
        }
    }

    public void invalidateSet(int n) {
        int n2 = this.get(n);
        if (n2 >= 0) {
            this.sets[n2] = -1;
        }
    }

    public int get(int n) {
        while (n != -1) {
            if (this.sets[n] == -1) {
                return -1;
            }
            if (this.sets[n] == n) {
                return n;
            }
            this.sets[n] = this.sets[this.sets[n]];
            n = this.sets[n];
        }
        return -1;
    }

    public int find(int n) {
        return this.get(n);
    }

    public void join(int n, int n2) {
        n = this.get(n);
        n2 = this.get(n2);
        if (n == -1 || n2 == -1) {
            if (n != -1) {
                this.sets[n] = -1;
            }
            if (n2 != -1) {
                this.sets[n2] = -1;
            }
        } else {
            this.sets[n2] = n;
        }
    }

    public int union(int n, int n2) {
        int n3;
        int n4 = this.find(n);
        if (n4 < (n3 = this.find(n2))) {
            this.sets[n3] = n4;
            return n4;
        }
        this.sets[n4] = n3;
        return n3;
    }
}

