/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.nbbrd.io.function;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import lombok.NonNull;

@FunctionalInterface
public interface IORunnable {
    public void runWithIO() throws IOException;

    @NonNull
    default public Closeable asCloseable() {
        return this::runWithIO;
    }

    @NonNull
    default public Runnable asUnchecked() {
        return () -> {
            try {
                this.runWithIO();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    @NonNull
    public static Runnable unchecked(@NonNull IORunnable o) {
        if (o == null) {
            throw new NullPointerException("o is marked non-null but is null");
        }
        return o.asUnchecked();
    }

    @NonNull
    public static IORunnable checked(@NonNull Runnable o) {
        if (o == null) {
            throw new NullPointerException("o is marked non-null but is null");
        }
        return () -> {
            try {
                o.run();
            }
            catch (UncheckedIOException e) {
                throw e.getCause();
            }
        };
    }

    @NonNull
    public static IORunnable noOp() {
        return () -> {};
    }
}

